/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;

public class ExtensionGroups {
    private static ExtensionGroups instance = new ExtensionGroups();
    public static final String NOT_IN_EXTENSION_GROUP = "*NOT_IN_EXTENSION_GROUP*";
    private HashMap<String, ExtensionGroup> _groups = new HashMap();
    private HashMap<String, String> _memberToGroup = new HashMap();
    private boolean _errorsChecked;

    public static ExtensionGroups getInstance() {
        return instance;
    }

    private ExtensionGroups() {
    }

    public String getExtensionGroupOfMember(String extensionId) {
        this.checkErrors();
        String groupId = this._memberToGroup.get(extensionId);
        if (groupId == null) {
            groupId = NOT_IN_EXTENSION_GROUP;
        }
        return groupId;
    }

    public boolean isExtensionMemberOfAnyGroup(String extensionId) {
        this.checkErrors();
        return this._memberToGroup.get(extensionId) != null;
    }

    public List<String> getExtensionGroupMembers(String extensionGroupId) {
        this.checkErrors();
        ArrayList<String> members = new ArrayList<String>();
        ExtensionGroup group = this._groups.get(extensionGroupId);
        if (group != null) {
            for (Map.Entry<String, ExtensionGroupMember> entry : group.members.entrySet()) {
                ExtensionGroupMember member = entry.getValue();
                if (!member.isDefined || !member.hasRef) continue;
                members.add(entry.getKey());
            }
        }
        return members;
    }

    public List<String> getExtensionGroupIds() {
        this.checkErrors();
        return new ArrayList<String>(this._groups.keySet());
    }

    int getNumMembers(String extensionGroupId) {
        ExtensionGroup group = this._groups.get(extensionGroupId);
        if (group != null) {
            return group.members.size();
        }
        return -1;
    }

    public void addExtensionRef(ElementContext context, String extensionGroupId, String fromExtensionName) {
        if (this.errorInOtherExtensionGroup(context, fromExtensionName, extensionGroupId)) {
            return;
        }
        ExtensionGroup group = this.getExtensionGroup(extensionGroupId);
        ExtensionGroupMember member = this.getExtensionGroupMember(group, extensionGroupId, fromExtensionName);
        member.hasRef = true;
        this._errorsChecked = false;
    }

    public void addExtensionMember(ElementContext context, String memberName, String extensionGroupId) {
        if (this.errorInOtherExtensionGroup(context, memberName, extensionGroupId)) {
            return;
        }
        ExtensionGroup group = this._groups.get(extensionGroupId);
        ExtensionGroupMember member = this.getExtensionGroupMember(group, extensionGroupId, memberName);
        member.isDefined = true;
    }

    public void addExtensionGroup(ElementContext context, String extensionGroupId, String definingExtensionName) {
        if (this.errorInOtherExtensionGroup(context, definingExtensionName, extensionGroupId)) {
            return;
        }
        ExtensionGroup group = this.getExtensionGroup(extensionGroupId);
        if (this.errorExtensionGroupAlreadyDefined(context, group, extensionGroupId, definingExtensionName)) {
            return;
        }
        group.definingExtensionName = definingExtensionName;
        ExtensionGroupMember member = this.getExtensionGroupMember(group, extensionGroupId, definingExtensionName);
        member.isDefined = true;
        member.hasRef = true;
        this._errorsChecked = false;
    }

    private ExtensionGroup getExtensionGroup(String extensionGroupId) {
        ExtensionGroup group = this._groups.get(extensionGroupId);
        if (group == null) {
            group = new ExtensionGroup();
            group.members = new HashMap();
            this._groups.put(extensionGroupId, group);
        }
        return group;
    }

    private ExtensionGroupMember getExtensionGroupMember(ExtensionGroup group, String extensionGroupId, String memberExtensionName) {
        this._memberToGroup.put(memberExtensionName, extensionGroupId);
        ExtensionGroupMember member = group.members.get(memberExtensionName);
        if (member == null) {
            member = new ExtensionGroupMember();
            group.members.put(memberExtensionName, member);
        }
        return member;
    }

    private boolean errorExtensionGroupAlreadyDefined(ElementContext context, ExtensionGroup group, String extensionGroupId, String definingExtensionName) {
        if (group.definingExtensionName != null) {
            if (group.definingExtensionName.equals(definingExtensionName)) {
                this.error("Extension group " + extensionGroupId + " is already defined in extension " + definingExtensionName);
            } else {
                this.error("Extension " + definingExtensionName + " group " + extensionGroupId + " is already defined in extension " + group.definingExtensionName);
            }
            return true;
        }
        return false;
    }

    private boolean errorInOtherExtensionGroup(ElementContext context, String extensionName, String extensionGroupId) {
        boolean error;
        String groupId = this._memberToGroup.get(extensionName);
        boolean bl = error = groupId != null && !groupId.equals(extensionGroupId);
        if (error) {
            this.error("Extension " + extensionName + " already belongs to group " + groupId + " and cannot belong to group " + extensionGroupId + " as well");
        }
        return error;
    }

    private void checkErrors() {
        if (!this._errorsChecked) {
            this._errorsChecked = true;
            for (Map.Entry<String, ExtensionGroup> entry : this._groups.entrySet()) {
                String groupId = entry.getKey();
                ExtensionGroup group = entry.getValue();
                for (Map.Entry<String, ExtensionGroupMember> memberEntry : group.members.entrySet()) {
                    Extension minimalExtension;
                    String extensionId = memberEntry.getKey();
                    ExtensionGroupMember member = memberEntry.getValue();
                    if (member.hasReportedError) continue;
                    member.hasReportedError = true;
                    if (!member.isDefined) {
                        this.warn("Extension " + extensionId + " has a <feature-member id=\"" + groupId + "\"/> element, however that extension is not listed as a member in the " + groupId + " <feature> definition");
                        continue;
                    }
                    if (member.hasRef || (minimalExtension = ExtensionRegistry.getExtensionRegistry().findMinimalExtension(extensionId)) == null) continue;
                    this.warn("<feature> with id='" + groupId + "' has member " + extensionId + " that has no corresponding <feature-member> element");
                }
            }
        }
    }

    private void warn(String msg) {
        ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.WARNING, msg);
    }

    private void error(String msg) {
        ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, msg);
    }

    private static class ExtensionGroup {
        String definingExtensionName;
        HashMap<String, ExtensionGroupMember> members = new HashMap();

        private ExtensionGroup() {
        }
    }

    private static class ExtensionGroupMember {
        boolean isDefined;
        boolean hasRef;
        boolean hasReportedError;

        private ExtensionGroupMember() {
        }
    }
}

