/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.extension.rules.RuleEngine;
import oracle.javatools.data.HashStructure;

public class DynamicEditorHookRegistration {
    private final HashStructure _hash;

    DynamicEditorHookRegistration(HashStructure hs) {
        this._hash = hs;
    }

    public String getId() {
        return this._hash.getString("id");
    }

    public boolean evaluateRule(Context context) {
        String ruleId = this._hash.getString("rule");
        RuleEngine engine = RuleEngine.getInstance();
        if (engine.validateRuleReference(ruleId, null)) {
            return engine.evaluateRule(ruleId, context);
        }
        return false;
    }

    public float getWeight() {
        return this._hash.getFloat("weight", Float.NaN);
    }

    public MetaClass<Editor> getEditorClass() {
        LazyClassAdapter lca = LazyClassAdapter.getInstance(this._hash);
        return lca.getMetaClass("editor-class");
    }

    public String getLabel() {
        return this._hash.getString("label");
    }

    public boolean isRestoreAtStartup() {
        return this._hash.getBoolean("restore-at-startup", true);
    }

    public boolean isDuplicable() {
        return this._hash.getBoolean("duplicable", true);
    }

    public boolean isCloneable() {
        return this._hash.getBoolean("cloneable", false);
    }

    public boolean isDefault() {
        return this._hash.getBoolean("default", false);
    }

    public boolean isMultifile() {
        return this._hash.getBoolean("multifile", false);
    }

    public String toString() {
        return String.format("%s [id=%s, label=%s, editor-class=%s, default=%s, duplicable=%s, restore-at-startup=%s]", this.getClass().getName(), this.getLabel(), this._hash.getString("editor-class"), this.isDefault(), this.isDuplicable(), this.isRestoreAtStartup());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicEditorHookRegistration)) {
            return false;
        }
        DynamicEditorHookRegistration that = (DynamicEditorHookRegistration)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return 377 + this.getId().hashCode();
    }
}

