/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.layout.ViewId;
import oracle.ide.navigator.HostedView;
import oracle.javatools.data.HashStructure;

public final class HostedDockableHook
extends HashStructureHook {
    private List<HostToHostedView> hostToHostedViews = new ArrayList<HostToHostedView>();
    private final List<HostedDockableRegistrationListener> hostedDockableRegistrationListeners = new ArrayList<HostedDockableRegistrationListener>();
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "hosted-dockable-hook");

    HostedDockableHook() {
        this.addHashStructureHookListener(new HashStructureHookListener(){

            @Override
            public void elementVisited(HashStructureHookEvent e) {
                HostedDockableHook.this.registerHostedViews(e.getNewElementHashStructure());
            }

            @Override
            public void listenerAttached(HashStructureHookEvent e) {
                HostedDockableHook.this.registerHostedViews(e.getNewElementHashStructure());
            }
        });
    }

    public static HostedDockableHook get() {
        return (HostedDockableHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    public final void addHostedDockableRegistrationListener(HostedDockableRegistrationListener listener) {
        if (!this.hostedDockableRegistrationListeners.contains(listener)) {
            this.hostedDockableRegistrationListeners.add(listener);
        }
    }

    public final void removeHostedDockableRegistrationListener(HostedDockableRegistrationListener listener) {
        this.hostedDockableRegistrationListeners.remove(listener);
    }

    private void registerHostedViews(HashStructure hs) {
        if (hs == null) {
            return;
        }
        List hostedList = hs.getAsList("hosted-dockable");
        if (hostedList != null) {
            ArrayList<HostToHostedView> newHostToHostedViews = new ArrayList<HostToHostedView>();
            for (Object hostObj : hostedList) {
                HashStructure hostedHash = (HashStructure)hostObj;
                String hostId = hostedHash.getString("host-id");
                String viewId = hostedHash.getString("view-id");
                if (hostId == null) {
                    Logger.getLogger("global").log(Level.SEVERE, "extension " + HostedDockableHook.getExtensionId(hs) + " is attempting to register a hosted docakble with no host-id");
                }
                if (viewId == null) {
                    Logger.getLogger("global").log(Level.SEVERE, "extension " + HostedDockableHook.getExtensionId(hs) + " is attempting to register a hosted docakble with no view-id");
                }
                float weight = hostedHash.containsKey("weight") ? hostedHash.getFloat("weight") : 0.0f;
                HostToHostedView hostToHostedView = new HostToHostedView();
                hostToHostedView.hostId = new ViewId(hostId);
                hostToHostedView.hostedView = new HostedView(new ViewId(viewId), weight);
                newHostToHostedViews.add(hostToHostedView);
            }
            this.hostToHostedViews.addAll(newHostToHostedViews);
            for (final HostToHostedView hostToHostedView : newHostToHostedViews) {
                for (final HostedDockableRegistrationListener l : this.hostedDockableRegistrationListeners) {
                    Runnable hostedDockableRegisteredRunnable = new Runnable(){

                        @Override
                        public void run() {
                            l.hostedDockableRegistered(hostToHostedView.hostId, hostToHostedView.hostedView);
                        }
                    };
                    ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
                    registry.invokeAfterExtensionLoading(hostedDockableRegisteredRunnable, true);
                }
            }
        }
    }

    public List<HostedView> getHostedViews(ViewId hostViewId) {
        ArrayList<HostedView> hostedViews = new ArrayList<HostedView>();
        for (HostToHostedView hostToHostedView : this.hostToHostedViews) {
            if (!hostToHostedView.hostId.equals(hostViewId)) continue;
            hostedViews.add(hostToHostedView.hostedView);
        }
        return hostedViews;
    }

    private class HostToHostedView {
        private ViewId hostId;
        private HostedView hostedView;

        private HostToHostedView() {
        }
    }

    public static interface HostedDockableRegistrationListener {
        public void hostedDockableRegistered(ViewId var1, HostedView var2);
    }
}

