/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

public final class FastStringBuffer {
    private static char[] logicalLiteral = new char[]{'\r', '\n', '\t', '\'', '\\'};
    private static char[] displayLiteral = new char[]{'r', 'n', 't', '\'', '\\'};
    public static final int NOTACHAR = 0;
    public static final int NOT_A_CHAR = 0;
    private char[] value;
    private int count;
    private int offset;
    static final String needingEscape = "\b\t\n\f\r\"\\";
    private static final int SUGGESTED_MAX_SOURCE_COLS = 64;
    private static final int ABSOLUTE_MAX_SOURCE_COLS = 100;

    public FastStringBuffer() {
        this(16);
    }

    public FastStringBuffer(int length) {
        this.value = new char[length];
        this.offset = 0;
        this.count = 0;
    }

    public FastStringBuffer(String str) {
        this(str.length() + 16);
        this.append(str);
        this.offset = 0;
        this.count = str.length();
    }

    public FastStringBuffer(char[] cArray) {
        this(cArray.length + 16);
        this.append(cArray);
        this.offset = 0;
        this.count = cArray.length;
    }

    public FastStringBuffer(char[] cArray, int offset, int len) {
        this(len + 16);
        this.append(cArray, offset, len);
        offset = 0;
        this.count = len;
    }

    public FastStringBuffer(char c, int nChars) {
        this(nChars);
        for (int i = 0; i < nChars; ++i) {
            this.value[i] = c;
        }
        this.count = nChars;
    }

    public void empty() {
        for (int i = 0; i < this.count; ++i) {
            this.value[i] = '\u0000';
        }
        this.count = 0;
        this.offset = 0;
    }

    public char[] value() {
        return this.value;
    }

    public char[] getValue() {
        return this.value;
    }

    public int length() {
        return this.count;
    }

    public int getLength() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public int offset() {
        return this.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void makeroom(int minimumCapacity) {
        int maxCapacity = this.value.length;
        if (minimumCapacity > maxCapacity) {
            int newCapacity = (maxCapacity + 1) * 2;
            if (minimumCapacity > newCapacity) {
                newCapacity = minimumCapacity;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        this.makeroom(newLength);
        if (this.count < newLength) {
            while (this.count < newLength) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        }
        this.count = newLength;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.offset = index;
        return this.value[index];
    }

    public char firstChar() {
        if (this.count <= 0) {
            return '\u0000';
        }
        this.offset = 0;
        return this.value[0];
    }

    public char lastChar() {
        if (this.count <= 0) {
            return '\u0000';
        }
        this.offset = this.count - 1;
        return this.value[this.offset];
    }

    public char currentChar() {
        if (this.offset < 0 || this.offset >= this.count) {
            return '\u0000';
        }
        return this.value[this.offset];
    }

    public char nextChar() {
        if (this.offset < -1 || this.offset >= this.count - 1) {
            return '\u0000';
        }
        return this.value[++this.offset];
    }

    public char priorChar() {
        if (this.offset < 1 || this.offset > this.count) {
            return '\u0000';
        }
        return this.value[--this.offset];
    }

    public char peekNextChar() {
        if (this.offset < -1 || this.offset >= this.count - 1) {
            return '\u0000';
        }
        return this.value[this.offset + 1];
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        if (srcBegin < srcEnd) {
            System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
        }
    }

    public char[] getChars() {
        char[] result = new char[this.count];
        System.arraycopy(this.value, 0, result, 0, this.count);
        return result;
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public void removeCharAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        int len = this.count - index - 1;
        if (index < this.count - 1 && len > 0) {
            System.arraycopy(this.value, index + 1, this.value, index, len);
        }
        this.offset = index - 1;
        --this.count;
    }

    public void removeChar() {
        this.removeCharAt(this.offset);
    }

    public void removeCharsAt(int index, int removeCount) {
        if (index < 0 || index + removeCount > this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (index < this.count - removeCount) {
            System.arraycopy(this.value, index + removeCount, this.value, index, this.count - index - removeCount);
        }
        this.offset = index - removeCount;
        this.count -= removeCount;
    }

    public void removeChars(int removeCount) {
        this.removeCharsAt(this.offset, removeCount);
    }

    public void replaceCharAt(int index, char c) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = c;
    }

    public FastStringBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public FastStringBuffer append(char c) {
        this.makeroom(this.count + 1);
        this.value[this.count++] = c;
        return this;
    }

    public FastStringBuffer append(char c, int appendCount) {
        this.makeroom(this.count + appendCount);
        for (int i = 0; i < appendCount; ++i) {
            this.value[this.count++] = c;
        }
        return this;
    }

    public FastStringBuffer append(String str) {
        if (str == null) {
            str = String.valueOf(str);
        }
        int len = str.length();
        this.makeroom(this.count + len);
        str.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    public FastStringBuffer append(FastStringBuffer fsb) {
        if (fsb == null) {
            return this;
        }
        int len = fsb.count;
        this.makeroom(this.count + len);
        fsb.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    public FastStringBuffer append(char[] str) {
        int len = str.length;
        this.makeroom(this.count + len);
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count += len;
        return this;
    }

    public FastStringBuffer append(char[] str, int offset, int len) {
        this.makeroom(this.count + len);
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count += len;
        return this;
    }

    public FastStringBuffer insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public FastStringBuffer insert(int offset, String str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length();
        this.makeroom(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count += len;
        return this;
    }

    public FastStringBuffer insert(int offset, char[] str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length;
        this.makeroom(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count += len;
        return this;
    }

    public FastStringBuffer insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public FastStringBuffer insert(int offset, char c) {
        this.makeroom(this.count + 1);
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        ++this.count;
        return this;
    }

    public int IndexOfSubString(FastStringBuffer subStr, int fromIndex) {
        return this.indexOf(subStr, fromIndex);
    }

    public int indexOfSubstring(FastStringBuffer buffer, int fromIndex) {
        return this.IndexOfSubString(buffer, fromIndex);
    }

    public int indexOf(FastStringBuffer subStr, int fromIndex) {
        int i;
        char[] v1 = this.value;
        char[] v2 = subStr.value();
        int max = this.count - subStr.length();
        int n = i = fromIndex < 0 ? 0 : fromIndex;
        while (i <= max) {
            block2: {
                int n2 = subStr.length();
                int j = i;
                int k = 0;
                while (n2-- != 0) {
                    if (v1[j++] == v2[k++]) continue;
                    break block2;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(FastStringBuffer subStr, int fromIndex) {
        char[] v1 = this.value;
        char[] v2 = subStr.value();
        int max = this.count - subStr.length();
        block0: for (int i = fromIndex; i >= 0; --i) {
            int n = subStr.length();
            int j = i;
            int k = 0;
            while (n-- != 0) {
                if (v1[j++] == v2[k++]) continue;
                continue block0;
            }
            return i;
        }
        return -1;
    }

    public FastStringBuffer substring(int startPos, int endPos) {
        if (startPos < 0) {
            startPos = 0;
        }
        if (endPos >= this.count) {
            endPos = this.count - 1;
        }
        FastStringBuffer fsb = startPos >= endPos ? new FastStringBuffer() : new FastStringBuffer(this.value, startPos, endPos - startPos);
        return fsb;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public char parseBackSlash() {
        int maxChars;
        int radix;
        char c = this.nextChar();
        char cVal = FastStringBuffer.displayToLiteral(c);
        if (cVal != '\u0000') {
            return cVal;
        }
        switch (c) {
            case 'U': 
            case 'u': {
                radix = 16;
                maxChars = 4;
                break;
            }
            case '0': {
                radix = 8;
                maxChars = 3;
                c = this.peekNextChar();
                if (c == 'x' || c == 'X') {
                    radix = 16;
                    maxChars = 2;
                    ++this.offset;
                    break;
                }
                this.priorChar();
                break;
            }
            default: {
                return c;
            }
        }
        FastStringBuffer s = new FastStringBuffer(maxChars);
        for (int i = 0; i < maxChars; ++i) {
            c = Character.toUpperCase(this.nextChar());
            if (!Character.isDigit(c) && (radix == 8 && c > '7' || radix == 16 && (c < 'A' || c > 'F'))) {
                this.priorChar();
                break;
            }
            s.append(c);
        }
        return (char)Integer.parseInt(s.toString(), radix);
    }

    public FastStringBuffer parseLiteral(char delimiter, boolean allowDouble) {
        FastStringBuffer rsb = new FastStringBuffer();
        char c = this.nextChar();
        while (c != '\u0000') {
            if (c == delimiter) {
                if (!allowDouble || this.peekNextChar() != c) break;
                rsb.append(c);
                this.nextChar();
            } else {
                if (c == '\\') {
                    c = this.parseBackSlash();
                }
                rsb.append(c);
            }
            c = this.nextChar();
        }
        return rsb;
    }

    public FastStringBuffer parseLiteral() {
        return this.parseLiteral(this.currentChar(), false);
    }

    public static FastStringBuffer expandDelimiters(String sourceString, String delimiters) {
        int len = sourceString == null ? 0 : sourceString.length();
        FastStringBuffer result = new FastStringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = sourceString.charAt(i);
            if (delimiters.indexOf(c) >= 0) {
                result.append(FastStringBuffer.charToUnicodeEscape(c));
                continue;
            }
            result.append(c);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public FastStringBuffer normalizeDelimiters(String delimiters) {
        result = new FastStringBuffer(this.count);
        c = this.firstChar();
        while (c != '\u0000') {
            if (c != '\\') ** GOTO lbl19
            oldoffset = this.offset;
            cVal = this.parseBackSlash();
            if (delimiters.indexOf(cVal) >= 0) {
                cLog = FastStringBuffer.literalToDisplay(cVal);
                if (cLog != '\u0000') {
                    result.append('\\');
                    result.append(cLog);
                } else {
                    result.append(cVal);
                }
            } else {
                this.offset = oldoffset;
lbl19:
                // 2 sources

                result.append(c);
            }
            c = this.nextChar();
        }
        return result;
    }

    public static String charToUnicodeEscape(char ch) {
        char[] hexChars = new char[]{'\\', 'u', Hex.chars[ch >> 12 & 0xF], Hex.chars[ch >> 8 & 0xF], Hex.chars[ch >> 4 & 0xF], Hex.chars[ch & 0xF]};
        return new String(hexChars, 0, 6);
    }

    private static char displayToLiteral(char c) {
        for (int i = 0; i < displayLiteral.length; ++i) {
            if (c != displayLiteral[i]) continue;
            return logicalLiteral[i];
        }
        return '\u0000';
    }

    private static char literalToDisplay(char c) {
        for (int i = 0; i < logicalLiteral.length; ++i) {
            if (c != logicalLiteral[i]) continue;
            return displayLiteral[i];
        }
        return '\u0000';
    }

    public static char charFromString(String s) {
        char c = '\u0000';
        if (s != null && s.length() >= 0) {
            if (s.length() == 1) {
                c = s.charAt(0);
            } else {
                FastStringBuffer fsb = new FastStringBuffer(s);
                c = fsb.firstChar();
                if (c == '\\') {
                    c = fsb.parseBackSlash();
                }
            }
        }
        return c;
    }

    public static String stringFromChar(char c) {
        char cLog = FastStringBuffer.literalToDisplay(c);
        Object s = cLog != '\u0000' ? "\\" + cLog : (c < ' ' ? FastStringBuffer.charToUnicodeEscape(c) : new String(new char[]{c}));
        return s;
    }

    public static FastStringBuffer sourceToText(String source) {
        int len;
        FastStringBuffer text = new FastStringBuffer();
        FastStringBuffer input = new FastStringBuffer(source);
        if (input.charAt(0) == '\"') {
            input.removeCharAt(0);
        }
        if ((len = input.length()) > 0 && input.charAt(len - 1) == '\"') {
            input.removeCharAt(len - 1);
        }
        char ch = input.firstChar();
        while (ch != '\u0000') {
            if (ch == '\\') {
                ch = input.parseBackSlash();
            }
            text.append(ch);
            ch = input.nextChar();
        }
        return text;
    }

    public static FastStringBuffer textToSource(String text, boolean hasEscapes) {
        return FastStringBuffer.textToSource(text, hasEscapes, "    ");
    }

    /*
     * Unable to fully structure code
     */
    public static FastStringBuffer textToSource(String text, boolean hasEscapes, String indentString) {
        source = new FastStringBuffer(text.length() * 2 + 2);
        source.append("\"");
        colCount = 0;
        block12: for (i = 0; i < text.length(); ++i) {
            ch = text.charAt(i);
            if (ch != '\\' || !hasEscapes || i + 2 >= text.length()) ** GOTO lbl-1000
            digit = text.charAt(i + 2);
            switch (text.charAt(i + 1)) {
                case '0': {
                    if ((digit == 'x' || digit == 'X') && i + 3 < text.length()) {
                        digit = text.charAt(i + 3);
                    }
                }
                case 'U': 
                case 'u': {
                    if (digit >= '0' && digit <= '9') {
                        source.append(ch);
                        continue block12;
                    }
                }
                default: lbl-1000:
                // 2 sources

                {
                    if ("\b\t\n\f\r\"\\".indexOf(ch) < 0) ** GOTO lbl56
                    source.append("\\");
                    switch (ch) {
                        case '\b': {
                            source.append('b');
                            break;
                        }
                        case '\t': {
                            source.append('t');
                            break;
                        }
                        case '\n': {
                            source.append('n');
                            break;
                        }
                        case '\f': {
                            source.append('f');
                            break;
                        }
                        case '\r': {
                            source.append('r');
                            break;
                        }
                        case '\\': {
                            source.append('\\');
                            if (hasEscapes && i + 1 < text.length() && text.charAt(i + 1) == '\\') {
                                source.append(text.charAt(++i));
                                break;
                            }
                            ** GOTO lbl58
                        }
                        default: {
                            source.append(FastStringBuffer.stringFromChar(ch));
                            break;
                        }
                    }
                    ** GOTO lbl58
lbl56:
                    // 1 sources

                    source.append(FastStringBuffer.stringFromChar(ch));
lbl58:
                    // 3 sources

                    if (i >= text.length() - 1 || ++colCount <= 64 || (!(breakHere = Character.isWhitespace(ch)) || colCount <= 64) && colCount <= 100) continue block12;
                    source.append("\" +\n");
                    source.append(indentString);
                    source.append("\"");
                    colCount = 0;
                }
            }
        }
        source.append("\"");
        return source;
    }

    static class Hex {
        public static final char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        public static final byte[] bytes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

        Hex() {
        }
    }
}

