/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;

public class WorkingSetsMigratorHelper
extends NodeMigratorHelper {
    @Override
    public void migrate(MigrationInfo[] infos, TraversableContext context) {
        for (MigrationInfo info : infos) {
            Node node = info.getNode();
            if (!(node instanceof Workspace)) continue;
            ArrayList<Project> projectsWithWorkingSets = new ArrayList<Project>();
            Workspace workspace = (Workspace)node;
            WorkingSets appWorkingSets = WorkingSets.getInstance(workspace);
            Iterator<Element> children = workspace.getChildren();
            while (children.hasNext()) {
                Element nextChild = children.next();
                if (!(nextChild instanceof Project)) continue;
                Project project = (Project)nextChild;
                projectsWithWorkingSets.add(project);
                this.migrateWorkingSets(appWorkingSets, project);
            }
            for (Project project : projectsWithWorkingSets) {
                this.maybeExcludeProjectFromWorkingSets(appWorkingSets, project);
            }
        }
    }

    private void migrateWorkingSets(WorkingSets appWorkingSets, Project project) {
        HashStructure properties = project.getUserPropertiesOnly();
        if (properties.containsKey("working-sets")) {
            HashStructure projectWorkingSets = properties.getHashStructure("working-sets");
            for (String name : projectWorkingSets.keySet()) {
                if (WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(name) || ".current".equals(name)) continue;
                WorkingSet workingSet = appWorkingSets.getWorkingSet(name);
                workingSet.includeProject(project);
                PatternFilters patternFilters = workingSet.getOrCreatePatternFilters(project);
                HashStructure workingSetHash = projectWorkingSets.getHashStructure(name);
                ListStructure list = workingSetHash.getListStructure("pattern-filters");
                if (list == null) {
                    patternFilters.setFilters(null);
                    continue;
                }
                PatternFilter[] filters = new PatternFilter[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    filters[i] = PatternFilter.fromStr(list.get(i).toString());
                }
                patternFilters.setFilters(filters);
            }
        }
    }

    private void maybeExcludeProjectFromWorkingSets(WorkingSets appWorkingSets, Project project) {
        HashStructure properties = project.getUserPropertiesOnly();
        if (properties.containsKey("working-sets")) {
            HashStructure projectWorkingSets = properties.getHashStructure("working-sets");
            List<String> names = appWorkingSets.getWorkingSetNames();
            for (String name : names) {
                if (WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(name) || projectWorkingSets.containsKey(name)) continue;
                appWorkingSets.getWorkingSet(name).excludeProject(project);
            }
        }
    }

    @Override
    public String getNodeMigratorHelperKey() {
        return ProjectMigrator.MIGRATOR_NAME;
    }
}

