/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.javatools.data.HashStructure;

class RootElementRecognizerHookHelper {
    static Map<String, MetaClass<Node>> findRootElementMappings(HashStructure hs) {
        return Collections.unmodifiableMap(RootElementRecognizerHookHelper.buildRootElementMappings(hs));
    }

    private static Map<String, MetaClass<Node>> buildRootElementMappings(HashStructure hs) {
        HashMap<String, MetaClass<Node>> mappings = new HashMap<String, MetaClass<Node>>();
        List xmlRecognizers = hs.getAsList("xml-recognizer");
        if (xmlRecognizers == null) {
            return mappings;
        }
        for (Object o : xmlRecognizers) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            RootElementRecognizerHookHelper.addRootElementMapping(childHs, mappings);
        }
        return mappings;
    }

    public static void registerXMLExtension(HashStructure hs) {
        String extension = hs.getString("file-extension/#text");
        if (extension != null && !extension.isEmpty()) {
            Recognizer.mapExtensionToXML(extension);
        }
    }

    private static void addRootElementMapping(HashStructure hs, Map<String, MetaClass<Node>> mappings) {
        List rootElements = hs.getAsList("root-elem");
        if (rootElements == null) {
            return;
        }
        for (Object o : rootElements) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String rootElement = childHs.getString("elem-name/#text");
            LazyClassAdapter adapter = LazyClassAdapter.getInstance(childHs);
            MetaClass metaClass = adapter.getMetaClass("node-type/#text");
            RootElementRecognizerHookHelper.registerXMLExtension(childHs);
            mappings.put(rootElement, metaClass);
        }
    }

    private RootElementRecognizerHookHelper() {
    }
}

