/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.DataList;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Reference;
import oracle.ide.model.SubDirtyable;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.util.Copyable;

public class ObservableFolder
extends DefaultFolder
implements Copyable,
Dirtyable,
Subject {
    private transient boolean _dirty = false;
    private final Subject _subject = new IdeSubject();

    public Object copyTo(Object object) {
        ObservableFolder copy = object != null ? (ObservableFolder)object : new ObservableFolder();
        this.copyToImpl(copy);
        return copy;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void markDirty(boolean dirty) {
        this._dirty = dirty;
    }

    @Override
    public synchronized void attach(Observer observer) {
        this._subject.attach(observer);
    }

    @Override
    public synchronized void detach(Observer observer) {
        this._subject.detach(observer);
    }

    @Override
    public synchronized void notifyObservers(Object observed, UpdateMessage change) {
        this._subject.notifyObservers(observed, change);
    }

    @Override
    public boolean add(Element element) {
        boolean addOk = super.add(element);
        if (addOk) {
            ObservableFolder.setOwner(element, this);
            this.markDirty(true);
        }
        return addOk;
    }

    @Override
    public boolean remove(Element element) {
        boolean removeOk = super.remove(element);
        if (removeOk) {
            ObservableFolder.setOwner(element, null);
            this.markDirty(true);
        }
        return removeOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            for (Element element : this._children) {
                ObservableFolder.setOwner(element, null);
            }
        }
        super.removeAll();
        this.markDirty(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getListOfChildren() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            return new DataList(this._children);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListOfChildren(List list) {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.clear();
        }
        if (list != null) {
            for (Object next : list) {
                if (next instanceof Reference) {
                    Reference ref = (Reference)next;
                    this.add(ref.getData());
                    continue;
                }
                if (!(next instanceof Element)) continue;
                this.add((Element)next);
            }
        }
    }

    private static void setOwner(Element element, Dirtyable owner) {
        if (element instanceof SubDirtyable) {
            ((SubDirtyable)element).setOwner(owner);
        }
    }
}

