/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.xml.XMLRecognizer;
import oracle.javatools.data.HashStructure;

class NoNamespaceRecognizerHookHelper {
    static Map<String, List<XMLRecognizer.NoNamespaceRule>> findNoNamespaceMappings(HashStructure hs) {
        return Collections.unmodifiableMap(NoNamespaceRecognizerHookHelper.buildNoNamespaceMappings(hs));
    }

    private static Map<String, List<XMLRecognizer.NoNamespaceRule>> buildNoNamespaceMappings(HashStructure hs) {
        HashMap<String, List<XMLRecognizer.NoNamespaceRule>> mappings = new HashMap<String, List<XMLRecognizer.NoNamespaceRule>>();
        List xmlRecognizers = hs.getAsList("xml-recognizer");
        if (xmlRecognizers == null) {
            return mappings;
        }
        for (Object o : xmlRecognizers) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            NoNamespaceRecognizerHookHelper.addNoNamespaceMapping(childHs, mappings);
        }
        return mappings;
    }

    private static void addNoNamespaceMapping(HashStructure hs, Map<String, List<XMLRecognizer.NoNamespaceRule>> mappings) {
        List rootElements = hs.getAsList("no-namespace");
        if (rootElements == null) {
            return;
        }
        for (Object o : rootElements) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String rootElement = childHs.getString("elem-name/#text");
            String excludes = childHs.getString("exclude-filenames/#text");
            String[] excludeFiles = NoNamespaceRecognizerHookHelper.split(excludes);
            String includes = childHs.getString("include-filenames/#text");
            String[] includeFiles = NoNamespaceRecognizerHookHelper.split(includes);
            LazyClassAdapter adapter = LazyClassAdapter.getInstance(childHs);
            MetaClass metaClass = adapter.getMetaClass("node-type/#text");
            XMLRecognizer.NoNamespaceRule rule = new XMLRecognizer.NoNamespaceRule(rootElement, excludeFiles, includeFiles, metaClass);
            List<XMLRecognizer.NoNamespaceRule> rules = mappings.get(rootElement);
            if (rules == null) {
                rules = new ArrayList<XMLRecognizer.NoNamespaceRule>();
                mappings.put(rootElement, rules);
            }
            rules.add(rule);
        }
    }

    private static String[] split(String s) {
        if (s == null || s.isEmpty()) {
            return new String[0];
        }
        return s.split(",");
    }

    private NoNamespaceRecognizerHookHelper() {
    }
}

