/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.model.Element;
import oracle.ide.model.ElementRecognizer;
import oracle.ide.model.Project;

public final class ElementFactory {
    private static final ArrayList _recognizers = new ArrayList();

    public static Element findOrCreate(URL url, Project project) throws IllegalAccessException, InstantiationException {
        ElementRecognizer recognizer;
        if (url != null && (recognizer = ElementFactory.findElementRecognizer(url)) != null) {
            return recognizer.create(url, project);
        }
        return null;
    }

    public static void addRecognizer(ElementRecognizer recognizer) {
        if (recognizer != null && !_recognizers.contains(recognizer)) {
            _recognizers.add(recognizer);
        }
    }

    public static void removeRecognizer(ElementRecognizer recognizer) {
        if (recognizer != null) {
            _recognizers.remove(recognizer);
        }
    }

    private static ElementRecognizer findElementRecognizer(URL url) {
        if (url != null) {
            for (ElementRecognizer recognizer : _recognizers) {
                Class cls = recognizer.recognize(url);
                if (cls == null) continue;
                return recognizer;
            }
        }
        return null;
    }
}

