/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.explorer.IconOverlayRegistry;
import oracle.ide.explorer.IconOverlayTracker;

public final class IconOverlayHook
extends ExtensionHook {
    private static final String NS = "http://xmlns.oracle.com/ide/extension";
    private static final ElementName INFO_TYPE_ID = new ElementName("http://xmlns.oracle.com/ide/extension", "info-type-id");
    private static final ElementName BATCH_SIZE = new ElementName("http://xmlns.oracle.com/ide/extension", "batch-size");
    private static final ElementName TRACKER_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "tracker-class");
    private final ElementVisitor _infoTypeIdHandler = new InfoTypeIdHandler();
    private final ElementVisitor _batchSizeHandler = new BatchSizeHandler();
    private final ElementVisitor _trackerClassHandler = new TrackerClassHandler();
    private static final String KEY_SCOPE_ICON_OVERLAY_REGISTRATION = "oide_iconoverlay_registration";

    public void start(ElementStartContext context) {
        context.registerChildVisitor(INFO_TYPE_ID, this._infoTypeIdHandler);
        context.registerChildVisitor(BATCH_SIZE, this._batchSizeHandler);
        context.registerChildVisitor(TRACKER_CLASS, this._trackerClassHandler);
        context.getScopeData().put(KEY_SCOPE_ICON_OVERLAY_REGISTRATION, new IconOverlayRegistration());
    }

    public void end(ElementEndContext context) {
        final IconOverlayRegistration registration = (IconOverlayRegistration)context.getScopeData().get(KEY_SCOPE_ICON_OVERLAY_REGISTRATION);
        if (registration.getInfoTypeId() == null) {
            throw new NullPointerException();
        }
        if (registration.getTrackerClass() == null) {
            throw new NullPointerException();
        }
        final String extensionId = context.getExtension().getID();
        ExtensionRegistry.getExtensionRegistry().invokeAfterExtensionLoading(new Runnable(){

            @Override
            public final void run() {
                IconOverlayRegistry.registerOverlayCoordinator(extensionId, registration.getInfoTypeId(), registration.getBatchSize(), registration.getTrackerClass());
            }
        }, false);
    }

    private final class InfoTypeIdHandler
    extends ElementVisitor {
        private InfoTypeIdHandler() {
        }

        public void end(ElementEndContext context) {
            ((IconOverlayRegistration)context.getScopeData().get(IconOverlayHook.KEY_SCOPE_ICON_OVERLAY_REGISTRATION)).setInfoTypeId(context.getText());
        }
    }

    private final class BatchSizeHandler
    extends ElementVisitor {
        private BatchSizeHandler() {
        }

        public void end(ElementEndContext context) {
            ((IconOverlayRegistration)context.getScopeData().get(IconOverlayHook.KEY_SCOPE_ICON_OVERLAY_REGISTRATION)).setBatchSize(Integer.parseInt(context.getText()));
        }
    }

    private final class TrackerClassHandler
    extends MetaClassVisitor {
        private TrackerClassHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            ((IconOverlayRegistration)context.getScopeData().get(IconOverlayHook.KEY_SCOPE_ICON_OVERLAY_REGISTRATION)).setTrackerClass((MetaClass<? extends IconOverlayTracker>)mc);
        }
    }

    private final class IconOverlayRegistration {
        private String _infoTypeId;
        private int _batchSize;
        private MetaClass<? extends IconOverlayTracker> _trackerClass;

        private IconOverlayRegistration() {
        }

        final void setInfoTypeId(String _infoTypeId) {
            this._infoTypeId = _infoTypeId;
        }

        final String getInfoTypeId() {
            return this._infoTypeId;
        }

        final void setBatchSize(int _batchSize) {
            this._batchSize = _batchSize;
        }

        final int getBatchSize() {
            return this._batchSize;
        }

        final void setTrackerClass(MetaClass<? extends IconOverlayTracker> _trackerClass) {
            this._trackerClass = _trackerClass;
        }

        final MetaClass<? extends IconOverlayTracker> getTrackerClass() {
            return this._trackerClass;
        }
    }
}

