/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.editor;

import java.awt.Window;
import java.net.URL;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.ExceptionDialog;

public final class EditorUtil {
    private EditorUtil() {
    }

    public static Editor openExplicitEditorInFrame(Class editorClass, Context context) {
        EditorManager editorManager = EditorManager.getEditorManager();
        Editor editor = editorManager.openEditorInFrame(editorClass, context);
        EditorUtil.setExplicit(editor);
        return editor;
    }

    public static Editor openExplicitDefaultEditorInFrame(Node node) {
        return EditorUtil.openExplicitDefaultEditorInFrame(node, null);
    }

    public static Editor openExplicitDefaultEditorInFrame(Node node, Context context) {
        Editor editor = null;
        editor = context == null ? EditorUtil.openDefaultEditorInFrame(node) : EditorUtil.openDefaultEditorInFrame(node, context);
        EditorUtil.setExplicit(editor);
        return editor;
    }

    public static void openExplicitDefaultEditorInFrame(URL url) {
        Editor editor = EditorUtil.openDefaultEditorInFrame(url);
        EditorUtil.setExplicit(editor);
    }

    private static void setExplicit(Editor editor) {
        if (editor != null) {
            EditorManager.getEditorManager().setExplicit(editor, true);
        }
    }

    public static Editor openDefaultEditorInFrameExternal(URL url) {
        Node node;
        try {
            node = NodeFactory.findOrCreate(url);
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)e);
            Assert.println((String)("Failed opening " + url + ": " + e.toString()));
            return null;
        }
        Context context = new Context(node);
        EditorManager editorManager = EditorManager.getEditorManager();
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        return editorManager.openEditor(openEditorOptions);
    }

    public static Editor openDefaultEditorInFrame(URL url) {
        try {
            Node node = NodeFactory.findOrCreate(url);
            return EditorUtil.openDefaultEditorInFrame(node);
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)e);
            Assert.println((String)("oracle.ide.EditorManager.openDefaultEditorInFrame() - " + e.toString()));
            return null;
        }
    }

    public static Editor openDefaultEditorInFrame(Element element) {
        Context context = Context.newIdeContext(element);
        EditorManager editorManager = EditorManager.getEditorManager();
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        return editorManager.openEditor(openEditorOptions);
    }

    public static Editor openDefaultEditorInFrame(Node node) {
        Context context = Context.newIdeContext(node);
        EditorManager editorManager = EditorManager.getEditorManager();
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        return editorManager.openEditor(openEditorOptions);
    }

    public static Editor openDefaultEditorInFrame(Node node, Context context) {
        Context newContext = EditorUtil.findNodeInContext(node, context);
        if (newContext == null) {
            newContext = context;
        }
        EditorManager editorManager = EditorManager.getEditorManager();
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(newContext);
        return editorManager.openEditor(openEditorOptions);
    }

    public static Context findNodeInContext(Element node, Context context) {
        Context newContext = new Context(node);
        Project project = context.getProject();
        if (project != null) {
            if (project.containsChild(node)) {
                newContext.setProject(project);
                newContext.setWorkspace(context.getWorkspace());
                return newContext;
            }
            List<Dependable> dependencies = DependencyConfiguration.getInstance(project).getDependencyList();
            if (dependencies != null) {
                int len = dependencies.size();
                for (int i = 0; i < len; ++i) {
                    Dependable dependable = dependencies.get(i);
                    Element source = dependable.getSource();
                    if (!source.mayHaveChildren() || !(source instanceof Project) || !(project = (Project)source).containsChild(node)) continue;
                    newContext.setProject(project);
                    newContext.setWorkspace((Workspace)dependable.getSourceOwner());
                    return newContext;
                }
            }
        }
        return null;
    }
}

