/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.elementtree;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controls.elementtree.ElementRegistry;
import oracle.ide.controls.elementtree.ElementTree;
import oracle.ide.controls.elementtree.ElementTreeNode;
import oracle.ide.controls.elementtree.ElementTreeRootNode;
import oracle.ide.controls.elementtree.PagingElementTree;
import oracle.ide.controls.elementtree.PagingFilter;
import oracle.ide.controls.elementtree.ShowMoreElement;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.model.Element;
import oracle.ide.util.dnd.DragDropManager;
import oracle.ide.util.dnd.DragHelper;
import oracle.ide.view.View;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.dnd.DndUtils;

public final class ElementTreeViewAdapter {
    private View _view;
    private Element _rootElement;
    private ElementTree _tree;
    private Listener _listener = new Listener();
    private JScrollPane _component;
    private DragGestureRecognizer _dgr = null;
    private TreePath onMore = null;

    public ElementTreeViewAdapter(View view, Element rootElement) {
        this._view = view;
        this._rootElement = rootElement;
    }

    public ElementTree getElementTree() {
        if (this._tree == null) {
            ElementRegistry filterRegistry = new ElementRegistry(new PagingFilter());
            ElementTreeRootNode elementTreeNode = new ElementTreeRootNode(filterRegistry, this._rootElement);
            this._tree = new PagingElementTree(elementTreeNode);
            this._tree.setSelectionModel(new VetoableSelectionModel());
            this._tree.addTreeSelectionListener(this._listener);
            this._tree.addMouseListener(this._listener);
            this._tree.addKeyListener(new ShowMoreEnterListener());
            DragSource dragSource = DragSource.getDefaultDragSource();
            this._dgr = dragSource.createDefaultDragGestureRecognizer(this._tree, 3, this._listener);
        }
        return this._tree;
    }

    public JComponent getComponent() {
        if (this._component == null) {
            ElementTree elementTree = this.getElementTree();
            this._component = new JScrollPane(elementTree);
            this._component.setBorder(BorderFactory.createEmptyBorder());
        }
        return this._component;
    }

    private void whenShowMenu(MouseEvent e) {
        int rowForLocation = this._tree.getRowForLocation(e.getX(), e.getY());
        if (rowForLocation >= 0) {
            boolean isAlreadySelected = false;
            int[] selectionRows = this._tree.getSelectionRows();
            if (selectionRows != null) {
                for (int i = 0; !isAlreadySelected && i < selectionRows.length; ++i) {
                    int selectionRow = selectionRows[i];
                    if (rowForLocation != selectionRow) continue;
                    isAlreadySelected = true;
                }
            }
            if (!isAlreadySelected) {
                this._tree.setSelectionRow(rowForLocation);
            }
        }
        ContextMenu contextMenu = this._view.getContextMenu();
        Context context = this._view.getContext(e);
        contextMenu.show(context);
    }

    public Element[] getSelectionFromUI() {
        TreePath[] selectionPaths;
        Element[] ret = View.EMPTY_SELECTION;
        if (this._tree != null && (selectionPaths = this._tree.getSelectionPaths()) != null) {
            ret = new Element[selectionPaths.length];
            for (int i = 0; i < selectionPaths.length; ++i) {
                Element element;
                TreePath selectionPath = selectionPaths[i];
                ElementTreeNode elementTreeNode = (ElementTreeNode)selectionPath.getLastPathComponent();
                ret[i] = element = elementTreeNode.getElement();
            }
        }
        return ret;
    }

    private void updateCursor(DragSourceDragEvent dragSourceDragEvent) {
        int action = dragSourceDragEvent.getDropAction();
        Cursor cursor = switch (action) {
            default -> DragSource.DefaultCopyDrop;
            case 2 -> DragSource.DefaultMoveDrop;
            case 0x40000000 -> DragSource.DefaultLinkDrop;
        };
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        dragSourceContext.setCursor(cursor);
    }

    public void setDragAction(int action) {
        if (this._dgr != null) {
            this._dgr.setSourceActions(action);
        }
    }

    protected static Future nextPage(final ElementTree tree, final TreePath path, final boolean selectFirstNewChild) {
        assert (path != null) : "Path cannot be null";
        Element show = ((ElementTreeNode)path.getLastPathComponent()).getElement();
        if (show instanceof ShowMoreElement && !((ShowMoreElement)show).loading()) {
            final DefaultTreeModel defaultTreeModel = (DefaultTreeModel)tree.getModel();
            final ElementTreeNode parentTreeNode = (ElementTreeNode)path.getParentPath().getLastPathComponent();
            final List<ElementTreeNode> pagingNodeChildren = parentTreeNode.getChildren();
            final int moreIndex = pagingNodeChildren.size() - 1;
            final ShowMoreElement more = (ShowMoreElement)((ElementTreeNode)path.getLastPathComponent()).getElement();
            more.loadInProgress();
            defaultTreeModel.nodeChanged(pagingNodeChildren.get(moreIndex));
            Future<?> future = Executors.newSingleThreadExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    final List<Element> newChildren = new PagingFilter(more.getState()).getChildren(parentTreeNode.getElement());
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                defaultTreeModel.nodesWereRemoved(parentTreeNode, new int[]{moreIndex}, new Object[]{pagingNodeChildren.get(moreIndex)});
                                ((ElementTreeNode)pagingNodeChildren.remove(moreIndex)).detachObserver();
                                int[] indexes = new int[newChildren.size()];
                                int index = pagingNodeChildren.size();
                                int i = 0;
                                for (Element element : newChildren) {
                                    ElementTreeNode treeNode = new ElementTreeNode(element);
                                    treeNode.attach(parentTreeNode);
                                    pagingNodeChildren.add(treeNode);
                                    indexes[i++] = index++;
                                }
                                defaultTreeModel.nodesWereInserted(parentTreeNode, indexes);
                                if (selectFirstNewChild) {
                                    tree.setSelectionPath(path.getParentPath().pathByAddingChild(pagingNodeChildren.get(moreIndex)));
                                }
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
            });
            return future;
        }
        return null;
    }

    private class Listener
    implements TreeSelectionListener,
    MouseListener,
    DragGestureListener,
    DragSourceListener {
        private Listener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ElementTreeViewAdapter.this._view.updateSelection();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ElementTree tree;
            int rowLocation;
            Context context;
            ContextMenu contextMenu;
            if (e.isPopupTrigger()) {
                ElementTreeViewAdapter.this.whenShowMenu(e);
            } else if (e.getClickCount() > 1 && (contextMenu = ElementTreeViewAdapter.this._view.getContextMenu()) != null && contextMenu.fireDefaultAction(context = ElementTreeViewAdapter.this._view.getContext(e))) {
                e.consume();
            }
            if (e.getClickCount() == 1 && (rowLocation = (tree = ElementTreeViewAdapter.this.getElementTree()).getRowForLocation(e.getX(), e.getY())) > -1) {
                TreePath path = tree.getPathForRow(rowLocation);
                ElementTreeViewAdapter.nextPage(tree, path, false);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ElementTreeViewAdapter.this.whenShowMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ElementTreeViewAdapter.this.whenShowMenu(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Context context = ElementTreeViewAdapter.this._view.getContext();
            TransferableContext transferableContext = new TransferableContext(context);
            DragSource dragSource = DragSource.getDefaultDragSource();
            Transferable trans = this.getTransferablesForSelection(transferableContext);
            AugmentableTransferable augTrans = TransferUtils.createTransferable((Transferable)trans);
            DndUtils.addTriggerEvent((AugmentableTransferable)augTrans, (InputEvent)dge.getTriggerEvent());
            dragSource.startDrag(dge, DragSource.DefaultMoveNoDrop, (Transferable)augTrans, this);
        }

        private Transferable getTransferablesForSelection(Transferable existingTransferable) {
            Context context = ElementTreeViewAdapter.this._view.getContext();
            Element[] selection = context.getSelection();
            if (selection.length == 1) {
                DragDropManager dndMgr = DragDropManager.getInstance();
                ArrayList<Transferable> transferables = new ArrayList<Transferable>();
                Element elem = selection[0];
                Iterator helperIterator = dndMgr.getDragHelpers(elem.getClass());
                while (helperIterator.hasNext()) {
                    DragHelper helper = (DragHelper)helperIterator.next();
                    Transferable t = helper.getTransferable(elem);
                    if (t == null) continue;
                    transferables.add(t);
                }
                transferables.add(existingTransferable);
                return this.augmentTransferable(existingTransferable, transferables);
            }
            return existingTransferable;
        }

        private Transferable augmentTransferable(Transferable trans, ArrayList transferables) {
            AugmentableTransferable augTrans = TransferUtils.createTransferable((Transferable)trans);
            for (Transferable t : transferables) {
                DataFlavor[] flavors = t.getTransferDataFlavors();
                if (flavors.length <= 0) continue;
                for (int i = 0; i < flavors.length; ++i) {
                    if (augTrans.isDataFlavorSupported(flavors[i])) continue;
                    try {
                        Object data = t.getTransferData(flavors[i]);
                        augTrans.augment(flavors[i], data, 1.0f, null);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return augTrans;
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
            ElementTreeViewAdapter.this.updateCursor(dsde);
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
            ElementTreeViewAdapter.this.updateCursor(dsde);
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
            ElementTreeViewAdapter.this.updateCursor(dsde);
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
            DragSourceContext dragSourceContext = dse.getDragSourceContext();
            dragSourceContext.setCursor(DragSource.DefaultMoveNoDrop);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }
    }

    private class VetoableSelectionModel
    extends DefaultTreeSelectionModel {
        private VetoableSelectionModel() {
        }

        @Override
        public void setSelectionPath(TreePath path) {
            if (path != null && ((ElementTreeNode)path.getLastPathComponent()).getElement() instanceof ShowMoreElement) {
                return;
            }
            super.setSelectionPath(path);
        }

        @Override
        public void resetRowSelection() {
            TreePath path = this.getSelectionPath();
            ElementTreeViewAdapter.this.onMore = path != null && ((ElementTreeNode)path.getLastPathComponent()).getElement() instanceof ShowMoreElement ? path : null;
            super.resetRowSelection();
        }
    }

    private class ShowMoreEnterListener
    extends KeyAdapter {
        private ShowMoreEnterListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (ElementTreeViewAdapter.this.onMore != null && e.getKeyChar() == '\n') {
                ElementTreeViewAdapter.nextPage(ElementTreeViewAdapter.this.getElementTree(), ElementTreeViewAdapter.this.onMore, true);
            }
        }
    }
}

