/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import oracle.ide.controls.FocusHierarchyEvent;
import oracle.ide.controls.FocusHierarchyListener;

public final class FocusHierarchyDispatcher
implements AWTEventListener {
    private static final boolean DEBUG = false;
    private ArrayList _listeners = new ArrayList(5);
    private static FocusHierarchyDispatcher INSTANCE;

    private FocusHierarchyDispatcher() {
    }

    public synchronized void install() {
        this.uninstall();
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.addAWTEventListener(this, 4L);
    }

    public void uninstall() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.removeAWTEventListener(this);
    }

    public static synchronized FocusHierarchyDispatcher getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FocusHierarchyDispatcher();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFocusHierarchyListener(FocusHierarchyListener l) {
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            WeakReference<FocusHierarchyListener> r = new WeakReference<FocusHierarchyListener>(l);
            this._listeners.add(r);
            int n = this._listeners.size();
            for (int i = n - 1; i >= 0; --i) {
                WeakReference ref = (WeakReference)this._listeners.get(i);
                if (ref.get() != null) continue;
                this._listeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFocusHierarchyListener(FocusHierarchyListener l) {
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            int n = this._listeners.size();
            for (int i = n - 1; i >= 0; --i) {
                WeakReference ref = (WeakReference)this._listeners.get(i);
                if (ref.get() != l) continue;
                this._listeners.remove(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventDispatched(AWTEvent event) {
        FocusEvent e = (FocusEvent)event;
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            FocusHierarchyEvent fhe = new FocusHierarchyEvent(e);
            int n = this._listeners.size();
            WeakReference[] wrs = this._listeners.toArray(new WeakReference[n]);
            block7: for (int i = 0; i < n; ++i) {
                FocusHierarchyListener l = (FocusHierarchyListener)wrs[i].get();
                if (l == null) continue;
                switch (e.getID()) {
                    case 1004: {
                        l.focusGained(fhe);
                        continue block7;
                    }
                    case 1005: {
                        l.focusLost(fhe);
                    }
                }
            }
        }
    }
}

