/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.property.Internal;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;

public class Comparison
extends Operation {
    public Comparison() {
        this(null, Comparator.EQUAL);
    }

    public Comparison(SQLFragment sQLFragment, Comparator comparator) {
        this(sQLFragment, comparator, null);
    }

    public Comparison(Comparator comparator, SQLFragment[] sQLFragmentArray) {
        this.setFunctionFormat(true);
        this.setComparator(comparator);
        this.setArguments(sQLFragmentArray);
    }

    public Comparison(SQLFragment sQLFragment, Comparator comparator, SQLFragment sQLFragment2) {
        this.setFunctionFormat(false);
        this.setLeftExpression(sQLFragment);
        this.setRightExpression(sQLFragment2);
        this.setComparator(comparator);
    }

    public Comparator getComparator() {
        return (Comparator)((Object)this.getProperty("comparator"));
    }

    @Override
    public String getOperatorText() {
        Comparator comparator = this.getComparator();
        return comparator == null ? null : comparator.getSQLText();
    }

    public void setComparator(Comparator comparator) {
        this.setProperty("comparator", (Object)comparator);
    }

    public SQLFragment getLeftExpression() {
        return (SQLFragment)this.getProperty("leftExpression");
    }

    public void setLeftExpression(SQLFragment sQLFragment) {
        this.setProperty("leftExpression", sQLFragment);
    }

    public SQLFragment getRightExpression() {
        return (SQLFragment)this.getProperty("rightExpression");
    }

    public void setRightExpression(SQLFragment sQLFragment) {
        this.setProperty("rightExpression", sQLFragment);
    }

    public void setPriorOnLeft(boolean bl) {
        this.setProperty("priorOnLeft", bl);
    }

    public boolean getPriorOnLeft() {
        return (Boolean)this.getProperty("priorOnLeft", false);
    }

    public void setPriorOnRight(boolean bl) {
        this.setProperty("priorOnRight", bl);
    }

    public boolean getPriorOnRight() {
        return (Boolean)this.getProperty("priorOnRight", false);
    }

    @Override
    protected void checkNewSize(int n) {
        if (n != 2 && n != 1) {
            throw new IllegalArgumentException(APIBundle.get("SQL_COMPARISON_ARGS"));
        }
    }

    @Override
    public String getSQLText() {
        Object object;
        Comparator comparator = this.getComparator();
        if (comparator == Comparator.REGEXP_LIKE) {
            object = super.getSQLText();
        } else if (comparator == Comparator.NULL || comparator == Comparator.NOT_NULL) {
            object = this.getTextOrNull(this.getArguments()[0]) + " " + comparator.getSQLText();
        } else if (comparator == Comparator.JSON || comparator == Comparator.NOT_JSON) {
            StringBuilder stringBuilder = new StringBuilder();
            SQLFragment[] sQLFragmentArray = this.getArguments();
            stringBuilder.append(this.getTextOrNull(sQLFragmentArray[0])).append(" ").append(comparator.getSQLText());
            for (int i = 1; i < sQLFragmentArray.length; ++i) {
                if (sQLFragmentArray[i] == null) continue;
                stringBuilder.append(" ").append(sQLFragmentArray[i].getSQLText());
            }
            object = stringBuilder.toString();
        } else {
            object = comparator == Comparator.EXISTS || comparator == Comparator.NOT_EXISTS ? comparator.getSQLText() + " " + this.getTextOrNull(this.getArguments()[0], true) : this.buildComparisson();
        }
        return object;
    }

    @Override
    public void addArgument(int n, SQLFragment sQLFragment) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    @Override
    public void addArgument(SQLFragment sQLFragment) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    @Override
    public void addArguments(SQLFragment[] sQLFragmentArray) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    @Override
    public int getArgumentCount() {
        return this.getRightExpression() == null ? 1 : 2;
    }

    @Override
    public void setArguments(SQLFragment[] sQLFragmentArray) {
        if (sQLFragmentArray != null && sQLFragmentArray.length > 0) {
            this.setLeftExpression(sQLFragmentArray[0]);
            if (sQLFragmentArray.length > 1) {
                this.setRightExpression(sQLFragmentArray[1]);
            }
        }
    }

    @Override
    public boolean removeArgument(SQLFragment sQLFragment) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    @Override
    @Internal
    public SQLFragment[] getArguments() {
        return new SQLFragment[]{this.getLeftExpression(), this.getRightExpression()};
    }

    private String buildComparisson() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getTextOrNull(this.getLeftExpression());
        String string2 = this.getTextOrNull(this.getRightExpression());
        String string3 = this.getOperatorText();
        boolean bl = this.getPriorOnLeft();
        boolean bl2 = this.getPriorOnRight();
        if (bl) {
            stringBuffer.append("PRIOR").append(" ");
        }
        stringBuffer.append(string).append(" ");
        stringBuffer.append(string3).append(" ");
        if (bl2) {
            stringBuffer.append("PRIOR").append(" ");
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static Comparator getComparator(String string) {
        Comparator comparator = null;
        for (Comparator comparator2 : Comparator.values()) {
            if (!comparator2.getSQLText().equals(string)) continue;
            comparator = comparator2;
            break;
        }
        return comparator;
    }

    public static enum Comparator {
        GREATER(">", 1),
        LESS("<", 2),
        GREATER_EQUAL(">=", 3),
        LESS_EQUAL("<=", 4),
        EQUAL("=", 5),
        NOT_EQUAL("!=", 6),
        NULL("IS NULL", 43),
        NOT_NULL("IS NOT NULL", 44),
        LIKE("LIKE", 26),
        NOT_LIKE("NOT LIKE", 27),
        REGEXP_LIKE("REGEXP_LIKE", 524),
        EXISTS("EXISTS", 10004),
        NOT_EXISTS("NOT EXISTS", 10005),
        EQUAL_ANY("=ANY", 729),
        NOT_EQUAL_ANY("!=ANY", 732),
        GREATER_THAN_ANY(">ANY", 733),
        GREATER_THAN_OR_EQUAL_ANY(">=ANY", 734),
        LESS_THAN_ANY("<ANY", 735),
        LESS_THAN_OR_EQUAL_ANY("<=ANY", 736),
        EQUAL_SOME("=SOME", 737),
        NOT_EQUAL_SOME("!=SOME", 738),
        GREATER_THAN_SOME(">SOME", 739),
        GREATER_THAN_OR_EQUAL_SOME(">=SOME", 740),
        LESS_THAN_SOME("<SOME", 741),
        LESS_THAN_OR_EQUAL_SOME("<=SOME", 742),
        EQUAL_ALL("=ALL", 743),
        NOT_EQUAL_ALL("!=ALL", 744),
        GREATER_THAN_ALL(">ALL", 745),
        GREATER_THAN_OR_EQUAL_ALL(">=ALL", 746),
        LESS_THAN_ALL("<ALL", 747),
        LESS_THAN_OR_EQUAL_ALL("<=ALL", 748),
        JSON("IS JSON", null),
        NOT_JSON("IS NOT JSON", null);

        private final String m_sql;
        private final Integer m_oldValue;

        private Comparator(String string2, Integer n2) {
            this.m_sql = string2;
            this.m_oldValue = n2;
        }

        public String getSQLText() {
            return this.m_sql;
        }

        public static Comparator migrate(String string) {
            Comparator comparator = null;
            if (string != null) {
                for (Comparator comparator2 : Comparator.values()) {
                    if (comparator2.m_oldValue == null || !string.equals(String.valueOf(comparator2.m_oldValue))) continue;
                    comparator = comparator2;
                    break;
                }
            }
            return comparator;
        }
    }
}

