/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.refactoring;

import oracle.javatools.db.DBException;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.refactoring.UpdateProcessor;

public abstract class RefactoringProcessor
extends UpdateProcessor {
    @Override
    public final void processUpdate(DBObjectTransaction dBObjectTransaction, Difference difference) throws DBException {
        this.processObjectDifference(dBObjectTransaction, difference);
    }

    protected void processObjectDifference(DBObjectTransaction dBObjectTransaction, Difference difference) throws DBException {
        SystemObject systemObject = (SystemObject)difference.getOriginalObject();
        SystemObject systemObject2 = (SystemObject)difference.getUpdatedObject();
        if (systemObject == null && systemObject2 == null) {
            throw new DBException(null, "operation must be create, update or delete");
        }
        if (systemObject == null) {
            this.processObjectCreate(dBObjectTransaction, systemObject2);
        } else if (systemObject2 == null) {
            this.processObjectDelete(dBObjectTransaction, systemObject);
        } else if (!difference.isSame()) {
            this.processObjectUpdate(dBObjectTransaction, difference);
        }
    }

    protected void processObjectCreate(DBObjectTransaction dBObjectTransaction, SystemObject systemObject) throws DBException {
    }

    protected void processObjectDelete(DBObjectTransaction dBObjectTransaction, SystemObject systemObject) throws DBException {
    }

    protected void processObjectUpdate(DBObjectTransaction dBObjectTransaction, Difference difference) throws DBException {
    }
}

