/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.DynamicPropertyProvider;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public final class PropertyHelper {
    private Map<Class, Map<String, PropertyDescriptor>> m_propsCache;
    private final DBObjectProvider m_pro;

    public PropertyHelper() {
        this(null);
    }

    public PropertyHelper(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
    }

    private Logger getLogger() {
        return DBLog.getLogger(this);
    }

    private Map<Class, Map<String, PropertyDescriptor>> getPropsCache() {
        if (this.m_propsCache == null) {
            this.m_propsCache = new HashMap<Class, Map<String, PropertyDescriptor>>();
        }
        return this.m_propsCache;
    }

    public Object getPropertyValue(Object object, String string) {
        Object object2 = null;
        try {
            object2 = this.getPropertyValueOrFail(object, string);
        }
        catch (MissingPropertyException missingPropertyException) {
            this.getLogger().log(Level.FINE, missingPropertyException.getMessage());
        }
        return object2;
    }

    public Object getPropertyValueOrFail(Object object, String string) throws MissingPropertyException {
        return this.getPropertyValueImpl(object, string, null, false);
    }

    private Object getPropertyValueImpl(Object object, String string, Object object2, boolean bl) throws MissingPropertyException {
        Object object3;
        boolean bl2;
        MissingPropertyException missingPropertyException;
        block40: {
            Object object4;
            Object object5;
            Object object6;
            if (string == null) {
                throw new MissingPropertyException(object, "");
            }
            missingPropertyException = null;
            if (object instanceof DBObjectID) {
                if ("name".equals(string)) {
                    String string2 = DBUtil.getDBObjectName((DBObjectID)object);
                    return ModelUtil.hasLength((String)string2) ? string2 : null;
                }
                if (Property.createPath("schema", "name").equals(string)) {
                    String string3 = DBUtil.getSchemaName((DBObjectID)object);
                    return ModelUtil.hasLength((String)string3) ? string3 : null;
                }
                try {
                    DBObject dBObject = ((DBObjectID)object).resolveID();
                    if (dBObject != null && (object6 = this.getPropertyValueImpl(dBObject, string, null, bl)) != null) {
                        return object6;
                    }
                }
                catch (MissingPropertyException missingPropertyException2) {
                    missingPropertyException = missingPropertyException2;
                }
                catch (DBException dBException) {
                    this.getLogger().log(Level.FINE, "Error accessing property " + string + ": " + dBException.getMessage());
                }
            }
            int n = string.indexOf("/");
            object6 = null;
            if (n > -1) {
                object6 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            bl2 = false;
            object3 = null;
            boolean bl3 = "properties".equals(string);
            if (bl3 && object instanceof DBObject && object6 != null) {
                object3 = object;
                bl2 = true;
            } else {
                if (object instanceof Map && ((Map)object).containsKey(string)) {
                    object3 = ((Map)object).get(string);
                    bl2 = true;
                } else {
                    object5 = this.getPropertyInfo(object, string);
                    if (object5 != null) {
                        bl2 = true;
                        object3 = ((PropertyInfo)object5).getPropertyValue(object);
                        if (object3 == null && bl) {
                            object4 = ((PropertyInfo)object5).getPropertyClass();
                            if (this.m_pro != null && DBObject.class.isAssignableFrom((Class<?>)object4)) {
                                object3 = this.m_pro.getObjectFactory().newObject(object4);
                            } else if (Copyable.class.isAssignableFrom((Class<?>)object4)) {
                                try {
                                    object3 = ((Class)object4).newInstance();
                                }
                                catch (Exception exception) {
                                    this.getLogger().log(Level.FINE, string, exception);
                                }
                            }
                            if (object3 != null) {
                                try {
                                    ((PropertyInfo)object5).setPropertyValue(object, object3);
                                }
                                catch (Exception exception) {
                                    this.getLogger().log(Level.FINE, exception.getMessage());
                                }
                            }
                        }
                    } else if (object instanceof DBObject) {
                        object3 = ((DBObject)object).getProperty(string);
                        boolean bl4 = bl2 = object3 != null;
                    }
                }
                if (!bl2 && (object5 = this.getProperty(object, string)) != null) {
                    object4 = ((PropertyDescriptor)object5).getReadMethod();
                    try {
                        object3 = ((Method)object4).invoke(object, (Object[])null);
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        this.getLogger().log(Level.SEVERE, "Error accessing property " + string, exception);
                    }
                }
                if (!bl2 && !(object instanceof DBObject) && object instanceof Copyable && (object5 = this.getProperty(object, "properties")) != null && (object4 = this.getPropertyValue(object, "properties")) instanceof Map) {
                    object3 = ((Map)object4).get(string);
                    bl2 = true;
                }
            }
            if (object3 != null && object6 != null) {
                if (object3 instanceof Object[]) {
                    object5 = (Object[])object3;
                    try {
                        object4 = new Object[((Object)object5).length];
                        for (int i = 0; i < ((Object)object5).length; ++i) {
                            object4[i] = this.getPropertyValueImpl(object5[i], (String)object6, object, false);
                        }
                        object3 = object4;
                    }
                    catch (MissingPropertyException missingPropertyException3) {
                        DBObject dBObject = null;
                        for (int i = 0; i < ((Object)object5).length; ++i) {
                            if (!(object5[i] instanceof DBObject) || !((String)object6).equals(((DBObject)object5[i]).getName()) && !((String)object6).startsWith(((DBObject)object5[i]).getName() + "/")) continue;
                            dBObject = (DBObject)object5[i];
                            break;
                        }
                        if (dBObject != null) {
                            object3 = ((String)object6).equals(dBObject.getName()) ? dBObject : this.getPropertyValueImpl(dBObject, ((String)object6).substring(dBObject.getName().length() + 1), object, bl);
                            break block40;
                        }
                        missingPropertyException = missingPropertyException3;
                    }
                } else {
                    object3 = this.getPropertyValueImpl(object3, (String)object6, object, bl);
                }
            }
        }
        if (!bl2) {
            if (missingPropertyException == null) {
                if (this.isValidProperty(object instanceof Map ? object2 : object, string)) {
                    return null;
                }
                missingPropertyException = new MissingPropertyException(object, string);
            }
            throw missingPropertyException;
        }
        return object3;
    }

    private boolean isValidProperty(Object object, String string) {
        PropertyInfo propertyInfo = null;
        if (object instanceof Copyable && (propertyInfo = this.getPropertyInfoImpl(((Copyable)object).getClass(), string)) == null && object instanceof DBObjectID) {
            String string2 = ((DBObjectID)object).getType();
            propertyInfo = this.getPropertyInfoImpl(Metadata.getInstance().getObjectClass(string2), string);
        }
        return propertyInfo != null;
    }

    private PropertyInfo getPropertyInfo(Object object, String string) {
        PropertyInfo propertyInfo = null;
        if (object instanceof Copyable) {
            propertyInfo = this.getPropertyInfoImpl(((Copyable)object).getClass(), string);
        }
        return propertyInfo;
    }

    private PropertyInfo getPropertyInfoImpl(Class<? extends Copyable> clazz, String string) {
        PropertyInfo propertyInfo = null;
        if (clazz != null) {
            propertyInfo = this.m_pro != null && DBObject.class.isAssignableFrom(clazz) ? this.m_pro.getPropertyManager().findPropertyInfo(clazz, string) : PropertyHelper.findPropertyInfo(clazz, string, this.m_pro);
        }
        return propertyInfo;
    }

    public void setPropertyValue(Object object, String string, Object object2) {
        try {
            this.setPropertyValueOrFail(object, string, object2);
        }
        catch (MissingPropertyException missingPropertyException) {
            this.getLogger().log(Level.FINE, missingPropertyException.getMessage());
        }
    }

    public void setPropertyValueOrFail(Object object, String string, Object object2) throws MissingPropertyException {
        String string2;
        String string3;
        int n = string.lastIndexOf("/");
        if (n > -1) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = null;
            string2 = string;
        }
        Object object3 = string3 == null ? object : this.getPropertyValueImpl(object, string3, null, object2 != null);
        if (object3 != null) {
            if (object3 instanceof Map) {
                if (object2 == null) {
                    ((Map)object3).remove(string2);
                } else {
                    ((Map)object3).put(string2, object2);
                }
            } else {
                if (object3 instanceof DBObjectID) {
                    try {
                        object3 = ((DBObjectID)object3).resolveID();
                    }
                    catch (DBException dBException) {
                        this.getLogger().warning("Could not resolve id to set property" + dBException.getMessage());
                    }
                }
                if (object3 instanceof DBObject && !"properties".equals(string2)) {
                    PropertyInfo propertyInfo = this.getPropertyInfo(object3, string2);
                    if (propertyInfo == null) {
                        throw new MissingPropertyException(object3, string2);
                    }
                    try {
                        propertyInfo.setPropertyValue(object3, object2);
                    }
                    catch (Exception exception) {
                        this.getLogger().log(DBLog.getExceptionLogLevel(), "Could not set property value for " + string2, exception);
                    }
                } else {
                    PropertyDescriptor propertyDescriptor = this.getProperty(object3, string2);
                    if (propertyDescriptor == null || propertyDescriptor.getWriteMethod() == null) {
                        PropertyDescriptor propertyDescriptor2;
                        boolean bl = false;
                        if (!(object3 instanceof DBObject) && object3 instanceof Copyable && (propertyDescriptor2 = this.getProperty(object3, "properties")) != null && Map.class.isAssignableFrom(propertyDescriptor2.getPropertyType()) && propertyDescriptor2.getReadMethod() != null && propertyDescriptor2.getWriteMethod() != null) {
                            HashMap<String, Object> hashMap = (HashMap<String, Object>)this.getPropertyValue(object3, "properties");
                            if (hashMap == null) {
                                hashMap = new HashMap<String, Object>();
                            }
                            hashMap.put(string2, object2);
                            this.setPropertyValue(object3, "properties", hashMap);
                            bl = true;
                        }
                        if (!bl) {
                            throw new MissingPropertyException(object3, string2);
                        }
                    } else {
                        Method method = propertyDescriptor.getWriteMethod();
                        try {
                            method.invoke(object3, object2);
                        }
                        catch (Exception exception) {
                            this.getLogger().log(Level.SEVERE, "Could not set property value for {0}: {1}", new Object[]{string2, exception.getMessage()});
                        }
                    }
                }
            }
        }
    }

    private PropertyDescriptor getProperty(Object object, String string) {
        Map<String, PropertyDescriptor> map = this.getProperties(object.getClass());
        return map == null ? null : map.get(string);
    }

    private Map<String, PropertyDescriptor> getProperties(Class clazz) {
        Map<String, PropertyDescriptor> map = this.getPropsCache().get(clazz);
        if (map == null) {
            map = new HashMap<String, PropertyDescriptor>();
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                    if (propertyDescriptorArray[i].getReadMethod() == null) continue;
                    map.put(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i]);
                }
            }
            catch (Exception exception) {
                this.getLogger().log(DBLog.getExceptionLogLevel(), clazz.getName(), exception);
            }
            this.getPropsCache().put(clazz, map);
        }
        return map;
    }

    public Difference getChildDifference(Difference difference, String string) throws MissingPropertyException {
        return this.getChildDifference(difference, string, false);
    }

    public Difference getChildDifference(Difference difference, String string, boolean bl) throws MissingPropertyException {
        String[] stringArray = Property.getProperties(string);
        boolean bl2 = false;
        Difference difference2 = difference;
        for (String string2 : stringArray) {
            if (!ModelUtil.hasLength((String)string2)) {
                throw new IllegalArgumentException("invalid property path " + string);
            }
            if ((difference2 = this.findChildDifference(difference2, string2)) == null) {
                bl2 = false;
                break;
            }
            bl2 = true;
            if (!bl || !difference2.isSame()) continue;
            difference2 = null;
            break;
        }
        if (bl2) {
            return difference2;
        }
        if (this.isValidProperty(difference.getOriginalObject(), stringArray[0])) {
            return null;
        }
        throw new MissingPropertyException(difference.getOriginalObject(), string);
    }

    private Difference findChildDifference(Difference difference, String string) {
        Difference difference2;
        Difference difference3 = difference.getChildDifference(string);
        if (difference3 == null && (difference2 = difference.getChildDifference("properties")) != null) {
            difference3 = this.findChildDifference(difference2, string);
        }
        return difference3;
    }

    public static PropertyInfo findPropertyInfo(String string, String string2, Class<? extends DBObjectProvider> clazz) {
        Class<? extends DBObject> clazz2 = Metadata.getInstance().getObjectClass(string);
        return clazz2 == null ? null : PropertyHelper.findPropertyInfo(clazz2, string2, clazz);
    }

    public static PropertyInfo findPropertyInfo(Class clazz, String string, Class<? extends DBObjectProvider> clazz2) {
        return PropertyHelper.findPropertyInfoImpl(clazz, string, null, clazz2);
    }

    public static PropertyInfo findPropertyInfo(Class clazz, String string, DBObjectProvider dBObjectProvider) {
        return PropertyHelper.findPropertyInfoImpl(clazz, string, dBObjectProvider, dBObjectProvider == null ? null : dBObjectProvider.getClass());
    }

    private static PropertyInfo findPropertyInfoImpl(Class clazz, String string, DBObjectProvider dBObjectProvider, Class<? extends DBObjectProvider> clazz2) {
        String string2;
        String string3;
        PropertyInfo propertyInfo = null;
        if (string.contains("/")) {
            int n = string.indexOf("/");
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = string;
            string2 = null;
        }
        propertyInfo = Metadata.getInstance().getSupportedProperty(clazz, string3, clazz2);
        if (propertyInfo != null && ModelUtil.hasLength(string2)) {
            DynamicPropertyProvider dynamicPropertyProvider;
            Class<?> clazz3 = propertyInfo.getPropertyClass();
            if (Map.class.isAssignableFrom(clazz3)) {
                clazz3 = clazz;
            } else if (clazz3.isArray()) {
                clazz3 = clazz3.getComponentType();
            }
            PropertyInfo propertyInfo2 = propertyInfo;
            propertyInfo = PropertyHelper.findPropertyInfoImpl(clazz3, string2, dBObjectProvider, clazz2);
            if (propertyInfo == null && dBObjectProvider != null && (dynamicPropertyProvider = propertyInfo2.getDynamicPropertyProvider()) != null) {
                propertyInfo = dynamicPropertyProvider.getPropertyInfo(clazz, string2, dBObjectProvider);
            }
        }
        return propertyInfo;
    }

    public static Map<String, PropertyInfo> getPropertyInfos(Class<?> clazz, Class<? extends DBObjectProvider> clazz2, PropertyCriteria propertyCriteria) {
        return Metadata.getInstance().getSupportedPropertiesMap(clazz, clazz2, propertyCriteria);
    }
}

