/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ddl.DefaultTokenGenerator;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.diff.DefaultResultSetFilter;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.util.PropertySet;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

class TokenProcessor {
    private static final String DOT = ".";
    private static final String ASTERISK = "*";
    private static final String EACH = "each";
    private static final String THIS = "this";
    private static final String OLD = "old";
    private static final String EACHDOT = "each.";
    private static final String THISDOT = "this.";
    private static final String OLDDOT = "old.";
    private final Map<String, TokenGenerator> m_tokenGenerators = new HashMap<String, TokenGenerator>();
    private final PropertyHelper m_propHelper;
    private Collection<String> m_propSearch;
    private long m_propSearchStart;

    TokenProcessor() {
        this(new PropertyHelper());
    }

    TokenProcessor(PropertyHelper propertyHelper) {
        this.registerDefaults();
        this.m_propHelper = propertyHelper;
    }

    private void registerDefaults() {
        this.registerGenerator("replace", new TokenGenerator.ReplaceGenerator());
        this.registerGenerator("cascade", new TokenGenerator.CascadeGenerator());
        this.registerGenerator("schema.name", new TokenGenerator.NameGenerator());
        this.registerGenerator("quotedComment", new TokenGenerator.CommentGenerator());
        this.registerGenerator("defaultSchema", new TokenGenerator.DefaultSchemaGenerator());
    }

    public void registerGenerator(String string, TokenGenerator tokenGenerator) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{EACH, OLD, THIS}) {
            if (!string.startsWith(string2)) continue;
            throw new TokenProcessorException("cannot register generator token names starting with \"" + string2 + "\"");
        }
        tokenGenerator.setProcessor(this, string);
        TokenGenerator tokenGenerator2 = this.m_tokenGenerators.put(string, tokenGenerator);
        if (tokenGenerator2 != null) {
            // empty if block
        }
    }

    PropertyHelper getPropertyHelper() {
        return this.m_propHelper;
    }

    boolean canProcess(Object object) {
        return this.hasRegisteredToken(this.getKey(object));
    }

    boolean hasRegisteredToken(String string) {
        return this.m_tokenGenerators.containsKey(string);
    }

    private String getKey(Object object) {
        if (object instanceof DBObject) {
            String string = ((DBObject)object).getType();
            if (object instanceof Constraint) {
                return string + DOT + ((Constraint)object).getConstraintType();
            }
            return string;
        }
        return null;
    }

    void process(Object object, TokenContext tokenContext) {
        String string = this.getKey(object);
        TokenGenerator tokenGenerator = this.m_tokenGenerators.get(string);
        if (tokenGenerator == null) {
            throw new TokenProcessorException("No generator found for object " + string);
        }
        tokenContext.setProcessor(this);
        tokenGenerator.generateToken(tokenContext);
    }

    public void process(String string, TokenContext tokenContext) {
        tokenContext.setProcessor(this);
        this.process(string, 0, string.length() - 1, tokenContext);
    }

    private void process(String string, int n, int n2, TokenContext tokenContext) {
        while (n >= 0 && n <= n2) {
            n = this.processNext(string, n, n2, tokenContext);
        }
    }

    private int processNext(String string, int n, int n2, TokenContext tokenContext) {
        if (n >= string.length() || n > n2) {
            return -1;
        }
        char c = string.charAt(n);
        if (c == '[') {
            int n3 = TokenProcessor.findMatching('[', ']', string, ++n);
            this.processBlock(string, n, n3 - 1, tokenContext);
            return this.skipWhitespace(string, n3 + 1, tokenContext);
        }
        if (c == '{') {
            int n4 = TokenProcessor.findMatching('{', '}', string, ++n);
            this.processToken(string, n, n4 - 1, tokenContext, TokenAction.GENERATE);
            return this.skipWhitespace(string, n4 + 1, tokenContext);
        }
        if (c == '\t') {
            tokenContext.append("  ");
            return ++n;
        }
        if (c == '\\') {
            if (this.isEscaped(string, n)) {
                tokenContext.append(Character.valueOf(c));
            }
            return ++n;
        }
        if (!this.isEscaped(string, n)) {
            if (c == '>') {
                tokenContext.incrementIndent();
                return ++n;
            }
            if (c == '<') {
                tokenContext.decrementIndent();
                return ++n;
            }
        }
        tokenContext.append(Character.valueOf(c));
        return ++n;
    }

    private boolean isEscaped(String string, int n) {
        return n > 0 && string.charAt(n - 1) == '\\';
    }

    private static int findMatching(char c, char c2, String string, int n) {
        int n2 = 0;
        for (int i = n; i < string.length(); ++i) {
            char c3 = string.charAt(i);
            if (c3 == c) {
                ++n2;
                continue;
            }
            if (c3 != c2 || n2-- != 0) continue;
            return i;
        }
        throw new TokenProcessorException(c, c2, string, n);
    }

    private void processBlock(String string, int n, int n2, TokenContext tokenContext) {
        char c2;
        boolean bl;
        String string2 = string.substring(n, n2 + 1);
        if (tokenContext.getBlock() != null) {
            tokenContext = tokenContext.newChildContext(null);
        }
        tokenContext.setBlock(string2);
        boolean bl2 = string2.endsWith("...");
        Object object = "";
        if (bl2) {
            bl = false;
            c2 = '\u0000';
            if (string.charAt(n2 -= 3) == '\'') {
                c2 = '\u0001';
                --n2;
            }
            while (n2 > n) {
                char c = string.charAt(n2);
                if (c2 != '\u0000') {
                    if (c == '\'') {
                        if (string.charAt(--n2) != ' ') break;
                        --n2;
                        break;
                    }
                } else {
                    if (c == ' ') {
                        --n2;
                        break;
                    }
                    if (c == '}' || c == ']') break;
                }
                if (Character.isWhitespace(c)) {
                    bl = true;
                }
                object = c + (String)object;
                --n2;
            }
            if (((String)object).length() == 0) {
                object = ", ";
            } else if (!bl) {
                object = " " + (String)object + " ";
            }
        }
        bl = false;
        c2 = string.charAt(n);
        if (c2 == '!') {
            bl = true;
            c2 = string.charAt(++n);
        }
        if (c2 == '{') {
            int n3 = TokenProcessor.findMatching('{', '}', string, ++n);
            Object[] objectArray = this.processToken(string, n, n3 - 1, tokenContext, bl2 ? TokenAction.FOREACH : TokenAction.IF);
            if (bl2) {
                if (objectArray != null) {
                    if (!(objectArray instanceof Object[])) {
                        if (objectArray instanceof Collection) {
                            objectArray = ((Collection)objectArray).toArray();
                        } else {
                            throw new TokenProcessorException("can't loop without an array property at index ", string, n);
                        }
                    }
                    int bl3 = this.skipWhitespace(string, n3 + 1, tokenContext);
                    int n5 = tokenContext.length();
                    for (Object n8 : objectArray) {
                        if (n8 == null) continue;
                        tokenContext.setLoopObject(n8);
                        if (tokenContext.length() > n5) {
                            tokenContext.append(object);
                            n5 = tokenContext.length();
                        }
                        this.process(string, bl3, n2, tokenContext);
                    }
                }
                tokenContext.removeIfEndsWith((String)object);
                tokenContext.setLoopObject(null);
            } else {
                Boolean bl3 = this.evaluateIf(objectArray);
                if (bl3 != null) {
                    int n4 = this.skipWhitespace(string, n3 + 1, tokenContext);
                    String string3 = string.substring(n4, n2 + 1);
                    int n5 = -1;
                    int n6 = 0;
                    int n7 = 32;
                    for (int i = 0; i < string3.length(); ++i) {
                        char c = string3.charAt(i);
                        if (c == '[') {
                            ++n6;
                        } else if (c == ']') {
                            --n6;
                        } else if (c == ':' && n7 != 92 && n6 == 0) {
                            n5 = i;
                            break;
                        }
                        n7 = c;
                    }
                    if (bl3 != null && bl3 != bl) {
                        if (n5 >= 0) {
                            n2 = this.ignoreWhitespace(string, n4 + n5 - 1, tokenContext);
                        }
                        this.process(string, n4, n2, tokenContext);
                    } else if (n5 >= 0) {
                        n4 = this.skipWhitespace(string, n4 + n5 + 1, tokenContext);
                        this.process(string, n4, n2, tokenContext);
                    }
                }
            }
        }
        tokenContext.setBlock(null);
    }

    private Object processToken(String string, int n, int n2, TokenContext tokenContext, TokenAction tokenAction) {
        String string2 = string.substring(n, n2 + 1);
        return this.processToken(string2, tokenContext, tokenAction);
    }

    private Object processToken(String string, TokenContext tokenContext, TokenAction tokenAction) {
        char c;
        if (";".equals(string)) {
            tokenContext.endCurrentStatement();
            return null;
        }
        Operator operator = Operator.findOperator(string);
        if (operator != null) {
            return this.processOperator(operator, string, tokenContext, tokenAction);
        }
        boolean bl = false;
        if (string.charAt(0) == '\"') {
            if (string.charAt(string.length() - 1) != '\"') {
                throw new TokenProcessorException("tokens starting with \" should end with \" to indiate quoting is required.");
            }
            bl = true;
            if (!((string = string.substring(1, string.length() - 1)).charAt(0) == '$' || string.startsWith("each.$") || string.startsWith("old.$") || string.startsWith("each.$"))) {
                throw new TokenProcessorException("token quoting is only available on property lookups (i.e. \"$propName\"");
            }
        }
        if (string.startsWith(EACH)) {
            Object object = tokenContext.getLoopObject();
            if (object == null) {
                throw new TokenProcessorException("\"each\" cannot be used outside of a loop");
            }
            if (string.equals(EACH)) {
                tokenContext.append(object);
                return null;
            }
            if (string.startsWith(EACHDOT)) {
                String string2 = string.substring(5).trim();
                TokenContext tokenContext2 = tokenContext.newChildContext(object);
                return this.processToken(string2, tokenContext2, tokenAction);
            }
        } else {
            if (string.startsWith(OLDDOT)) {
                String string3 = string.substring(4);
                if (!tokenContext.isUpdate()) {
                    throw new TokenProcessorException("\"old\" can only be used in update DDL");
                }
                if (string.length() < 1) {
                    throw new TokenProcessorException("\"old.\" must be followed by a valid token");
                }
                Difference difference = tokenContext.getDifference();
                Object object = difference.getOriginalObject();
                if (object == null) {
                    throw new TokenProcessorException("no old object to process for token: " + string);
                }
                return this.processToken(string3, tokenContext.newChildContext(object), tokenAction);
            }
            if (string.startsWith(THIS)) {
                if (string.equals(THIS)) {
                    tokenContext.append(tokenContext.getObject());
                    return null;
                }
                if (string.startsWith(THISDOT)) {
                    string = string.substring(5);
                }
            }
        }
        if ((c = string.charAt(0)) == '$') {
            String string4;
            String string5 = string.substring(1);
            if (string5.trim().equals(ASTERISK)) {
                return this.evaluateAllProperties(false, tokenAction, tokenContext);
            }
            int n = string5.indexOf(DOT);
            if (n >= 0 && this.m_tokenGenerators.containsKey(string4 = string5.substring(n + 1))) {
                String string6 = string5.substring(0, n);
                Object object = this.processProperty(string6, tokenContext, bl, TokenAction.IF);
                TokenContext tokenContext3 = null;
                Object object2 = tokenContext.getObject();
                if (tokenContext.isUpdate() && object2 instanceof DBObject && object instanceof DBObject) {
                    Difference difference = tokenContext.getDifference();
                    try {
                        Difference difference2 = this.getPropertyHelper().getChildDifference(difference, DBUtil.getPropertyPath((DBObject)object2, (DBObject)object));
                        if (difference2 == null) {
                            throw new TokenProcessorException("Couldn't find child in diff");
                        }
                        tokenContext3 = tokenContext.newChildContext(difference2);
                    }
                    catch (MissingPropertyException missingPropertyException) {
                        throw new TokenProcessorException(missingPropertyException.getMessage());
                    }
                } else {
                    tokenContext3 = tokenContext.newChildContext(object);
                }
                return this.processToken(string4, tokenContext3, tokenAction);
            }
            return this.processProperty(string5, tokenContext, bl, tokenAction);
        }
        if (c == '^') {
            if (!tokenContext.isUpdate()) {
                throw new TokenProcessorException("\"^\" can only be used in update DDL");
            }
            if (tokenAction == TokenAction.IF || tokenAction == TokenAction.FOREACH) {
                Object object;
                block41: {
                    String string7 = string.substring(1);
                    if (string7.trim().equals(ASTERISK)) {
                        return this.evaluateAllProperties(true, tokenAction, tokenContext);
                    }
                    if (string7.charAt(0) == '^') {
                        string7 = string7.substring(1);
                        Difference difference = tokenContext.getDifference();
                        if (!difference.isSame()) {
                            DefaultResultSetFilter defaultResultSetFilter = new DefaultResultSetFilter();
                            defaultResultSetFilter.addFilteredProps(Property.createPath(difference.getPropertyName(), string7));
                            Difference difference3 = difference.getFilteredDifference(defaultResultSetFilter);
                            return difference3.isSame();
                        }
                        return false;
                    }
                    object = null;
                    try {
                        object = this.getChangedProperty(string7, tokenContext);
                    }
                    catch (MissingPropertyException missingPropertyException) {
                        DBLog.getLogger(this).log(Level.FINE, missingPropertyException.getMessage());
                        if (tokenAction != TokenAction.IF) break block41;
                        return false;
                    }
                }
                return object;
            }
            throw new TokenProcessorException("\"^\" can only be used in an if - e.g. [{^propThatChanged} NEW PROP TEXT]");
        }
        if (c == '+' || c == '-') {
            if (tokenAction != TokenAction.FOREACH && tokenAction != TokenAction.IF) {
                throw new TokenProcessorException("\"+\" and \"-\" can only be used in a loop or if - e.g. [{+newChildren} {each} ...]");
            }
            if (!tokenContext.isUpdate()) {
                throw new TokenProcessorException("\"+\" and \"-\" can only be used in update DDL");
            }
            String string8 = string.substring(1);
            try {
                Difference difference = this.findChangedProperty(string8, tokenContext);
                if (difference != null && !difference.isSame()) {
                    return this.getObjects(difference, c == '+');
                }
            }
            catch (MissingPropertyException missingPropertyException) {
                DBLog.getLogger(this).log(Level.FINE, missingPropertyException.getMessage());
            }
            return null;
        }
        TokenGenerator tokenGenerator = this.m_tokenGenerators.get(string);
        if (tokenGenerator == null) {
            throw new GeneratorMissingException(string);
        }
        if (tokenAction == TokenAction.GENERATE) {
            tokenGenerator.generateToken(tokenContext);
            return null;
        }
        return tokenGenerator.evaluateToken(tokenContext);
    }

    private boolean evaluateAllProperties(boolean bl, TokenAction tokenAction, TokenContext tokenContext) {
        String string = tokenContext.getBlock();
        if (tokenAction == TokenAction.IF || string == null) {
            Object object = tokenContext.getObject();
            Collection<PropertyToken> collection = this.getPropertyPaths(string, bl, tokenContext);
            for (PropertyToken propertyToken : collection) {
                Object object2;
                Object[] objectArray;
                block8: {
                    String string2 = propertyToken.m_propName;
                    objectArray = false;
                    if (bl) {
                        try {
                            if (propertyToken.m_char == '+' || propertyToken.m_char == '-') {
                                object2 = this.findChangedProperty(string2, tokenContext);
                                if (object2 != null && !((Difference)object2).isSame()) {
                                    objectArray = this.getObjects((Difference)object2, propertyToken.m_char == '+');
                                }
                                break block8;
                            }
                            objectArray = this.getChangedProperty(string2, tokenContext);
                        }
                        catch (MissingPropertyException missingPropertyException) {}
                    } else {
                        objectArray = tokenContext.getPropertyValue(string2);
                    }
                }
                if ((object2 = this.evaluateIf(objectArray)) == null || !((Boolean)object2).booleanValue()) continue;
                return true;
            }
            return false;
        }
        char c = bl ? (char)'^' : '$';
        throw new TokenProcessorException("\"" + c + "*\" can only be used in an if - e.g. [{" + c + "*} NEW [{" + c + "prop} PROP {$prop}]");
    }

    private boolean operatorArgToBoolean(Object object) {
        Boolean bl = this.evaluateIf(object);
        return Boolean.TRUE.equals(bl);
    }

    private String operatorArgToString(Object object) {
        Object object2 = object instanceof Difference ? this.operatorArgToString(((Difference)object).getUpdatedObject()) : (ToStringManager.converterAvailable((Object)object) ? ToStringManager.toString((Object)object) : "" + object);
        return object2;
    }

    private Object processOperator(Operator operator, String string, TokenContext tokenContext, TokenAction tokenAction) {
        String string2 = Operator.toString(operator);
        int n = string.indexOf(string2);
        String string3 = this.stripCurlies(string.substring(0, n).trim());
        String string4 = this.stripCurlies(string.substring(n + string2.length()).trim());
        Object object = this.processToken(string3, tokenContext, tokenAction);
        if (operator == Operator.AND || operator == Operator.OR) {
            if (tokenAction == TokenAction.IF) {
                boolean bl = this.operatorArgToBoolean(object);
                if (bl && operator == Operator.OR) {
                    return true;
                }
                if (!bl && operator == Operator.AND) {
                    return false;
                }
            }
            Object object2 = this.processToken(string4, tokenContext, tokenAction);
            if (tokenAction == TokenAction.FOREACH && operator == Operator.AND && (object instanceof Collection || object instanceof Object[]) && (object2 instanceof Collection || object2 instanceof Object[])) {
                ArrayList arrayList = new ArrayList();
                this.addToCollection(object, arrayList);
                this.addToCollection(object2, arrayList);
                return arrayList;
            }
            return this.operatorArgToBoolean(object2);
        }
        String string5 = this.operatorArgToString(object);
        Object object3 = null;
        String string6 = null;
        try {
            if (this.m_tokenGenerators.get(string4) instanceof DefaultTokenGenerator) {
                throw new GeneratorMissingException(string4);
            }
            object3 = this.processToken(string4, tokenContext, tokenAction);
            string6 = this.operatorArgToString(object3);
        }
        catch (GeneratorMissingException generatorMissingException) {
            string6 = string4;
        }
        if (string6.contains(",")) {
            String[] stringArray = string6.split(",");
            HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            for (String string7 : stringArray) {
                hashSet.add(string7.trim());
            }
            boolean bl = hashSet.contains(string5);
            return operator == Operator.EQ == bl;
        }
        boolean bl = string6.equals("null");
        if (operator == Operator.EQ) {
            if (object == null) {
                return bl;
            }
            return string5.equals(string6);
        }
        if (operator == Operator.NE) {
            if (object == null) {
                return !bl;
            }
            return !string5.equals(string6);
        }
        if (object instanceof Number) {
            int n2 = ((Number)object).intValue();
            Integer n3 = null;
            n3 = object3 instanceof Number ? Integer.valueOf(((Number)object3).intValue()) : Integer.valueOf(string6);
            int n4 = new Integer(n2).compareTo(n3);
            if (operator == Operator.LE) {
                return n4 <= 0;
            }
            if (operator == Operator.GE) {
                return n4 >= 0;
            }
            if (operator == Operator.LT) {
                return n4 < 0;
            }
            if (operator == Operator.GT) {
                return n4 > 0;
            }
        }
        return false;
    }

    private void addToCollection(Object object, Collection collection) {
        if (object instanceof Collection) {
            collection.addAll((Collection)object);
        } else if (object instanceof Object[]) {
            collection.addAll(Arrays.asList((Object[])object));
        }
    }

    private String stripCurlies(String string) {
        if ((string = string.trim()).startsWith("{") && string.endsWith("}")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private Object[] getObjects(Difference difference, boolean bl) {
        Collection<? extends Difference> collection = difference.isList() ? difference.getChildren() : Collections.singleton(difference);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Difference difference2 : collection) {
            if (difference2.isSame()) continue;
            Object object = difference2.getOriginalObject();
            Object object2 = difference2.getUpdatedObject();
            if (bl) {
                if (object != null) continue;
                arrayList.add(object2);
                continue;
            }
            if (object2 != null) continue;
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    private Object getChangedProperty(String string, TokenContext tokenContext) throws MissingPropertyException {
        Difference difference = this.findChangedProperty(string, tokenContext);
        if (difference != null) {
            if (difference.isList()) {
                ArrayList<Difference> arrayList = new ArrayList<Difference>();
                Collection<? extends Difference> collection = difference.getChildren();
                for (Difference difference2 : collection) {
                    if (!difference2.isModified()) continue;
                    arrayList.add(difference2);
                }
                return arrayList;
            }
            return difference;
        }
        return null;
    }

    private Difference findChangedProperty(String string, TokenContext tokenContext) throws MissingPropertyException {
        Difference difference = tokenContext.getDifference();
        if (difference == null) {
            throw new TokenProcessorException("Processing update code requires a Difference");
        }
        return this.m_propHelper.getChildDifference(difference, string);
    }

    private Object processProperty(String string, TokenContext tokenContext, boolean bl, TokenAction tokenAction) {
        String string2 = string.trim();
        Object object = tokenContext.getPropertyValue(string2);
        if (tokenAction == TokenAction.GENERATE) {
            if (object instanceof String && bl) {
                tokenContext.appendName((String)object);
            } else {
                tokenContext.append(object);
            }
        } else {
            return object;
        }
        return null;
    }

    private int skipWhitespace(String string, int n, TokenContext tokenContext) {
        if (tokenContext.length() == 0 || tokenContext.endsWithWhitespace()) {
            while (n < string.length() && ' ' == string.charAt(n)) {
                ++n;
            }
        }
        return n;
    }

    private int ignoreWhitespace(String string, int n, TokenContext tokenContext) {
        if (tokenContext.endsWithWhitespace()) {
            while (n >= 0 && Character.isWhitespace(string.charAt(n))) {
                --n;
            }
        }
        return n;
    }

    private Boolean evaluateIf(Object object) {
        Boolean bl = object == null ? null : (object instanceof Boolean ? (Boolean)object : (object instanceof Difference ? Boolean.valueOf(!((Difference)object).isSame()) : (object instanceof Collection ? Boolean.valueOf(!((Collection)object).isEmpty()) : (object instanceof Object[] ? Boolean.valueOf(((Object[])object).length > 0) : Boolean.TRUE))));
        return bl;
    }

    private Collection<PropertyToken> getPropertyPaths(String string, boolean bl, TokenContext tokenContext) {
        String string2 = null;
        Object object = tokenContext.getObject();
        if (object instanceof DBObject) {
            string2 = ((DBObject)object).getType();
        }
        return this.findProperties(string, bl, string2, tokenContext.getProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<String> getCreatePropertyPaths(String string, String string2, DBObjectProvider dBObjectProvider) {
        Collection<String> collection = null;
        try {
            this.initPropertySearch();
            collection = this.getCreatePropertyPathsImpl(string, string2, dBObjectProvider);
            this.endPropertySearch(string, collection == null ? 0 : collection.size());
        }
        catch (Throwable throwable) {
            this.endPropertySearch(string, collection == null ? 0 : collection.size());
            throw throwable;
        }
        return collection;
    }

    Collection<String> getCreatePropertyPathsImpl(String string, String string2, DBObjectProvider dBObjectProvider) {
        Collection<PropertyToken> collection = this.findProperties(string, false, string2, dBObjectProvider);
        PropertySet propertySet = new PropertySet();
        if (collection != null) {
            for (PropertyToken propertyToken : collection) {
                this.addProperty(propertyToken, propertySet);
            }
        }
        return propertySet;
    }

    private void addProperty(PropertyToken propertyToken, Collection<String> collection) {
        String string = propertyToken.m_propName;
        if (!collection.contains(string)) {
            collection.add(string);
            int n = string.lastIndexOf("/");
            if (n > 0) {
                String string2 = string.substring(0, n);
                this.addProperty(new PropertyToken(propertyToken.m_char, string2), collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<PropertyAction.ChildAction, Collection<String>> getAlterPropertyPaths(String string, String string2, DBObjectProvider dBObjectProvider) {
        Map<PropertyAction.ChildAction, Collection<String>> map = null;
        try {
            this.initPropertySearch();
            map = this.getAlterPropertyPathsImpl(string, string2, dBObjectProvider);
        }
        finally {
            int n = 0;
            if (map != null) {
                for (Collection<String> collection : map.values()) {
                    n += collection.size();
                }
            }
            this.endPropertySearch(string, n);
        }
        return map;
    }

    Map<PropertyAction.ChildAction, Collection<String>> getAlterPropertyPathsImpl(String string, String string2, DBObjectProvider dBObjectProvider) {
        MultiMap multiMap = new MultiMap(PropertySet.class);
        Collection<PropertyToken> collection = this.findProperties(string, true, string2, dBObjectProvider);
        if (collection != null) {
            for (PropertyToken propertyToken : collection) {
                PropertyAction.ChildAction childAction = switch (propertyToken.m_char) {
                    case '^' -> PropertyAction.ChildAction.MODIFY;
                    case '+' -> PropertyAction.ChildAction.ADD;
                    case '-' -> PropertyAction.ChildAction.REMOVE;
                    default -> null;
                };
                if (childAction == null) continue;
                multiMap.add((Object)childAction, (Object)propertyToken.m_propName);
            }
        }
        return multiMap;
    }

    private void initPropertySearch() {
        if (this.m_propSearch != null) {
            throw new IllegalArgumentException("Cannot perform two property searches at once!");
        }
        this.m_propSearch = new ArrayList<String>();
        this.m_propSearchStart = System.currentTimeMillis();
    }

    private void endPropertySearch(String string, int n) {
        long l;
        if (this.m_propSearchStart > 0L && (l = System.currentTimeMillis() - this.m_propSearchStart) > 100L) {
            DBLog.getLogger(this).log(Level.FINEST, "DDL property search took {0}ms. Found {1} properties in:\n{2}\n\n", new Object[]{l, n, string});
        }
        this.m_propSearch = null;
    }

    Collection<PropertyToken> findProperties(String string, boolean bl, String string2, DBObjectProvider dBObjectProvider) {
        HashSet<PropertyToken> hashSet = new HashSet<PropertyToken>();
        this.findProperties(string, hashSet, bl, string2, dBObjectProvider);
        return hashSet;
    }

    private void findProperties(String string, Collection<PropertyToken> collection, boolean bl, String string2, DBObjectProvider dBObjectProvider) {
        for (int i = 0; i < string.length(); ++i) {
            Object object;
            Object object2;
            int n;
            String string3;
            char c = string.charAt(i);
            if (c == '[' && (string3 = string.substring(i + 1, n = TokenProcessor.findMatching('[', ']', string, i + 1))).endsWith("...")) {
                object2 = new ArrayList<PropertyToken>();
                this.findProperties(string3, (Collection<PropertyToken>)object2, bl, string2, dBObjectProvider);
                if (object2.size() > 0) {
                    object = (PropertyToken)object2.get(0);
                    collection.add((PropertyToken)object);
                    for (int j = 1; j < object2.size(); ++j) {
                        collection.add((PropertyToken)object2.get(j));
                    }
                    if (string3.contains("{each}")) {
                        this.findSubProperties(collection, string2, bl, null, dBObjectProvider, ((PropertyToken)object).m_propName);
                    }
                }
                i = n;
                continue;
            }
            if (c != '{') continue;
            n = TokenProcessor.findMatching('{', '}', string, i + 1);
            string3 = string.substring(i + 1, n);
            if (string3.startsWith(EACHDOT)) {
                Object object3;
                object2 = string3.substring(5);
                if (collection.size() < 1) {
                    if (bl) {
                        return;
                    }
                    throw new TokenProcessorException("Cannot use " + string3 + " as the loop property.");
                }
                object = string2;
                PropertyToken propertyToken = collection.iterator().next();
                String string4 = propertyToken.m_propName;
                Class clazz = this.getPropertySingleClass(string2, string4);
                if (clazz != null && DBObject.class.isAssignableFrom(clazz) && (object3 = Metadata.getType(clazz)) != null) {
                    object = object3;
                }
                object3 = new HashSet();
                this.findPropertiesInToken((String)object2, (Collection<PropertyToken>)object3, bl, (String)object, dBObjectProvider);
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    PropertyToken propertyToken2 = (PropertyToken)iterator.next();
                    collection.add(propertyToken2.prependBasePath(string4));
                }
            } else {
                this.findPropertiesInToken(string3, collection, bl, string2, dBObjectProvider);
            }
            i = n;
        }
    }

    private void findSubProperties(Collection<PropertyToken> collection, String string, boolean bl, String string2, DBObjectProvider dBObjectProvider, String string3) {
        Class clazz = this.getPropertySingleClass(string, string3);
        if (clazz != null && DBObject.class.isAssignableFrom(clazz)) {
            Collection<Object> collection2;
            if (clazz.equals(Constraint.class)) {
                collection2 = new ArrayList();
                for (String string4 : Constraint.getConstraintTypes()) {
                    collection2.add("CONSTRAINT." + string4);
                }
            } else {
                collection2 = Collections.singleton(Metadata.getType(clazz));
            }
            for (String string4 : collection2) {
                TokenGenerator tokenGenerator = this.m_tokenGenerators.get(string4);
                if (tokenGenerator == null) continue;
                Collection<PropertyToken> collection3 = this.getGeneratorProperties(tokenGenerator, string4, bl, string2, dBObjectProvider);
                for (PropertyToken propertyToken : collection3) {
                    collection.add(propertyToken.prependBasePath(string3));
                }
            }
        }
    }

    private Class getPropertySingleClass(String string, String string2) {
        Class<?> clazz = null;
        PropertyInfo propertyInfo = PropertyHelper.findPropertyInfo(string, string2, null);
        if (propertyInfo != null && (clazz = propertyInfo.getPropertyClass()) != null && clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    private boolean isProperty(String string, boolean bl) {
        char[] cArray;
        if (bl) {
            char[] cArray2 = new char[3];
            cArray2[0] = 94;
            cArray2[1] = 43;
            cArray = cArray2;
            cArray2[2] = 45;
        } else {
            char[] cArray3 = new char[1];
            cArray = cArray3;
            cArray3[0] = 36;
        }
        char[] cArray4 = cArray;
        boolean bl2 = false;
        char c = string.charAt(0);
        for (int i = 0; i < cArray4.length; ++i) {
            if (c != cArray4[i]) continue;
            bl2 = true;
        }
        return bl2;
    }

    private void findPropertiesInToken(String string, Collection<PropertyToken> collection, boolean bl, String string2, DBObjectProvider dBObjectProvider) {
        Operator operator;
        int n = string.length();
        if (n > 1 && string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        if ((operator = Operator.findOperator(string)) != null) {
            String[] stringArray;
            for (String string3 : stringArray = string.split(Pattern.quote(Operator.toString(operator)))) {
                String string4 = string3.trim();
                if (!this.isProperty(string4, bl)) continue;
                this.findPropertiesInToken(string4, collection, bl, string2, dBObjectProvider);
            }
        } else if (string.equals(THIS)) {
            TokenGenerator tokenGenerator = this.m_tokenGenerators.get(string2);
            if (tokenGenerator == null) {
                collection.add(new PropertyToken('$', "name"));
            } else {
                collection.addAll(this.getGeneratorProperties(tokenGenerator, string2, bl, null, dBObjectProvider));
            }
        } else {
            if (string.startsWith(THISDOT) || string.startsWith(EACHDOT)) {
                string = string.substring(5);
            }
            int n2 = string.indexOf(DOT);
            char c = string.charAt(0);
            String string5 = n2 < 0 ? null : string.substring(n2 + 1);
            TokenGenerator tokenGenerator = this.m_tokenGenerators.get(string5);
            if (tokenGenerator != null && this.isProperty(string, false)) {
                String string6 = string.substring(1, n2);
                if (!bl) {
                    collection.add(new PropertyToken(c, string6));
                }
                Collection<PropertyToken> collection2 = this.getGeneratorProperties(tokenGenerator, string2, bl, string5, dBObjectProvider);
                for (PropertyToken propertyToken : collection2) {
                    collection.add(propertyToken.prependBasePath(string6));
                }
            } else if (this.isProperty(string, bl)) {
                String string7 = string.substring(1);
                if (!string7.trim().equals(ASTERISK)) {
                    collection.add(new PropertyToken(c, string7));
                    this.findSubProperties(collection, string2, bl, string, dBObjectProvider, string7);
                }
            } else {
                TokenGenerator tokenGenerator2 = this.m_tokenGenerators.get(string);
                if (tokenGenerator2 != null) {
                    collection.addAll(this.getGeneratorProperties(tokenGenerator2, string2, bl, string, dBObjectProvider));
                }
            }
        }
    }

    private Collection<PropertyToken> getGeneratorProperties(TokenGenerator tokenGenerator, String string, boolean bl, String string2, DBObjectProvider dBObjectProvider) {
        HashSet<PropertyToken> hashSet;
        ArrayList<String> arrayList = null;
        String string3 = tokenGenerator.getTokenName();
        String string4 = string3 + ":" + string2;
        boolean bl2 = ModelUtil.areEqual((Object)string3, (Object)string);
        if (this.m_propSearch != null) {
            arrayList = new ArrayList<String>(this.m_propSearch);
            if (bl2) {
                this.m_propSearch.add(string4);
            }
        }
        if (arrayList != null && bl2 && this.isOverTheLimit(arrayList, string4)) {
            hashSet = Collections.emptyList();
        } else {
            hashSet = new HashSet();
            if (bl) {
                Map<PropertyAction.ChildAction, Collection<String>> map = tokenGenerator.getAlterPropertiesProcessed(string, dBObjectProvider);
                for (Map.Entry<PropertyAction.ChildAction, Collection<String>> entry : map.entrySet()) {
                    Collection<String> collection = entry.getValue();
                    if (collection == null) continue;
                    char c = TokenProcessor.getCharacter(entry.getKey());
                    Collection<String> collection2 = entry.getValue();
                    if (collection2 == null) continue;
                    for (String string5 : collection2) {
                        hashSet.add(new PropertyToken(c, string5));
                    }
                }
            } else {
                for (String string6 : tokenGenerator.getPropertiesProcessed(string, dBObjectProvider)) {
                    hashSet.add(new PropertyToken('$', string6));
                }
            }
        }
        if (arrayList != null) {
            this.m_propSearch = arrayList;
        }
        return hashSet;
    }

    private boolean isOverTheLimit(Collection<String> collection, String string) {
        int n = 0;
        for (String string2 : collection) {
            if (!string2.equals(string)) continue;
            ++n;
        }
        return n >= 2;
    }

    private static char getCharacter(PropertyAction.ChildAction childAction) {
        int n = 36;
        if (childAction == PropertyAction.ChildAction.ADD) {
            n = 43;
        } else if (childAction == PropertyAction.ChildAction.REMOVE) {
            n = 45;
        } else if (childAction == PropertyAction.ChildAction.MODIFY) {
            n = 94;
        }
        return (char)n;
    }

    static class TokenProcessorException
    extends IllegalStateException {
        public TokenProcessorException(String string) {
            super(string);
        }

        public TokenProcessorException(String string, String string2, int n) {
            super(string + " at index " + n);
        }

        public TokenProcessorException(char c, char c2, String string, int n) {
            super("Missing " + c2 + " to match opening " + c + " at index " + n);
        }
    }

    private static enum TokenAction {
        IF,
        FOREACH,
        GENERATE;

    }

    static enum Operator {
        OR,
        AND,
        EQ,
        NE,
        LE,
        GE,
        LT,
        GT;

        private static String[] strings;

        public static Operator findOperator(String object) {
            int n;
            int n2 = ((String)object).indexOf(123);
            while (n2 >= 0 && (n = TokenProcessor.findMatching('{', '}', (String)object, n2 + 1)) >= 0) {
                object = ((String)object).substring(0, n2) + ((String)object).substring(n + 1);
                n2 = ((String)object).indexOf(123);
            }
            for (n = 0; n < strings.length; ++n) {
                if (!((String)object).contains(strings[n])) continue;
                return Operator.values()[n];
            }
            return null;
        }

        public static String toString(Operator operator) {
            Operator[] operatorArray = Operator.values();
            for (int i = 0; i < operatorArray.length; ++i) {
                if (operatorArray[i] != operator) continue;
                return strings[i];
            }
            return null;
        }

        static {
            strings = new String[]{"||", "&&", "==", "!=", "<=", ">=", "<", ">"};
        }
    }

    private class PropertyToken {
        public static final char PROP = '$';
        public static final char MOD = '^';
        public static final char ADD = '+';
        public static final char DEL = '-';
        private final char m_char;
        private final String m_propName;

        PropertyToken(char c, String string) {
            this.m_char = c;
            this.m_propName = string;
            if (string == null) {
                throw new IllegalArgumentException("propName cannot be null");
            }
        }

        public boolean equals(Object object) {
            return object instanceof PropertyToken && ((PropertyToken)object).m_char == this.m_char && this.m_propName.equals(((PropertyToken)object).m_propName);
        }

        public int hashCode() {
            return this.m_propName.hashCode();
        }

        public PropertyToken prependBasePath(String string) {
            return new PropertyToken(this.m_char, Property.createPath(string, this.m_propName));
        }
    }

    static class GeneratorMissingException
    extends TokenProcessorException {
        public GeneratorMissingException(String string) {
            super("No generator found for token " + string);
        }
    }
}

