/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.util.ModelUtil;

public final class DDL<T extends DDLType> {
    private Map<T, Collection<String>> m_ddls = new TreeMap<T, Collection<String>>();
    private Collection<DDL<T>> m_following;
    private DBObject m_obj;
    private boolean m_hasPrompts;

    public DDL() {
    }

    public DDL(DBObject dBObject) {
        this.m_obj = dBObject;
    }

    public void append(T t, String string) {
        Collection<String> collection = this.m_ddls.get(t);
        if (collection == null) {
            collection = new ArrayList<String>();
            this.m_ddls.put(t, collection);
        }
        collection.add(string);
    }

    public void appendAll(T t, Collection<String> collection) {
        if (collection != null && collection.size() > 0) {
            Collection<String> collection2 = this.m_ddls.get(t);
            if (collection2 == null) {
                collection2 = new ArrayList<String>();
                this.m_ddls.put(t, collection2);
            }
            collection2.addAll(collection);
        }
    }

    public void append(DDL<T> dDL) {
        if (dDL != null) {
            if (this.m_following == null) {
                this.m_following = new ArrayList<DDL<T>>();
            }
            this.m_following.add(dDL);
        }
    }

    public Collection<String> get(T t) {
        Collection<String> collection = this.m_ddls.get(t);
        if (this.m_following != null) {
            for (DDL<T> dDL : this.m_following) {
                Collection<String> collection2 = dDL.get(t);
                if (collection2 == null || collection2.size() <= 0) continue;
                if (collection == null || collection.size() == 0) {
                    collection = collection2;
                    continue;
                }
                collection.addAll(collection2);
            }
        }
        return collection == null ? Collections.emptyList() : new ArrayList<String>(collection);
    }

    public void remove(T t) {
        this.m_ddls.remove(t);
        if (this.m_following != null) {
            for (DDL<T> dDL : this.m_following) {
                dDL.remove(t);
            }
        }
    }

    public int size() {
        int n = 0;
        for (Collection<String> object : this.m_ddls.values()) {
            n += object.size();
        }
        if (this.m_following != null) {
            for (DDL dDL : this.m_following) {
                n += dDL.size();
            }
        }
        return n;
    }

    public Collection<String> getStatements() {
        return this.getStatements(false);
    }

    private Collection<String> getStatements(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<T, Collection<StatementWithObject>> map = this.getStatementsForExecution();
        for (Map.Entry<T, Collection<StatementWithObject>> entry : map.entrySet()) {
            DDLType dDLType = (DDLType)entry.getKey();
            for (StatementWithObject statementWithObject : entry.getValue()) {
                String string = statementWithObject.getStatement();
                if (!ModelUtil.hasLength((String)string)) continue;
                if (bl) {
                    arrayList.add(this.appendTerminator(string, dDLType));
                    continue;
                }
                arrayList.add(this.stripTerminator(string, dDLType));
            }
        }
        return arrayList;
    }

    private String appendTerminator(String string, T t) {
        boolean bl = false;
        String string2 = ((DDLType)t).getTerminator();
        if (ModelUtil.hasLength((String)string2)) {
            String string3 = string2.trim();
            if (ModelUtil.hasLength((String)string3) && !string.trim().endsWith(string3)) {
                bl = true;
            } else if (!string.endsWith(string2)) {
                bl = true;
            }
        }
        return bl ? string + string2 : string;
    }

    private String stripTerminator(String string, T t) {
        String string2 = ((DDLType)t).getTerminator();
        String string3 = string2 = string2 == null ? "" : string2.trim();
        if (ModelUtil.hasLength((String)string2) && string.trim().endsWith(string2)) {
            string = string.substring(0, string.lastIndexOf(string2));
        }
        return string;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = this.getStatements(bl).iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public DDL<T> copyWithPrompts() {
        if (this.m_hasPrompts) {
            return this;
        }
        DDL<T> dDL = new DDL<T>();
        dDL.m_hasPrompts = true;
        Map<T, Collection<StatementWithObject>> map = this.getStatementsForExecution();
        for (DDLType dDLType : map.keySet()) {
            Collection<StatementWithObject> collection = map.get(dDLType);
            for (StatementWithObject statementWithObject : collection) {
                String string;
                DBObject dBObject = statementWithObject.getObject();
                Object object = dDLType.createPrompt(dBObject, string = statementWithObject.getStatement());
                if (ModelUtil.hasLength((String)object) && !((String)object).endsWith("\n")) {
                    object = (String)object + "\n";
                }
                DDL<DDLType> dDL2 = new DDL<DDLType>(dBObject);
                if (ModelUtil.hasLength((String)object)) {
                    dDL2.append(dDLType, (String)object + string);
                } else {
                    dDL2.append(dDLType, string);
                }
                dDL.append(dDL2);
            }
        }
        return dDL;
    }

    Ddl convertToLegacy() {
        Ddl ddl = new Ddl();
        this.convertAllInto(ddl);
        return ddl;
    }

    private void convertAllInto(Ddl ddl) {
        for (Map.Entry<T, Collection<String>> object : this.m_ddls.entrySet()) {
            Ddl ddl2 = new Ddl();
            ddl2.put(((DDLType)object.getKey()).toString(), object.getValue());
            ddl.append(ddl2);
        }
        if (this.m_following != null) {
            for (DDL dDL : this.m_following) {
                dDL.convertAllInto(ddl);
            }
        }
    }

    Ddl[] convertToLegacyArray() {
        Ddl[] ddlArray = new Ddl[]{new Ddl()};
        this.convertAllInto(ddlArray[0]);
        return ddlArray;
    }

    Map<T, Collection<StatementWithObject>> getStatementsForExecution() {
        TreeMap treeMap = new TreeMap();
        this.putAll(treeMap, this.getStatementsForExecutionImpl());
        for (Map.Entry entry : treeMap.entrySet()) {
            Boolean bl = ((DDLType)entry.getKey()).getDependencySortPreference();
            if (bl == null) continue;
            this.topSort((Collection)entry.getValue(), bl);
        }
        return treeMap;
    }

    private void putAll(Map<T, Collection<StatementWithObject>> map, Map<T, Collection<StatementWithObject>> map2) {
        for (DDLType dDLType : map2.keySet()) {
            Collection<StatementWithObject> collection = map2.get(dDLType);
            if (collection == null) continue;
            Collection<StatementWithObject> collection2 = map.get(dDLType);
            if (collection2 == null) {
                map.put(dDLType, collection);
                collection2 = collection;
            } else {
                collection2.addAll(collection);
            }
            if (!dDLType.ensureUnique() || collection2.size() <= 1) continue;
            StatementWithObject statementWithObject = collection2.iterator().next();
            collection2.clear();
            collection2.add(statementWithObject);
        }
    }

    private Map<T, Collection<StatementWithObject>> getStatementsForExecutionImpl() {
        TreeMap treeMap = new TreeMap();
        for (DDLType object : this.m_ddls.keySet()) {
            Collection<String> collection = this.m_ddls.get(object);
            if (collection == null || collection.size() <= 0) continue;
            ArrayList<StatementWithObject> arrayList = new ArrayList<StatementWithObject>();
            treeMap.put(object, arrayList);
            for (String string : collection) {
                arrayList.add(new StatementWithObject(this.stripTerminator(string, object), this.m_obj));
            }
        }
        if (this.m_following != null) {
            for (DDL dDL : this.m_following) {
                this.putAll(treeMap, dDL.getStatementsForExecutionImpl());
            }
        }
        return treeMap;
    }

    private void topSort(Collection<StatementWithObject> collection, boolean bl) {
        boolean bl2 = false;
        DBUtil.IDQueryCriteria iDQueryCriteria = new DBUtil.IDQueryCriteria(DBUtil.IDQuery.EXTERNAL);
        iDQueryCriteria.setRecurse(true);
        iDQueryCriteria.setExistingOnly(true);
        iDQueryCriteria.setTopLevelOnly(true);
        for (StatementWithObject statementWithObject : collection) {
            if (statementWithObject.m_obj == null) continue;
            for (DBObjectID iterator : DBUtil.getReferenceIDs(statementWithObject.m_obj, iDQueryCriteria)) {
                for (StatementWithObject statementWithObject2 : collection) {
                    if (statementWithObject2 == statementWithObject || statementWithObject2.m_obj == null || !iterator.equals(statementWithObject2.m_obj.getID(), true)) continue;
                    if (statementWithObject.m_to == null) {
                        statementWithObject.m_to = new ArrayList<StatementWithObject>();
                    }
                    statementWithObject.m_to.add(statementWithObject2);
                    if (statementWithObject2.m_from == null) {
                        statementWithObject2.m_from = new ArrayList<StatementWithObject>();
                    }
                    statementWithObject2.m_from.add(statementWithObject);
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            ArrayList arrayList = new ArrayList();
            boolean bl3 = true;
            ArrayList arrayList2 = new ArrayList();
            for (StatementWithObject statementWithObject : collection) {
                if (statementWithObject.m_to != null) continue;
                arrayList2.add(statementWithObject);
            }
            while (!arrayList2.isEmpty()) {
                StatementWithObject statementWithObject = (StatementWithObject)arrayList2.remove(0);
                if (bl) {
                    arrayList.add(statementWithObject);
                } else {
                    arrayList.add(0, statementWithObject);
                }
                if (statementWithObject.m_from == null) continue;
                for (StatementWithObject statementWithObject2 : statementWithObject.m_from) {
                    if (statementWithObject2.m_to != null) {
                        Iterator<StatementWithObject> iterator = statementWithObject2.m_to.iterator();
                        while (iterator.hasNext()) {
                            if (statementWithObject != iterator.next()) continue;
                            iterator.remove();
                            break;
                        }
                    }
                    if (!statementWithObject2.m_to.isEmpty()) continue;
                    arrayList2.add(statementWithObject2);
                }
            }
            if (bl3) {
                for (StatementWithObject statementWithObject : collection) {
                    if (statementWithObject.m_to == null || statementWithObject.m_to.isEmpty()) continue;
                    bl3 = false;
                    break;
                }
            }
            if (bl3) {
                collection.clear();
                collection.addAll(arrayList);
            }
        }
    }

    class StatementWithObject {
        private String m_stmt;
        private DBObject m_obj;
        private Collection<StatementWithObject> m_to;
        private Collection<StatementWithObject> m_from;

        private StatementWithObject(String string, DBObject dBObject) {
            this.m_stmt = string;
            this.m_obj = dBObject;
        }

        public DBObject getObject() {
            return this.m_obj;
        }

        public String getStatement() {
            return this.m_stmt;
        }
    }
}

