/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.AbstractPropertyManager;
import oracle.javatools.db.property.PropertyAction;

abstract class AbstractDDLGenerator<T extends DDLType>
extends AbstractPropertyManager
implements DDLGenerator<T> {
    private Class<? extends Database> m_databaseClass;

    protected AbstractDDLGenerator(Class<? extends Database> clazz, DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
        if (clazz == null) {
            throw new IllegalArgumentException("Database class cannot be null");
        }
        this.m_databaseClass = clazz;
    }

    @Override
    protected Class<? extends DBObjectProvider> getProviderClass() {
        return this.m_databaseClass;
    }

    @Override
    public boolean supportsAction(String string, PropertyAction.Type type) {
        return false;
    }

    @Override
    protected boolean canCreate(Class<? extends SystemObject> clazz, String string) {
        return false;
    }

    @Override
    public final DDL<T> getCreateDDL(DDLOptions dDLOptions, DBObject ... dBObjectArray) {
        DDL<T> dDL = null;
        if (dBObjectArray != null) {
            dDL = this.getCreateDDLImpl(dDLOptions, DBUtil.stripNulls(dBObjectArray));
        }
        return this.finish(dDLOptions, dDL);
    }

    protected abstract DDL<T> getCreateDDLImpl(DDLOptions var1, DBObject ... var2);

    @Override
    public final DDL<T> getDeleteDDL(DDLOptions dDLOptions, DBObject ... dBObjectArray) {
        DDL<T> dDL = null;
        if (dBObjectArray != null) {
            dDL = this.getDeleteDDLImpl(dDLOptions, DBUtil.stripNulls(dBObjectArray));
        }
        return this.finish(dDLOptions, dDL);
    }

    protected abstract DDL<T> getDeleteDDLImpl(DDLOptions var1, DBObject ... var2);

    @Override
    public final DDL<T> getUpdateDDL(DDLOptions dDLOptions, Difference difference) {
        DDL dDL = null;
        if ((difference.isMap() || difference.isLeaf()) && SystemObject.class.isAssignableFrom(difference.getDifferenceClass())) {
            dDL = this.processResultSet(dDLOptions, difference);
        } else if (difference.isList()) {
            for (Difference difference2 : difference.getChildren()) {
                dDL = this.append(dDL, this.processResultSet(dDLOptions, difference2));
            }
        } else {
            DBLog.getLogger(this).warning("unexpected Difference type for DDL");
        }
        return this.finish(dDLOptions, dDL);
    }

    private DDL<T> processResultSet(DDLOptions dDLOptions, Difference difference) {
        DDL<T> dDL = null;
        if (!difference.isSame()) {
            SystemObject systemObject = (SystemObject)difference.getUpdatedObject();
            SystemObject systemObject2 = (SystemObject)difference.getOriginalObject();
            if (systemObject == null) {
                dDL = this.getDeleteDDLImpl(dDLOptions, systemObject2);
            } else if (systemObject2 == null) {
                dDL = this.getCreateDDLImpl(dDLOptions, systemObject);
            } else {
                dDL = this.getUpdateDDLImpl(DDLOptions.copyForUpdate(dDLOptions, difference), difference);
                if (dDL == null || dDL.size() == 0) {
                    throw UnsupportedDDLException.updateNotSupported(systemObject);
                }
            }
        }
        return dDL;
    }

    protected abstract DDL<T> getUpdateDDLImpl(DDLOptions var1, Difference var2);

    protected DDL<T> finish(DDLOptions dDLOptions, DDL<T> dDL) {
        if (dDL != null && dDLOptions.isIncludePrompts()) {
            return dDL.copyWithPrompts();
        }
        return dDL == null ? new DDL() : dDL;
    }

    protected DDL append(DDL dDL, DDL dDL2) {
        if (dDL == null) {
            return dDL2;
        }
        if (dDL2 != null) {
            dDL.append(dDL2);
        }
        return dDL;
    }

    @Deprecated
    public final Ddl getCreateDDL(SchemaObject schemaObject, boolean bl, boolean bl2) {
        return this.getCreateDDL(new DDLOptions(bl, bl2), schemaObject).convertToLegacy();
    }

    @Deprecated
    public final Ddl getCreateDDL(SchemaObject[] schemaObjectArray, boolean bl, boolean bl2) {
        return this.getCreateDDL(new DDLOptions(bl, bl2), schemaObjectArray).convertToLegacy();
    }

    @Deprecated
    public final Ddl getDeleteDDL(SchemaObject schemaObject, boolean bl) {
        return this.getDeleteDDL(new DDLOptions(true, bl), schemaObject).convertToLegacy();
    }

    @Deprecated
    public final Ddl getDeleteDDL(SchemaObject[] schemaObjectArray, boolean bl) {
        return this.getDeleteDDL(new DDLOptions(true, bl), schemaObjectArray).convertToLegacy();
    }

    @Deprecated
    public final Ddl[] getUpdateDDL(SchemaObject schemaObject, SchemaObject schemaObject2) {
        return this.getUpdateDDL(new SchemaObject[]{schemaObject}, new SchemaObject[]{schemaObject2});
    }

    @Deprecated
    public final Ddl[] getUpdateDDL(SchemaObject[] schemaObjectArray, SchemaObject[] schemaObjectArray2) {
        Difference difference = this.getProvider().getDiffEngine().difference(schemaObjectArray, schemaObjectArray2);
        return this.getUpdateDDL(difference, false, false);
    }

    @Deprecated
    public final Ddl[] getUpdateDDL(Difference difference, boolean bl, boolean bl2) {
        return this.getUpdateDDL(new DDLOptions(bl, bl2), difference).convertToLegacyArray();
    }

    @Deprecated
    public final Ddl getCreateDDL(Schema schema) {
        return this.getCreateDDL(new DDLOptions(), schema).convertToLegacy();
    }

    @Deprecated
    public final Ddl getDeleteDDL(Schema schema, boolean bl) {
        return this.getDeleteDDL(new DDLOptions(false, bl), schema).convertToLegacy();
    }
}

