/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.refactoring.CascadeAction;

public class FKConstraint
extends ColumnConstraint {
    public static final String CONSTRAINT_TYPE = "FKConstraint";
    @Deprecated
    public static final int ON_DELETE_RESTRICT = 0;
    @Deprecated
    public static final int ON_DELETE_CASCADE = 1;
    @Deprecated
    public static final int ON_DELETE_SET_NULL = 2;

    public FKConstraint() {
        this((String)null, (Relation)null);
    }

    public FKConstraint(String string, Relation relation) {
        super(string, relation);
    }

    public void setReferenceID(DBObjectID dBObjectID) {
        this.setProperty("referenceID", dBObjectID);
    }

    @References(value=UniqueConstraint.class, cascade=CascadeAction.DELETE)
    public DBObjectID getReferenceID() {
        return (DBObjectID)this.getProperty("referenceID");
    }

    @Override
    public String getConstraintType() {
        return CONSTRAINT_TYPE;
    }

    public ReferentialAction getOnDeleteAction() {
        return (ReferentialAction)((Object)this.getProperty("onDeleteAction"));
    }

    public void setOnDeleteAction(ReferentialAction referentialAction) {
        this.setProperty("onDeleteAction", (Object)referentialAction);
    }

    @Deprecated
    public int getDeleteMode() {
        int n = 0;
        ReferentialAction referentialAction = this.getOnDeleteAction();
        if (referentialAction != null) {
            switch (referentialAction) {
                case CASCADE: {
                    n = 1;
                    break;
                }
                case SET_NULL: {
                    n = 2;
                }
            }
        }
        return n;
    }

    @Deprecated
    @Transient
    public void setDeleteMode(int n) {
        this.setOnDeleteAction(switch (n) {
            case 1 -> ReferentialAction.CASCADE;
            case 2 -> ReferentialAction.SET_NULL;
            default -> ReferentialAction.RESTRICT;
        });
    }

    public static enum ReferentialAction {
        CASCADE,
        RESTRICT,
        SET_NULL,
        NO_ACTION,
        SET_DEFAULT;


        public String toString() {
            return super.toString().replaceAll("_", " ");
        }
    }
}

