/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Scrollable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;
import oracle.bali.xml.gui.base.inspector.editors.AbstractSimplePropretyEditor;
import oracle.bali.xml.gui.base.xmlComponent.AbstractXmlPropertyEditorDecorator;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTextComponentKeyAdapter;

public class XmlTextAreaEditor
extends AbstractXmlPropertyEditorDecorator<String> {
    private TextAreaPanel _textAreaPanel;
    private int _numRows = 5;

    public XmlTextAreaEditor() {
        super((PropertyEditor)new AbstractSimplePropretyEditor<String>(String.class){

            protected String getValueForString(String string) {
                return string;
            }

            protected String getStringForValue(String value) {
                return value;
            }
        });
    }

    public Component getXmlComponent() {
        if (this._textAreaPanel == null) {
            this._textAreaPanel = new TextAreaPanel();
        }
        this.updateXmlComponentFromPropertyValue();
        return this._textAreaPanel;
    }

    public void updateXmlComponentFromPropertyValue() {
        this.getTextArea().setText(this.getAsText());
    }

    public void updatePropertyValueFromXmlComponent() {
        String value;
        Document document = this.getTextArea().getDocument();
        try {
            value = document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
        this.setValue(value);
    }

    public void addChildFocusListener(FocusListener focusListener) {
        this.getTextArea().addFocusListener(focusListener);
    }

    public void removeChildFocusListener(FocusListener focusListener) {
        this.getTextArea().removeFocusListener(focusListener);
    }

    public JTextArea getTextArea() {
        return this._textAreaPanel.getTextArea();
    }

    public XmlTextAreaEditor setEnabled(boolean enabled) {
        this.getTextArea().setEnabled(enabled);
        this._textAreaPanel.setEnabled(enabled);
        return this;
    }

    public XmlTextAreaEditor setNumRows(int numRows) {
        this._numRows = numRows;
        return this;
    }

    public class TextAreaPanel
    extends JPanel
    implements Scrollable {
        private JTextArea _jTextArea;
        private JScrollPane _textAreaScrollPane;

        public TextAreaPanel() {
            super((LayoutManager)new MigLayout("insets 0 0 0 0 wrap", "[grow,fill]", "[]"));
            this._jTextArea = new JTextArea();
            this._jTextArea.setRows(XmlTextAreaEditor.this._numRows);
            this._jTextArea.setWrapStyleWord(true);
            this._jTextArea.setLineWrap(true);
            this._jTextArea.addKeyListener(new XmlTextComponentKeyAdapter(this._jTextArea, XmlTextAreaEditor.this.getXmlComponentWrapper()));
            this._textAreaScrollPane = new JScrollPane(this._jTextArea);
            this.add((Component)this._textAreaScrollPane, "width 10:50");
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int oriention, int direction) {
            return 100;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        public JTextArea getTextArea() {
            return this._jTextArea;
        }

        @Override
        public void setToolTipText(String text) {
            this._jTextArea.setToolTipText(text);
        }
    }
}

