/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.dnd;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.Timer;
import oracle.bali.share.util.IntegerUtils;

public abstract class AutoscrollingDragListener
implements DropTargetListener {
    private Timer _timer;
    private Point _lastPosition;
    private Rectangle _outerRect = new Rectangle();
    private Rectangle _innerRect = new Rectangle();
    private int _hysteresis = 10;
    private JComponent _component;

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        this._init(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dragOver(DropTargetDragEvent e) {
        this._init(e);
        Point p = e.getLocation();
        this.updateInsertionLocation(this._component, p);
        AutoscrollingDragListener autoscrollingDragListener = this;
        synchronized (autoscrollingDragListener) {
            if (Math.abs(p.x - this._lastPosition.x) > this._hysteresis || Math.abs(p.y - this._lastPosition.y) > this._hysteresis) {
                if (this._timer.isRunning()) {
                    this._timer.stop();
                }
            } else if (!this._timer.isRunning()) {
                this._timer.start();
            }
        }
        this._lastPosition = p;
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.restoreComponentState(this._component);
        this._cleanup();
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        this._component = AutoscrollingDragListener.getJComponent(e);
        this.restoreComponentStateForDrop(this._component);
        this._cleanup();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    protected void saveComponentState(JComponent c) {
    }

    protected void restoreComponentState(JComponent c) {
    }

    protected void restoreComponentStateForDrop(JComponent c) {
    }

    protected void updateInsertionLocation(JComponent c, Point p) {
    }

    protected final JComponent getDropComponent() {
        return this._component;
    }

    protected static JComponent getJComponent(DropTargetEvent e) {
        return (JComponent)e.getDropTargetContext().getComponent();
    }

    protected static Point getLocation(DropTargetEvent e) {
        if (e instanceof DropTargetDragEvent) {
            return ((DropTargetDragEvent)e).getLocation();
        }
        if (e instanceof DropTargetDropEvent) {
            return ((DropTargetDropEvent)e).getLocation();
        }
        return null;
    }

    private void _init(DropTargetDragEvent e) {
        if (this._component == null) {
            this._component = AutoscrollingDragListener.getJComponent(e);
            this.saveComponentState(this._component);
            this._lastPosition = e.getLocation();
            this._updateAutoscrollRegion(this._component);
            this._initPropertiesIfNecessary();
        }
    }

    private void _updateAutoscrollRegion(JComponent c) {
        Rectangle visibleRect;
        this._outerRect = visibleRect = c.getVisibleRect();
        int leftInset = 0;
        int topInset = 0;
        int rightInset = 0;
        int bottomInset = 0;
        if (c instanceof Scrollable) {
            Scrollable s = (Scrollable)((Object)c);
            rightInset = s.getScrollableUnitIncrement(visibleRect, 0, 1);
            bottomInset = s.getScrollableUnitIncrement(visibleRect, 1, 1);
            leftInset = s.getScrollableUnitIncrement(visibleRect, 0, -1);
            topInset = s.getScrollableUnitIncrement(visibleRect, 1, -1);
        }
        this._innerRect.setBounds(visibleRect.x + leftInset, visibleRect.y + topInset, visibleRect.width - (leftInset + rightInset), visibleRect.height - (topInset + bottomInset));
    }

    private void _autoscroll(JComponent c, Point pos) {
        if (c instanceof Scrollable) {
            Scrollable s = (Scrollable)((Object)c);
            Rectangle scrollRect = null;
            if (pos.y < this._innerRect.y) {
                dy = s.getScrollableUnitIncrement(this._outerRect, 1, -1);
                scrollRect = new Rectangle(this._innerRect.x, this._outerRect.y - dy, this._innerRect.width, dy);
            } else if (pos.y > this._innerRect.y + this._innerRect.height) {
                dy = s.getScrollableUnitIncrement(this._outerRect, 1, 1);
                scrollRect = new Rectangle(this._innerRect.x, this._outerRect.y + this._outerRect.height, this._innerRect.width, dy);
            }
            if (scrollRect != null) {
                c.scrollRectToVisible(scrollRect);
            }
            if (pos.x < this._innerRect.x) {
                dx = s.getScrollableUnitIncrement(this._outerRect, 0, 1);
                scrollRect = new Rectangle(this._outerRect.x - dx, this._innerRect.y, dx, this._innerRect.height);
            } else if (pos.x > this._innerRect.x + this._innerRect.width) {
                dx = s.getScrollableUnitIncrement(this._outerRect, 0, -1);
                scrollRect = new Rectangle(this._outerRect.x + this._outerRect.width, this._innerRect.y, dx, this._innerRect.height);
            }
            if (scrollRect != null) {
                c.scrollRectToVisible(scrollRect);
            }
        }
    }

    private void _initPropertiesIfNecessary() {
        if (this._timer == null) {
            Integer initial;
            Toolkit t = Toolkit.getDefaultToolkit();
            Integer interval = initial = IntegerUtils.getInteger((int)100);
            try {
                initial = (Integer)t.getDesktopProperty("DnD.Autoscroll.initialDelay");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                interval = (Integer)t.getDesktopProperty("DnD.Autoscroll.interval");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._timer = new Timer(interval, new DragScroller());
            this._timer.setCoalesce(true);
            this._timer.setInitialDelay(initial);
            try {
                this._hysteresis = (Integer)t.getDesktopProperty("DnD.Autoscroll.cursorHysteresis");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void _cleanup() {
        if (this._timer != null) {
            this._timer.stop();
        }
        this._component = null;
        this._lastPosition = null;
    }

    private void _checkForAutoscroll() {
        this._updateAutoscrollRegion(this._component);
        if (this._outerRect.contains(this._lastPosition) && !this._innerRect.contains(this._lastPosition)) {
            this._autoscroll(this._component, this._lastPosition);
        }
    }

    private class DragScroller
    implements ActionListener {
        private DragScroller() {
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            AutoscrollingDragListener.this._checkForAutoscroll();
        }
    }
}

