/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.beans.PropertyVetoException;
import java.util.Set;
import java.util.TreeSet;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.ValueInsightData;
import oracle.bali.xml.editor.insight.data.AttributeValueItemItem;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.javatools.editor.insight.ListDataItem;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EnumerationValueInsightData
extends ValueInsightData {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDataItem[] getListDataItems(QualifiedName attrQName, ElementDef parentElementDef, AttributeDef attributeDef, ElementDeclaration elementDecl, AttributeDeclarations attributes, int attrIndex, int caretPosition) {
        TreeSet<AttributeValueItemItem> listData = null;
        XmlContext xmlContext = this.getProvider().getXmlContext();
        if (xmlContext != null) {
            XmlModel xmlModel = xmlContext.getModel();
            DomModel domModel = xmlModel.getDomModel();
            xmlModel.acquireReadLock();
            try {
                Node nodeAtCaretPosition;
                DomPosition domPos = domModel.getDomPosition(caretPosition);
                if (domPos != null && (nodeAtCaretPosition = domPos.getTargetNode()) != null && nodeAtCaretPosition.getNodeType() == 1) {
                    Attr attr;
                    Element element = (Element)nodeAtCaretPosition;
                    int elementStartOffset = domModel.getTextOffset(DomPositionFactory.createDomPosition((Node)element, (int)1));
                    ElementLocator elementLocator = elementDecl.getElementLocator();
                    if (elementLocator.getStartOffset() == elementStartOffset && (attr = element.getAttributeNodeNS(attrQName.getNamespace(), attrQName.getName())) != null) {
                        Set metadataValues;
                        listData = new TreeSet();
                        BaseInspectorGui gui = (BaseInspectorGui)((GuiXmlContext)xmlContext).getGui(XmlUsage.PROPERTY_INSPECTOR);
                        XmlMetadataResolver xmr = gui.getView().getXmlMetadataResolver();
                        if (gui != null && (metadataValues = gui.getAttributeValues((Node)attr, xmr.getNodeXmlKey((Node)attr), xmr.getNodeXmlKey((Node)element), (Node)element, (Node)element)) != null) {
                            for (AttributeValueItem value : metadataValues) {
                                if (value.getDisplayText() == null) continue;
                                listData.add(new AttributeValueItemItem(value, attr));
                            }
                        }
                    }
                }
            }
            finally {
                xmlModel.releaseReadLock();
            }
        }
        if (listData == null) {
            listData = new TreeSet<AttributeValueItemItem>();
            if (attributeDef != null) {
                InsightUtils.getAttributeValues(attributeDef, listData);
            }
        }
        ListDataItem[] insightDataList = new ListDataItem[listData.size()];
        listData.toArray(insightDataList);
        return insightDataList;
    }

    @Override
    protected String getSelectedText(Object selectedObject) {
        if (selectedObject instanceof AttributeValueItemItem) {
            AttributeValueItem item = ((AttributeValueItemItem)((Object)selectedObject)).getItem();
            try {
                return item.selectValue();
            }
            catch (PropertyVetoException e) {
                return null;
            }
        }
        return super.getSelectedText(selectedObject);
    }
}

