/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.demo;

import java.io.File;
import java.net.URL;
import oracle.bali.xml.grammar.schema.error.XmlErrorLog;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.XMLError;

public final class SchemaTest {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage:  SchemaTest [path to schema]");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            URL currentURL = null;
            try {
                Object filename = args[i];
                File aFile = new File((String)filename);
                filename = aFile.getCanonicalPath();
                filename = ((String)filename).charAt(0) == '/' ? "file:" + (String)filename : "file:/" + (String)filename;
                currentURL = new URL((String)filename);
            }
            catch (Exception e) {
                System.err.println("Could not find file" + args[i]);
            }
            if (currentURL == null) continue;
            XmlErrorLog errorHandler = new XmlErrorLog();
            boolean exceptionEncountered = false;
            try {
                SchemaTest.validateSchema(currentURL, (XMLError)errorHandler);
            }
            catch (Exception e) {
                exceptionEncountered = true;
                System.out.println();
                System.out.println("Exception thrown parsing " + args[i] + ":");
                System.out.println(e.getMessage());
            }
            if (errorHandler.hasWarnings() || errorHandler.hasErrors() || errorHandler.hasFatalErrors()) {
                System.out.println();
                System.out.println("Errors were encountered parsing " + args[i] + ":");
                System.out.println(errorHandler);
                continue;
            }
            if (exceptionEncountered) continue;
            System.out.println();
            System.out.println("There were no errors parsing " + args[i] + ":");
        }
    }

    public static void validateSchema(URL schemaURL, XMLError errorHandler) throws Exception {
        if (schemaURL != null) {
            XSDBuilder builder = new XSDBuilder();
            builder.setDebugMode(true);
            if (errorHandler != null) {
                builder.setError(errorHandler);
            }
            XMLSchema xMLSchema = builder.build(schemaURL);
        }
    }
}

