/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.swagger;

import jakarta.json.JsonObject;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.swagger.ParserBase;

public class SwaggerParser
extends ParserBase {
    private static final String SUPPORTED_VERSION = "2.0";

    @Override
    public RestModule read(JsonObject root) {
        RestModule module = null;
        if (this.isValidVersion(root)) {
            module = new RestModule();
            module.setName(this.getModuleName(root));
            module.setURIPrefix(this.getModuleBasePath(root));
            module.setTemplates(this.getTemplates(root));
            module.setPublished(true);
            module.setPaginationSize(25L);
            module.setComments(this.getModuleComments(root));
        }
        return module;
    }

    @Override
    protected String getModuleBasePath(JsonObject object) {
        String basePath = object.getString("basePath");
        return basePath;
    }

    @Override
    protected boolean isValidVersion(JsonObject node) {
        String version = node.getString("swagger");
        return SUPPORTED_VERSION.equals(version);
    }
}

