/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.common.utils.UtilResources;
import oracle.dbtools.logging.Timer;
import oracle.dbtools.raptor.utils.ProvideTnsnamesDir;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.WindowsUtility;

public class TNSHelper {
    private static final String TNSNAMES_ORA = "tnsnames.ora";
    public static final String ENV_OH = "ORACLE_HOME";
    public static final String ENV_TA = "TNS_ADMIN";
    public static final String ENV_LA = "LDAP_ADMIN";
    private static Map<String, Long> lastModified = new HashMap<String, Long>();
    private static Object LOCK = new Object();
    private static final String NETWORK_ADMIN_PATH = File.separator + "network" + File.separator + "admin";
    public static final String FILE_TNS = NETWORK_ADMIN_PATH + File.separator + "tnsnames.ora";
    private static ArrayList<TCPTNSEntry> s_entries = null;
    private static Logger logger = Logger.getLogger("oracle.dbtools.raptor.utils");
    private static LinkedHashMap<String, String> s_paths = new LinkedHashMap();
    private static FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.equalsIgnoreCase(".tnsnames") || name.equalsIgnoreCase(TNSHelper.TNSNAMES_ORA);
        }
    };
    private static TreeSet<String> inclFiles = new TreeSet();
    private static ProvideTnsnamesDir getProvideTnsnamesDir = null;

    public static LinkedHashMap<String, String> getTNSLookupLocations() {
        return s_paths;
    }

    public static void forceDirty() {
        lastModified = new HashMap<String, Long>();
    }

    private static boolean checkForTns(String dir) {
        logger.fine(UtilResources.getString("TNSHelper.12") + dir);
        boolean ret = false;
        File d = new File(dir);
        if (d.exists() && d.listFiles(filter).length > 0) {
            ret = true;
        }
        return ret;
    }

    private static File getTNSFileContent(boolean forceReload) throws NotDirtyException {
        boolean isWindows;
        File possibleTnsnames;
        ProvideTnsnamesDir pFile;
        logger.finest("getTNSFileContent - START");
        String oh = System.getenv().get(ENV_OH);
        String ta = System.getenv().get(ENV_TA);
        String driverHome = System.getProperty("jdbc.driver.home");
        String tnsAdmin = System.getProperty("oracle.net.tns_admin");
        String user = System.getProperty("user.home");
        Object dir = null;
        String previous = s_paths.get("Actual");
        s_paths.clear();
        if (tnsAdmin != null && !tnsAdmin.isEmpty()) {
            s_paths.put("oracle.net.tns_admin", tnsAdmin);
            dir = tnsAdmin;
        }
        if ((pFile = TNSHelper.getProvideTnsnamesDir()) != null && (possibleTnsnames = pFile.getTnsnamesDir()) != null) {
            try {
                s_paths.put("Third Party Path", possibleTnsnames.getAbsolutePath());
                String checkThePref = possibleTnsnames.getAbsolutePath();
                if (dir == null && TNSHelper.checkForTns(checkThePref)) {
                    dir = checkThePref;
                }
            }
            catch (Throwable e) {
                dir = null;
            }
        }
        s_paths.put("USER Home dir", user);
        if (dir == null && TNSHelper.checkForTns(user)) {
            dir = user;
        }
        if (!(isWindows = PlatformUtils.isWindows()) && dir == null && TNSHelper.checkForTns("/etc")) {
            s_paths.put("/etc", "/etc");
            dir = "/etc";
        }
        if (ta != null) {
            s_paths.put(ENV_TA, ta);
            if (dir == null && TNSHelper.checkForTns(ta)) {
                dir = ta;
            }
        }
        String filePath = NETWORK_ADMIN_PATH;
        if (driverHome != null) {
            s_paths.put("Driver path", driverHome + filePath);
            if (dir == null && TNSHelper.checkForTns(driverHome + filePath)) {
                dir = driverHome + filePath;
            }
        }
        if (oh != null) {
            s_paths.put(ENV_OH, oh + filePath);
            if (dir == null && TNSHelper.checkForTns(oh + filePath)) {
                dir = oh + filePath;
            }
        }
        if (dir == null && isWindows) {
            oh = null;
            String tnsKey = null;
            logger.fine(UtilResources.getString("TNSHelper.20"));
            String key = "SOFTWARE\\ORACLE";
            try {
                List<String> oracle_keys = WindowsUtility.readStringSubKeys(-2147483646, key);
                String homeKey = null;
                for (String oracle_key : oracle_keys) {
                    String temp = key + "\\" + oracle_key;
                    homeKey = WindowsUtility.readString(-2147483646, temp, "ORACLE_HOME_KEY");
                    if (homeKey == null) continue;
                    logger.fine(UtilResources.getString("TNSHelper.24") + homeKey);
                    tnsKey = WindowsUtility.readString(-2147483646, temp, ENV_TA);
                    logger.fine(UtilResources.getString("TNSHelper.26") + tnsKey);
                    break;
                }
                if (homeKey != null) {
                    oh = WindowsUtility.readString(-2147483646, homeKey, ENV_OH);
                    logger.fine(UtilResources.getString("TNSHelper.29") + oh);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            if (oh != null && tnsKey == null) {
                s_paths.put(ENV_OH, oh + filePath);
                dir = oh + filePath;
            }
            if (dir == null && tnsKey != null) {
                s_paths.put(ENV_TA, tnsKey);
                dir = tnsKey;
            }
        }
        if (dir == null) {
            return null;
        }
        if (dir == previous && !TNSHelper.isDirty((String)dir)) {
            throw new NotDirtyException();
        }
        s_entries = new ArrayList();
        logger.finest("getTNSFileContent - END");
        s_paths.put("Actual", (String)dir);
        return new File((String)dir);
    }

    public static String getOracleHome() {
        return OracleHomeHolder.getOracleHome();
    }

    public static boolean isDirty(String dir) {
        return TNSHelper.isDirty(new File(dir));
    }

    private static boolean isDirty(File d) {
        boolean ret = false;
        for (File f : d.listFiles(filter)) {
            if (lastModified.get(f.toString()) == null || lastModified.get(f.toString()).longValue() != f.lastModified()) {
                ret = true;
            } else if (f.isDirectory()) {
                ret = TNSHelper.isDirty(f);
            }
            if (ret) break;
        }
        return ret;
    }

    public static void updateTimeStamps(String dir) {
        File d = new File(dir);
        for (File f : d.listFiles(filter)) {
            lastModified.put(f.toString(), new Long(f.lastModified()));
        }
    }

    public static TCPTNSEntry getEntry(String name) {
        ArrayList<TCPTNSEntry> entries = TNSHelper.getTNSEntries();
        for (TCPTNSEntry entry : entries) {
            if (!entry.getName().equalsIgnoreCase(name)) continue;
            return entry;
        }
        return null;
    }

    private static ArrayList<TCPTNSEntry> getTNSEntries(File fileContent) throws IOException {
        logger.finest("getTNSItems - START");
        ArrayList<TCPTNSEntry> result = new ArrayList<TCPTNSEntry>();
        if (fileContent != null && fileContent.exists() && fileContent.isDirectory()) {
            for (File f : fileContent.listFiles(filter)) {
                result.addAll(TNSHelper.getTNSEntries(f));
            }
            TNSHelper.updateTimeStamps(fileContent.toString());
        } else if (fileContent != null && fileContent.exists()) {
            List<TCPTNSEntry> lstItems = TNSHelper.parseTnsFileInternal(fileContent);
            TNSHelper.updateTimeStamps(fileContent.getParent());
            result.addAll(lstItems);
        }
        return result;
    }

    public static List<TCPTNSEntry> parseTnsFile(File fileContent) throws FileNotFoundException, IOException {
        inclFiles.clear();
        return TNSHelper.parseTnsFileInternal(fileContent);
    }

    public static List<TCPTNSEntry> parseTnsFileInternal(File fileContent) throws FileNotFoundException, IOException {
        try (InputStreamReader r = new InputStreamReader(new FileInputStream(fileContent));){
            logger.finest("getTNSItems - OPEN: " + fileContent.getPath());
            List<TCPTNSEntry> result = TNSHelper.parseTnsFileInternal(r, fileContent.getParentFile());
            logger.finest("getTNSItems - CLOSE: " + fileContent.getPath());
            List<TCPTNSEntry> list = result;
            return list;
        }
    }

    public static List<TCPTNSEntry> parseTnsFile(Reader is) throws IOException {
        inclFiles.clear();
        return TNSHelper.parseTnsFileInternal(is, null);
    }

    private static List<TCPTNSEntry> parseTnsFileInternal(Reader is, File workingDir) throws IOException {
        ArrayList<TCPTNSEntry> lstItems = new ArrayList<TCPTNSEntry>();
        try (BufferedReader in = new BufferedReader(is);){
            int bracketCount = 0;
            String buffer = null;
            StringBuilder currentEntry = new StringBuilder();
            TCPTNSEntry entry = null;
            String name = null;
            String desc = null;
            while ((buffer = in.readLine()) != null) {
                if (buffer.indexOf("#") > 0) {
                    buffer = buffer.substring(0, buffer.indexOf("#"));
                }
                if (buffer.indexOf(35) == 0) continue;
                for (int i = 0; i < buffer.length(); ++i) {
                    if (buffer.charAt(i) == '(') {
                        ++bracketCount;
                        continue;
                    }
                    if (buffer.charAt(i) != ')') continue;
                    --bracketCount;
                }
                currentEntry.append(buffer);
                if (currentEntry.indexOf("=") <= 0) continue;
                String maybeName = currentEntry.substring(0, currentEntry.indexOf("=")).trim();
                int binName = 0;
                for (int i = 0; i < maybeName.length(); ++i) {
                    if (maybeName.charAt(i) == '(') {
                        ++binName;
                        continue;
                    }
                    if (maybeName.charAt(i) != ')') continue;
                    --binName;
                }
                if (bracketCount != binName) continue;
                name = currentEntry.substring(0, currentEntry.indexOf("=")).trim();
                desc = currentEntry.substring(currentEntry.indexOf("=") + 1).trim();
                if (name.trim().toLowerCase().equals("ifile")) {
                    String cwd = workingDir.getPath() + File.separator;
                    File iFile = new File(cwd + desc);
                    if (!iFile.exists()) {
                        iFile = new File(desc);
                    }
                    if (iFile.exists()) {
                        TNSHelper.addInclFile(iFile);
                        lstItems.addAll(TNSHelper.getTNSEntries(iFile));
                    } else {
                        logger.severe(UtilResources.getString("TNSHelper.38") + desc);
                    }
                    currentEntry.setLength(0);
                    continue;
                }
                if (name.length() <= 0 || desc.trim().length() <= 0) continue;
                for (String singleName : name.split(",")) {
                    if (singleName == null || (singleName = singleName.trim()).length() == 0) continue;
                    TCPTNSEntry aliasedAlias = null;
                    for (TCPTNSEntry tns : lstItems) {
                        if (!tns.getName().equalsIgnoreCase(desc)) continue;
                        aliasedAlias = tns;
                    }
                    entry = aliasedAlias != null ? new TCPTNSEntry(singleName, aliasedAlias.getDescriptor()) : new TCPTNSEntry(singleName, desc);
                    lstItems.add(entry);
                    logger.fine(UtilResources.getString("TNSHelper.39") + singleName);
                }
                currentEntry.setLength(0);
                bracketCount = 0;
            }
            in.close();
        }
        logger.finest("getTNSItems - END");
        return lstItems;
    }

    public static List<TCPTNSEntry> parseTnsFile(Reader is, File workingDir) throws IOException {
        inclFiles.clear();
        return TNSHelper.parseTnsFileInternal(is, workingDir);
    }

    private static void addInclFile(File ifile) throws IOException {
        String cfile = ifile.getCanonicalPath();
        if (inclFiles.contains(cfile)) {
            String msg = "Cycle detected when attempting to include " + cfile;
            logger.severe(msg);
            throw new IOException(msg);
        }
        inclFiles.add(cfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<TCPTNSEntry> getTNSEntries() {
        Object object = LOCK;
        synchronized (object) {
            logger.finest("getTNSEntries - START");
            Timer timer = new Timer();
            timer.start();
            if (s_entries == null) {
                s_entries = new ArrayList();
            }
            ArrayList<TCPTNSEntry> ret = s_entries;
            try {
                File contents = TNSHelper.getTNSFileContent(false);
                if (contents != null) {
                    logger.fine(UtilResources.getString("TNSHelper.43") + contents.toString());
                    ret = TNSHelper.getTNSEntries(contents);
                }
            }
            catch (Exception contents) {
                // empty catch block
            }
            Comparator<TCPTNSEntry> comp = new Comparator<TCPTNSEntry>(){

                @Override
                public int compare(TCPTNSEntry e1, TCPTNSEntry e2) {
                    return Collator.getInstance().compare(e1.toString(), e2.toString());
                }
            };
            Collections.sort(ret, comp);
            logger.finest("Finished Parsing TNS in" + timer.durationInSecs());
            logger.finest("getTNSEntries - END");
            if (s_entries != ret) {
                s_entries.addAll(ret);
            }
            return ret;
        }
    }

    public static ProvideTnsnamesDir getProvideTnsnamesDir() {
        return getProvideTnsnamesDir;
    }

    public static void setProvideTnsnamesDir(ProvideTnsnamesDir gettnsnamesDir) {
        getProvideTnsnamesDir = gettnsnamesDir;
    }

    public static void main(String[] args) throws Exception {
        logger.fine("OH=" + System.getenv(ENV_OH));
        logger.fine("TA=" + System.getenv(ENV_TA));
        ArrayList<TCPTNSEntry> entries = TNSHelper.getTNSEntries();
        for (TCPTNSEntry entry : entries) {
            logger.fine(entry.toString());
        }
        System.exit(0);
    }

    public static String getTnsnamesFile() {
        URL url;
        File f;
        ArrayList<TCPTNSEntry> entries = TNSHelper.getTNSEntries();
        ArrayList<String> usedLocations = new ArrayList<String>();
        Object tnsNames = null;
        Object tnsAdminLocation = System.getProperty("oracle.net.tns_admin");
        if (tnsAdminLocation != null && ((String)tnsAdminLocation).length() > 0) {
            usedLocations.add((String)tnsAdminLocation);
        } else {
            Iterator<String> it = TNSHelper.getTNSLookupLocations().keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                if (it.hasNext()) continue;
                usedLocations.add(TNSHelper.getTNSLookupLocations().get(key));
            }
        }
        if (!usedLocations.isEmpty() && (f = new File((url = FileUtils.getFile(null, (String)usedLocations.get(0), false)).getFile())).exists()) {
            tnsAdminLocation = (String)usedLocations.get(0) + File.separator + TNSNAMES_ORA;
        }
        return tnsAdminLocation;
    }

    public static String getTnsnamesDir() {
        URL url;
        File f;
        ArrayList<TCPTNSEntry> entries = TNSHelper.getTNSEntries();
        ArrayList<String> usedLocations = new ArrayList<String>();
        String tnsAdminLocation = System.getProperty("oracle.net.tns_admin");
        if (tnsAdminLocation != null && tnsAdminLocation.length() > 0) {
            usedLocations.add(tnsAdminLocation);
        } else {
            Iterator<String> it = TNSHelper.getTNSLookupLocations().keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                if (it.hasNext()) continue;
                usedLocations.add(TNSHelper.getTNSLookupLocations().get(key));
            }
        }
        if (!usedLocations.isEmpty() && (f = new File((url = FileUtils.getFile(null, (String)usedLocations.get(0), false)).getFile())).exists()) {
            tnsAdminLocation = (String)usedLocations.get(0);
        }
        return tnsAdminLocation;
    }

    private static class OracleHomeHolder {
        private static final String OH;

        private OracleHomeHolder() {
        }

        private static String getOracleHome() {
            return OH;
        }

        static {
            String oh;
            block4: {
                oh = System.getenv().get(TNSHelper.ENV_OH);
                if (oh == null && PlatformUtils.isWindows()) {
                    String key = "SOFTWARE\\ORACLE";
                    try {
                        List<String> oracle_keys = WindowsUtility.readStringSubKeys(-2147483646, key);
                        String homeKey = null;
                        if (oracle_keys == null || oracle_keys.isEmpty()) break block4;
                        for (String oracle_key : oracle_keys) {
                            String temp = key + "\\" + oracle_key;
                            homeKey = WindowsUtility.readString(-2147483646, temp, "ORACLE_HOME_KEY");
                            logger.fine(UtilResources.getString("TNSHelper.24") + temp + ": " + homeKey);
                            if (homeKey == null) continue;
                            oh = WindowsUtility.readString(-2147483646, homeKey, TNSHelper.ENV_OH);
                            logger.fine(UtilResources.getString("TNSHelper.29") + oh);
                            if (oh == null) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                }
            }
            OH = oh;
        }
    }

    private static class NotDirtyException
    extends Exception {
        private NotDirtyException() {
        }
    }
}

