/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.query.Bind;

public class Parser {
    private static Object LOCK = new Object();
    private static Parser _instance;
    private LinkedList<String> cacheQueue = new LinkedList();
    private Map<String, List<LexerToken>> lexCache = new TreeMap<String, List<LexerToken>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Parser getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new Parser();
            }
        }
        return _instance;
    }

    public ArrayList<String> getBindNames(String in) {
        return this.getBindNames(in, false);
    }

    public ArrayList<String> getBindNames(String in, boolean all) {
        ArrayList<Bind> binds = this.getBinds(in, all);
        ArrayList<String> ret = new ArrayList<String>();
        for (Bind b : binds) {
            ret.add(b.getName().intern());
        }
        return ret;
    }

    public ArrayList<Bind> getBinds(String in) {
        return this.getBinds(in, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Bind> getBinds(String input, boolean all) {
        ArrayList<Bind> ret = new ArrayList<Bind>();
        if (input == null) {
            return ret;
        }
        if (input.indexOf(58) < 0) {
            return ret;
        }
        List src = null;
        Map<String, List<LexerToken>> map = this.lexCache;
        synchronized (map) {
            src = this.lexCache.get(input);
        }
        if (src == null) {
            src = Lexer.parse((String)input);
        }
        boolean sawColon = false;
        boolean sawTrigger = false;
        boolean sawJsonAttribute = false;
        int curlyNesting = 0;
        int colonStart = 0;
        int allowedDistance = -1;
        for (LexerToken t : src) {
            --allowedDistance;
            if (sawColon) {
                if (!(!all && Parser.contains(ret, t.content) || t.type != Token.IDENTIFIER && t.type != Token.DIGITS)) {
                    if (sawTrigger && (t.content.equalsIgnoreCase("OLD") || t.content.equalsIgnoreCase("NEW"))) {
                        sawColon = false;
                        continue;
                    }
                    boolean isClose = 0 <= allowedDistance;
                    Bind b = new Bind(t.content, null, t.content, "NULL_VALUE", t.content, isClose ? Bind.Mode.RETURNING : Bind.Mode.UNKNOWN);
                    b.setBegin(colonStart);
                    b.setEnd(t.end);
                    ret.add(b);
                    ++allowedDistance;
                }
                sawColon = false;
            } else if (",".equals(t.content)) {
                if (0 <= allowedDistance) {
                    allowedDistance += 2;
                }
            } else if ("{".equals(t.content)) {
                ++curlyNesting;
            } else if ("}".equals(t.content)) {
                --curlyNesting;
            } else if (":".equals(t.content) && !sawJsonAttribute) {
                sawColon = true;
                colonStart = t.begin;
            } else if ("TRIGGER".equalsIgnoreCase(t.content)) {
                sawTrigger = true;
            } else if ("return".equals(t.content.toLowerCase()) || "returning".equals(t.content.toLowerCase())) {
                allowedDistance = 6;
                sawColon = false;
            } else if ("old".equals(t.content.toLowerCase()) || "new".equals(t.content.toLowerCase())) {
                ++allowedDistance;
                sawColon = false;
            }
            sawJsonAttribute = t.type == Token.QUOTED_STRING || t.type == Token.DQUOTED_STRING || 0 < curlyNesting && t.type == Token.IDENTIFIER;
        }
        Map<String, List<LexerToken>> map2 = this.lexCache;
        synchronized (map2) {
            this.cacheQueue.addLast(input);
            this.lexCache.put(input, src);
            if (20 < this.cacheQueue.size()) {
                String nuked = this.cacheQueue.removeFirst();
                this.lexCache.remove(nuked);
            }
        }
        return ret;
    }

    public List<Integer> getQuestionMarks(String input) {
        LinkedList<Integer> ret = new LinkedList<Integer>();
        if (input == null) {
            return ret;
        }
        List src = Lexer.parse((String)input, (boolean)true);
        for (LexerToken t : src) {
            if (!"?".equals(t.content)) continue;
            ret.add(t.begin);
        }
        return ret;
    }

    public String inlineBinds(String input, Map<String, String> bindValues) {
        StringBuilder ret = new StringBuilder();
        List src = Lexer.parse((String)input, (boolean)true);
        boolean sawColon = false;
        for (LexerToken t : src) {
            if (sawColon) {
                if (t.type == Token.IDENTIFIER || t.type == Token.DIGITS) {
                    String value = bindValues.get(t.content);
                    if (value instanceof Integer) {
                        ret.append((Object)value);
                    } else {
                        ret.append("'" + value + "'");
                    }
                }
                sawColon = false;
                continue;
            }
            if (":".equals(t.content)) {
                sawColon = true;
                continue;
            }
            ret.append(t.content);
        }
        return ret.toString();
    }

    private static boolean contains(ArrayList<Bind> binds, String name) {
        for (Bind bind : binds) {
            if (!bind.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

