/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer.basic;

import java.util.Locale;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.Messages;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.PrimitiveTransformers;

public abstract class AbstractRangeTransformer<N extends Number>
implements Transformer<String, N> {
    private final Transformer<String, N> numberTransformer;
    private final N lower;
    private final N upper;

    protected AbstractRangeTransformer(Class<N> cls, N lower, N upper) {
        this.numberTransformer = PrimitiveTransformers.get(cls);
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public N transform(String rawValue, TransformContext context, Environment environment) {
        Number value = (Number)this.numberTransformer.transform(rawValue, context, environment);
        if (value != null && !this.checkRange(value, this.lower, this.upper)) {
            context.addError(Messages.getString(Messages.Key.OUT_OF_RANGE, environment.getLocale()));
        }
        return (N)value;
    }

    protected abstract boolean checkRange(N var1, N var2, N var3);

    @Override
    public String getFormat(Locale locale) {
        return this.lower + " ... " + this.upper;
    }
}

