/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.Messages;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.NONE)
public class ShowBlockTerminator
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWBLOCKTERMINATOR = new String[]{"blo", "blockterminator"};

    @Override
    public String[] getShowAliases() {
        return SHOWBLOCKTERMINATOR;
    }

    private String getWriteString(ScriptRunnerContext ctx, String message) {
        String report = message;
        if (ctx.getProperty("BLOCKTERMINATOR") == null) {
            return MessageFormat.format(report, ".", String.format("%x", 46));
        }
        if (ctx.getProperty("BLOCKTERMINATOR").equals("off")) {
            return Messages.getString("ShowBlockTerminator.2");
        }
        if (ctx.getProperty("BLOCKTERMINATOR").equals("on")) {
            return Messages.getString("ShowBlockTerminator.3");
        }
        String s = ctx.getProperty("BLOCKTERMINATOR").toString();
        if (s.length() == 1) {
            return MessageFormat.format(report, s, String.format("%x", s.charAt(0)));
        }
        return MessageFormat.format(Messages.getString("ShowBlockTerminator.5"), s);
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ctx.write(this.getWriteString(ctx, Messages.getString("ShowBlockTerminator.0")));
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return StoreRegistry.getCommand("blockterminator", this.getWriteString(ctx, "\"{0}\""));
    }
}

