/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import oracle.dbtools.db.ResultSetHolder;
import oracle.dbtools.db.ResultSetWrapper;

class ResultSetTracker {
    private static final ReferenceQueue<ResultSetWrapper> s_queue = new ReferenceQueue();
    private static final Collection<TrackerEntry> s_entries = new ArrayList<TrackerEntry>();

    ResultSetTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void trackResultSet(ResultSetWrapper wrapper) {
        Collection<TrackerEntry> collection = s_entries;
        synchronized (collection) {
            ResultSetTracker.cleanupDeadWrappers();
            s_entries.add(new TrackerEntry(wrapper));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void untrackResultSet(ResultSetWrapper wrapper) {
        Collection<TrackerEntry> collection = s_entries;
        synchronized (collection) {
            TrackerEntry entry = new TrackerEntry(wrapper);
            s_entries.remove(entry);
            ResultSetTracker.cleanupDeadWrappers();
        }
    }

    private static void cleanupDeadWrappers() {
        TrackerEntry entry;
        while ((entry = (TrackerEntry)s_queue.poll()) != null) {
            if (!s_entries.remove(entry)) continue;
            ResultSetHolder holder = entry.m_holder;
            holder.logStack(true);
            holder.close();
        }
    }

    private static class TrackerEntry
    extends WeakReference<ResultSetWrapper> {
        private final ResultSetHolder m_holder;

        TrackerEntry(ResultSetWrapper wrapper) {
            super(wrapper, s_queue);
            this.m_holder = wrapper.getHolder();
        }

        public boolean equals(Object o) {
            return o instanceof TrackerEntry && ((TrackerEntry)o).m_holder == this.m_holder;
        }

        public int hashCode() {
            return this.m_holder.hashCode();
        }
    }
}

