/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mdb.utils;

import java.sql.ResultSet;
import java.util.ArrayList;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class MDBUtils {
    public static void printAsTable(ScriptRunnerContext context, ResultSet resultSet, int[] columnsToPrint) throws Exception {
        int columnIndex;
        int i;
        ArrayList<String[]> rows = new ArrayList<String[]>();
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        for (int i2 = 0; i2 < columnsToPrint.length; ++i2) {
            columnWidths.add(0);
        }
        while (resultSet.next()) {
            String[] row = new String[columnsToPrint.length];
            for (i = 0; i < columnsToPrint.length; ++i) {
                String value;
                columnIndex = columnsToPrint[i];
                row[i] = value = resultSet.getString(columnIndex);
                if (value == null || value.length() <= (Integer)columnWidths.get(i)) continue;
                columnWidths.set(i, value.length());
            }
            rows.add(row);
        }
        context.write("\n");
        int headerSeparatorLength = 0;
        for (i = 0; i < columnsToPrint.length; ++i) {
            columnIndex = columnsToPrint[i];
            String columnName = resultSet.getMetaData().getColumnName(columnIndex);
            context.write(String.format("%-" + columnWidths.get(i) + "s " + (i < columnsToPrint.length - 1 ? "|" : ""), columnName));
            headerSeparatorLength += Integer.max(columnName.length(), (Integer)columnWidths.get(i));
        }
        context.writeln("\n" + "-".repeat(headerSeparatorLength));
        for (String[] row : rows) {
            for (int i3 = 0; i3 < columnsToPrint.length; ++i3) {
                context.write(String.format("%-" + columnWidths.get(i3) + "s " + (i3 < columnsToPrint.length - 1 ? "|" : ""), row[i3] != null ? row[i3] : ""));
            }
            context.write("\n");
        }
    }
}

