/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import oracle.bali.ewt.border.TitledPane;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.mdeditor.wfs.layer.WFSLayer;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.Theme;
import oracle.sdovis.WFSTheme;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.WFSThemeDefinition;
import oracle.sdovis.theme.WFSThemeProducer;
import oracle.sdovis.util.WSAuthenticator;
import oracle.sdovis.util.WfsCapabilities;
import oracle.sdovis.util.WfsFeatureType;
import oracle.spatial.security.ChecksumHelper;

public class WFSLayerPropertyPanel
extends JPanel {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    private WFSLayer sessionLayer = null;
    private JLabel nameLabel = new JLabel();
    private JLabel nameTxt = new JLabel();
    private JLabel basetableLabel = new JLabel();
    private JLabel basetableTxt = new JLabel();
    private JLabel keyColumnLabel = new JLabel();
    private JComboBox keyColumnComboBox = new JComboBox();
    private JLabel geomColumnLabel = new JLabel();
    private JComboBox geomColumnComboBox = new JComboBox();
    private JCheckBox labelCheckBox = new JCheckBox();
    private JComboBox labelComboBox = new JComboBox();
    private JLabel outerringLabel = new JLabel();
    private JComboBox outerringComboBox = new JComboBox();
    private JCheckBox shareBoundaryBox = new JCheckBox();
    private JLabel serverLabel = new JLabel();
    private JTextField serverField = new JTextField();
    private JLabel versionLabel = new JLabel();
    private JComboBox versionCombo = new JComboBox();
    private JCheckBox secCheckBox = new JCheckBox();
    private TitledPane secTitledPane = new TitledPane();
    private JPanel secPanel = new JPanel();
    private JTextField userTxt = new JTextField();
    private JPasswordField pwdTxt = new JPasswordField();
    private JButton applyButton = new JButton(MessagesBundle.getMessage("Button_apply"));
    private JLabel labelFiller = new JLabel();
    private boolean allowLabelChanges = true;
    private String[] spatialColumns = null;
    private String[] tableAttrs = null;
    protected String[] seqNames = null;
    static ImageIcon editableIcon = Icons.getIcon("edit16.png");
    private String authUser = null;
    private String authPwd = null;

    public WFSLayerPropertyPanel(WFSLayer layer) {
        this.sessionLayer = layer;
        String[] stringArray = new String[1];
        stringArray[0] = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        this.spatialColumns = stringArray;
        this.tableAttrs = layer.getNonComplexAttributes();
        this.authUser = layer.getProperty("oracle.mdeditor.wfs.layer.WFSLayer.authenticationUser");
        if (this.authUser != null && this.authUser.equalsIgnoreCase("null")) {
            this.authUser = null;
        }
        this.authPwd = layer.getProperty("oracle.mdeditor.wfs.layer.WFSLayer.authenticationPassword");
        if (this.authPwd != null && this.authPwd.equalsIgnoreCase("null")) {
            this.authPwd = null;
        }
        if (this.authPwd != null && this.authPwd.length() >= 32) {
            this.authPwd = ChecksumHelper.decAsc((String)this.authPwd);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(420, 400));
        this.nameLabel.setText(MessagesBundle.getMessage("Label_name"));
        this.shareBoundaryBox.setText(MessagesBundle.getMessage("Shared_boundary"));
        this.labelCheckBox.setText(MessagesBundle.getMessage("Label_label_column"));
        this.geomColumnLabel.setText(MessagesBundle.getMessage("Label_geometry_column"));
        this.keyColumnLabel.setText(MessagesBundle.getMessage("Label_key_column"));
        this.basetableLabel.setText(MessagesBundle.getMessage("Label_feature"));
        this.outerringLabel.setText(MessagesBundle.getMessage("Label_polygon_outer_ring_orientation"));
        this.outerringComboBox.addItem("counterclockwise");
        this.outerringComboBox.addItem("clockwise");
        this.applyButton.setMnemonic(65);
        this.applyButton.addActionListener(new ActionListener(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block20: {
                    block19: {
                        block18: {
                            geomCol = WFSLayerPropertyPanel.this.getGeometryColumn();
                            keyCol = WFSLayerPropertyPanel.this.getKeyColumn();
                            version = WFSLayerPropertyPanel.this.getVersion();
                            serverURL = WFSLayerPropertyPanel.this.getServer();
                            if (serverURL == null || serverURL.trim().length() == 0) {
                                JOptionPane.showMessageDialog(null, MessagesBundle.getMessage("Invalid_capabilities_url"), MessagesBundle.getMessage("Error"), 0);
                                return;
                            }
                            authUser = WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this).getProperty("oracle.mdeditor.wfs.layer.WFSLayer.authenticationUser");
                            if (authUser != null && authUser.equalsIgnoreCase("null")) {
                                authUser = null;
                            }
                            if ((authPwd = WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this).getProperty("oracle.mdeditor.wfs.layer.WFSLayer.authenticationPassword")) != null && authPwd.length() >= 32) {
                                authPwd = ChecksumHelper.decAsc((String)authPwd);
                            }
                            if (authPwd != null && authPwd.equalsIgnoreCase("null")) {
                                authPwd = null;
                            }
                            authenticationChanged = false;
                            user = null;
                            pwd = null;
                            if (WFSLayerPropertyPanel.this.isAuthenticationEnabled()) {
                                user = WFSLayerPropertyPanel.this.getUser();
                                pwd = WFSLayerPropertyPanel.this.getPassword();
                                if (user == null || user.length() == 0 || pwd == null || pwd.length() == 0) {
                                    JOptionPane.showMessageDialog(null, MessagesBundle.getMessage("Invalid_authentication_parameters"), MessagesBundle.getMessage("Error"), 0);
                                    return;
                                }
                                if (authUser == null || authPwd == null || !user.equals(authUser) || !pwd.equals(authPwd)) {
                                    authenticationChanged = true;
                                }
                            }
                            if (geomCol == null) break block18;
                            v0 = WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                            WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                            if (!geomCol.equals(v0.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn"))) ** GOTO lbl-1000
                        }
                        if (keyCol == null) break block19;
                        v1 = WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                        WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                        if (!keyCol.equals(v1.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn"))) ** GOTO lbl-1000
                    }
                    if (serverURL != null && !serverURL.equals(WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this).getProperty("oracle.mdeditor.wfs.layer.WFSLayer.serverURL"))) ** GOTO lbl-1000
                    if (version == null) break block20;
                    v2 = WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                    WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                    if (!version.equals(v2.getProperty("oracle.mdeditor.wfs.layer.WFSLayer.version"))) ** GOTO lbl-1000
                }
                if (authenticationChanged) lbl-1000:
                // 5 sources

                {
                    v3 = true;
                } else {
                    v3 = change = false;
                }
                if (change && WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this).isModified()) {
                    saveOpt = JOptionPane.showConfirmDialog(WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this).getCanvas().getFrameForDialog(), "Save before?", "Changes found", 1);
                    if (saveOpt == 0) {
                        WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this).save();
                    } else if (saveOpt == 2) {
                        return;
                    }
                }
                v4 = WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                v4.setProperty("oracle.mdeditor.wfs.layer.WFSLayer.serverURL", serverURL);
                WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this).setProperty("oracle.spatial.edit.layer.GeometrySetLayer.polygonOuterRingOrientation", WFSLayerPropertyPanel.this.getOuterRingOrientation());
                labelCol = null;
                if (WFSLayerPropertyPanel.this.isLabelSelected()) {
                    labelCol = WFSLayerPropertyPanel.this.getLabelColumn();
                }
                v5 = WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                v5.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelColumn", labelCol);
                v6 = WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                v6.setProperty("oracle.spatial.edit.layer.GeometrySetLayer.shareboundary", Boolean.toString(WFSLayerPropertyPanel.this.isShareBoundary()));
                if (WFSLayerPropertyPanel.this.isAuthenticationEnabled()) {
                    WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this).setProperty("oracle.mdeditor.wfs.layer.WFSLayer.authenticationUser", WFSLayerPropertyPanel.this.getUser());
                    WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this).setProperty("oracle.mdeditor.wfs.layer.WFSLayer.authenticationPassword", ChecksumHelper.encAsc((String)WFSLayerPropertyPanel.this.getPassword()));
                } else {
                    WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this).setProperty("oracle.mdeditor.wfs.layer.WFSLayer.authenticationUser", null);
                    WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this).setProperty("oracle.mdeditor.wfs.layer.WFSLayer.authenticationPassword", null);
                }
                if (change) {
                    v7 = WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                    WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                    v7.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn", WFSLayerPropertyPanel.this.getGeometryColumn());
                    v8 = WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                    WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this);
                    v8.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn", WFSLayerPropertyPanel.this.getKeyColumn());
                    if (!WFSLayerPropertyPanel.access$100(WFSLayerPropertyPanel.this, serverURL, WFSLayerPropertyPanel.this.getUser(), WFSLayerPropertyPanel.this.getPassword(), version)) {
                        JOptionPane.showMessageDialog(null, MessagesBundle.getMessage("Unable to rebuild layer. Check log for details."), MessagesBundle.getMessage("Error"), 0);
                        return;
                    }
                    WFSLayerPropertyPanel.access$000(WFSLayerPropertyPanel.this).buildDataSet();
                }
            }
        });
        this.serverLabel = new JLabel(MessagesBundle.getMessage("Label_wfs_get_capabilities_url"));
        this.serverField.setText(this.sessionLayer.getProperty("oracle.mdeditor.wfs.layer.WFSLayer.serverURL"));
        this.versionLabel.setText(MessagesBundle.getMessage("Label_version"));
        this.versionCombo.addItem("1.0.0");
        this.secPanel.setLayout(new GridBagLayout());
        this.secPanel.setSize(new Dimension(240, 100));
        this.secPanel.setPreferredSize(new Dimension(240, 10));
        this.secPanel.add((Component)new JLabel(MessagesBundle.getMessage("Label_user")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 55, 0, 0), 0, 0));
        this.secPanel.add((Component)this.userTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.secPanel.add((Component)new JLabel(MessagesBundle.getMessage("Label_password")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 0), 0, 0));
        this.secPanel.add((Component)this.pwdTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.secPanel.add((Component)new JLabel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.secCheckBox.setText(MessagesBundle.getMessage("Checkbox_basic_authentication"));
        this.secTitledPane.setTitle((Component)this.secCheckBox);
        this.secTitledPane.setContent((Component)this.secPanel);
        this.secCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WFSLayerPropertyPanel.this.secCheckBox_actionPerformed(e);
            }
        });
        JPanel tab1 = new JPanel();
        tab1.setLayout(new GridBagLayout());
        tab1.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 0, 5), 0, 0));
        tab1.add((Component)this.nameTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        tab1.add((Component)this.basetableLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.basetableTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.keyColumnLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.keyColumnComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.geomColumnLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.geomColumnComboBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.labelCheckBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.labelComboBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.outerringLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.outerringComboBox, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.shareBoundaryBox, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        tab1.add((Component)this.serverLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        tab1.add((Component)this.serverField, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        tab1.add((Component)this.versionLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        tab1.add((Component)this.versionCombo, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        tab1.add((Component)this.secTitledPane, new GridBagConstraints(0, 9, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
        tab1.add((Component)this.applyButton, new GridBagConstraints(1, 10, 2, 1, 1.0, 0.0, 10, 0, new Insets(15, 0, 10, 5), 0, 0));
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.addTab("Data Set", tab1);
        this.add((Component)tabPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fillUIparameters();
        this.updateLabelFieldsStatus();
    }

    public void allowLabelChanges(boolean allow) {
        this.allowLabelChanges = allow;
        this.updateLabelFieldsStatus();
    }

    private void updateLabelFieldsStatus() {
        this.labelCheckBox.setEnabled(this.allowLabelChanges);
        this.labelComboBox.setEnabled(this.allowLabelChanges);
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            this.nameTxt.setText("");
        } else {
            this.nameTxt.setText(name);
        }
    }

    public String getGeometryColumn() {
        if (this.geomColumnComboBox.getItemCount() < 1) {
            return null;
        }
        return this.geomColumnComboBox.getSelectedItem().toString();
    }

    public String getLabelColumn() {
        if (this.labelComboBox.getItemCount() < 1) {
            return null;
        }
        return this.labelComboBox.getSelectedItem().toString();
    }

    public boolean isLabelSelected() {
        return this.labelCheckBox.isSelected();
    }

    public void setLabelSelected(boolean select) {
        this.labelCheckBox.setSelected(select);
    }

    public void setGeometryColumns(String[] columns) {
        this.geomColumnComboBox.removeAllItems();
        if (columns == null || columns.length == 0) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            this.geomColumnComboBox.addItem(columns[i]);
        }
    }

    public void setGeometryColumn(String geomCol) {
        if (geomCol == null) {
            return;
        }
        this.geomColumnComboBox.setSelectedItem(geomCol);
    }

    public void setLabelColumns(String[] columns) {
        int i;
        this.labelComboBox.removeAllItems();
        this.labelComboBox.addItem("fid");
        if (columns == null) {
            return;
        }
        ArrayList<String> cols = new ArrayList<String>();
        for (i = 0; i < columns.length; ++i) {
            cols.add(columns[i]);
        }
        Collections.sort(cols);
        for (i = 0; i < cols.size(); ++i) {
            String col = (String)cols.get(i);
            if (col.equalsIgnoreCase("fid")) continue;
            this.labelComboBox.addItem(col);
        }
    }

    public void setLabelColumn(String labelCol) {
        if (labelCol == null) {
            return;
        }
        this.labelComboBox.setSelectedItem(labelCol);
    }

    private void fillUIparameters() {
        String sharedBoundary;
        if (this.sessionLayer == null) {
            return;
        }
        this.setName(this.sessionLayer.getName());
        String typeName = this.sessionLayer.getProperty("oracle.mdeditor.wfs.layer.WFSLayer.featureTypeName");
        this.basetableTxt.setText(typeName);
        String geomColumn = this.sessionLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        String[] geomAttrs = this.spatialColumns;
        this.setGeometryColumns(geomAttrs);
        this.setGeometryColumn(geomColumn);
        String[] attrs = this.tableAttrs;
        this.setKeyColumns(attrs);
        this.setKeyColumn(this.sessionLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn"));
        this.setLabelColumns(attrs);
        this.setLabelSelected(false);
        String labelCol = this.sessionLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelColumn");
        if (labelCol != null && !labelCol.equalsIgnoreCase("null")) {
            this.setLabelColumn(labelCol);
            if (((String)this.labelComboBox.getSelectedItem()).equalsIgnoreCase(labelCol)) {
                this.setLabelSelected(true);
            }
        } else {
            this.setLabelSelected(false);
        }
        if ((sharedBoundary = this.sessionLayer.getProperty("oracle.spatial.edit.layer.GeometrySetLayer.shareboundary")) != null && sharedBoundary.equalsIgnoreCase("true")) {
            this.setShareBoundary(true);
        } else {
            this.setShareBoundary(false);
        }
        if (this.authUser == null || this.authPwd == null) {
            this.secCheckBox.setSelected(false);
        } else {
            this.userTxt.setText(this.authUser);
            this.pwdTxt.setText(this.authPwd);
            this.secCheckBox.setSelected(true);
        }
        String orientation = this.sessionLayer.getProperty("oracle.spatial.edit.layer.GeometrySetLayer.polygonOuterRingOrientation");
        this.setOuterRingOrientation(orientation);
        this.secCheckBox_actionPerformed(null);
    }

    public void setKeyColumns(String[] colnames) {
        this.keyColumnComboBox.removeAllItems();
        this.keyColumnComboBox.addItem("fid");
        if (colnames == null) {
            return;
        }
    }

    public void setKeyColumn(String colname) {
        if (colname == null) {
            return;
        }
        this.keyColumnComboBox.setSelectedItem(colname);
    }

    public String getKeyColumn() {
        if (this.keyColumnComboBox.getItemCount() == 0) {
            return null;
        }
        return this.keyColumnComboBox.getSelectedItem().toString();
    }

    public boolean isShareBoundary() {
        return this.shareBoundaryBox.isSelected();
    }

    public void setShareBoundary(boolean share) {
        this.shareBoundaryBox.setSelected(share);
    }

    public String getServer() {
        return this.serverField.getText();
    }

    private void secCheckBox_actionPerformed(ActionEvent e) {
        if (this.secCheckBox.isSelected()) {
            this.userTxt.setEnabled(true);
            this.pwdTxt.setEnabled(true);
        } else {
            this.userTxt.setEnabled(false);
            this.pwdTxt.setEnabled(false);
        }
    }

    public boolean isAuthenticationEnabled() {
        return this.secCheckBox.isSelected();
    }

    public String getUser() {
        if (!this.isAuthenticationEnabled()) {
            return null;
        }
        if (this.userTxt.getText().trim().length() == 0) {
            return null;
        }
        return this.userTxt.getText().trim();
    }

    public String getPassword() {
        if (!this.isAuthenticationEnabled()) {
            return null;
        }
        String pwd = String.valueOf(this.pwdTxt.getPassword());
        if (pwd == null || pwd.trim().length() == 0) {
            return null;
        }
        return pwd.trim();
    }

    public String getVersion() {
        return this.versionCombo.getSelectedItem().toString();
    }

    public String getOuterRingOrientation() {
        return this.outerringComboBox.getSelectedItem().toString();
    }

    public void setOuterRingOrientation(String orientation) {
        if (orientation == null) {
            return;
        }
        this.outerringComboBox.setSelectedItem(orientation.toLowerCase());
    }

    private boolean rebuildLayerProducer(String serverURL, String user, String pwd, String version) {
        String featTypeName;
        WfsFeatureType wfstype;
        WfsCapabilities capabilities = null;
        if (this.sessionLayer == null || serverURL == null) {
            return false;
        }
        CacheGroup cg = CacheMgr2.getGroup((String)"WFS_URL", (String)"WFS_CAPABILITIES");
        if (cg != null) {
            capabilities = (WfsCapabilities)cg.get((Object)(serverURL.trim() + version));
        }
        if (capabilities == null) {
            WSAuthenticator authenticator = null;
            if (user != null && pwd != null) {
                authenticator = WSAuthenticator.getInstance();
                this.addProtectedURL(authenticator, serverURL.trim(), user, pwd);
            }
            if (!(capabilities = new WfsCapabilities()).readUsingHttpGet(serverURL.trim(), 30000L, version)) {
                log.warning("Unable to get Capabilities from url: " + serverURL.trim());
                return false;
            }
            if (authenticator != null) {
                this.doCompleteAuthentication(authenticator, user, pwd, capabilities);
            }
            if (cg != null) {
                cg.put((Object)(serverURL.trim() + version), (Object)capabilities, 0L);
            }
        }
        if ((wfstype = capabilities.getFeatureType(featTypeName = this.sessionLayer.getProperty("oracle.mdeditor.wfs.layer.WFSLayer.featureTypeName"))) == null) {
            log.warning("Unable to get feature type [" + featTypeName + "]");
            return false;
        }
        if (wfstype.getAttributeTypes() == null) {
            String describeUrl_get = capabilities.describeFeatureTypeGetURL();
            String describeUrl_post = capabilities.describeFeatureTypePostURL();
            if (describeUrl_get != null) {
                wfstype.readAttributesWithTypesUsingHttpGet(describeUrl_get, 30000L, version);
            } else if (describeUrl_post != null) {
                wfstype.readAttributesWithTypesUsingHttpPost(describeUrl_post, 30000L, version);
            }
        }
        if (wfstype.getAttributeTypes() == null) {
            log.warning("Attribute types list for feature type [" + this.sessionLayer.getProperty("oracle.mdeditor.wfs.layer.WFSLayer.featureTypeName") + "] is null.");
            return false;
        }
        boolean foundGeomColumn = false;
        String geomColumn = this.sessionLayer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        ArrayList<String> nonGeomAttrs = new ArrayList<String>(wfstype.getAttributeTypes().size());
        Set entries = wfstype.getAttributeTypes().entrySet();
        for (Map.Entry e : entries) {
            String attrName = e.getKey().toString();
            String attrType = e.getValue().toString();
            if (geomColumn.equalsIgnoreCase(attrName)) {
                foundGeomColumn = true;
                continue;
            }
            nonGeomAttrs.add(attrName);
        }
        if (!foundGeomColumn) {
            log.warning("Unable to find spatial attribute [" + geomColumn + "] for feature type [" + featTypeName + "].");
            return false;
        }
        StylingRule styleRule = new StylingRule();
        styleRule.setAttributeColumns(nonGeomAttrs.toArray(new String[nonGeomAttrs.size()]));
        WFSThemeDefinition themeDef = new WFSThemeDefinition(this.sessionLayer.getName(), null, serverURL, null, featTypeName, geomColumn, new StylingRule[]{styleRule}, null, null);
        themeDef.setAuthentication(this.authUser, this.authPwd);
        themeDef.readCapabilities(30000L);
        WFSTheme theme = new WFSTheme(themeDef);
        theme.getDecorator().setRequestTimeout(30000L);
        WFSThemeProducer producer = new WFSThemeProducer((Theme)theme);
        this.sessionLayer.setThemeProducer(producer);
        return true;
    }

    private void addProtectedURL(WSAuthenticator authenticator, String urlString, String user, String pwd) {
        if (authenticator != null && urlString != null && user != null && pwd != null) {
            if (urlString.endsWith("?")) {
                authenticator.addProtectedURL(urlString.substring(0, urlString.length() - 1), user, pwd);
            } else {
                authenticator.addProtectedURL(urlString, user, pwd);
            }
        }
    }

    private void doCompleteAuthentication(WSAuthenticator authenticator, String user, String pwd, WfsCapabilities capabilities) {
        if (authenticator != null && user != null && pwd != null && capabilities != null) {
            String describeUrl_get = capabilities.describeFeatureTypeGetURL();
            this.addProtectedURL(authenticator, describeUrl_get, user, pwd);
            String describeUrl_post = capabilities.describeFeatureTypePostURL();
            this.addProtectedURL(authenticator, describeUrl_post, user, pwd);
            String getfeatureGetUrl = capabilities.getFeatureGetURL();
            this.addProtectedURL(authenticator, getfeatureGetUrl, user, pwd);
            String getfeaturePostUrl = capabilities.getFeaturePostURL();
            this.addProtectedURL(authenticator, getfeaturePostUrl, user, pwd);
            String featurewithlockGetUrl = capabilities.getFeatureWithLockGetURL();
            this.addProtectedURL(authenticator, featurewithlockGetUrl, user, pwd);
            String featurewithlockPostUrl = capabilities.getFeatureWithLockPostURL();
            this.addProtectedURL(authenticator, featurewithlockPostUrl, user, pwd);
            String lockfeatureGetURL = capabilities.getLockFeatureGetURL();
            this.addProtectedURL(authenticator, lockfeatureGetURL, user, pwd);
            String lockfeaturePostUrl = capabilities.getLocFeaturePostURL();
            this.addProtectedURL(authenticator, lockfeaturePostUrl, user, pwd);
            String transactionGetUrl = capabilities.getTransactionGetURL();
            this.addProtectedURL(authenticator, transactionGetUrl, user, pwd);
            String transactionPostUrl = capabilities.getTransactionPostURL();
            this.addProtectedURL(authenticator, transactionPostUrl, user, pwd);
        }
    }

    static /* synthetic */ WFSLayer access$000(WFSLayerPropertyPanel x0) {
        return x0.sessionLayer;
    }

    static /* synthetic */ boolean access$100(WFSLayerPropertyPanel x0, String x1, String x2, String x3, String x4) {
        return x0.rebuildLayerProducer(x1, x2, x3, x4);
    }
}

