/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.ui.AnnotationTextLayoutPanel;
import oracle.mdeditor.ui.TextAttributesPanel;
import oracle.mdeditor.ui.XMLPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.text.jaxb.FontStyle;
import oracle.sdovis.text.jaxb.TextAttributesType;
import oracle.sdovis.text.jaxb.TextDecoration;
import oracle.sdovis.text.jaxb.TextStyle;
import oracle.sdovis.text.jaxb.Textlayout;
import oracle.sdovis.util.StringOutputStream;

public class AnnotationTextMetadataAttrsPanel
extends JPanel {
    private static Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPBUILDER);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JTabbedPane tabPane = new JTabbedPane();
    private TextAttributesPanel style = new TextAttributesPanel();
    private AnnotationTextLayoutPanel layout = new AnnotationTextLayoutPanel();
    private XMLPanel xmlPanel = new XMLPanel();
    private JScrollPane xmlscrollPane = new JScrollPane(this.xmlPanel);
    private String defaultXML = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<textAttributes xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n                xsi:noNamespaceSchemaLocation=\"../../annotation_text.xsd\">\n  <textStyle fontFamily=\"Serif\" fontSize=\"14\" fill=\"#ff0000\"/>\n  <textlayout/>\n</textAttributes>";
    private JAXBContext jc = null;
    private Unmarshaller unmarsh = null;
    private Marshaller marsh = null;
    boolean modified = false;

    public AnnotationTextMetadataAttrsPanel(String xml) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateUI(xml);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(354, 203));
        this.setPreferredSize(new Dimension(275, 335));
        this.tabPane.add(MessagesBundle.getMessage("Style"), this.style);
        this.tabPane.add(MessagesBundle.getMessage("Layout"), this.layout);
        this.tabPane.add(MessagesBundle.getMessage("XML"), this.xmlscrollPane);
        this.add((Component)this.tabPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.tabPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AnnotationTextMetadataAttrsPanel.this.tabPane_mouseClicked(e);
            }
        });
    }

    public void allowChanges(boolean enable) {
        this.tabPane.setEnabled(enable);
        this.style.allowChanges(enable);
        this.layout.allowChanges(enable);
    }

    public void updateUI(String xml) {
        TextAttributesType txtattrs = null;
        String xmlattrs = xml;
        if (xml == null) {
            xmlattrs = this.defaultXML;
        }
        this.xmlPanel.setText(xmlattrs);
        try {
            if (this.jc == null) {
                this.jc = JAXBContext.newInstance((String)"oracle.sdovis.text.jaxb");
                this.unmarsh = this.jc.createUnmarshaller();
            }
            StringBuffer xmlStr = new StringBuffer(xmlattrs);
            JAXBElement jaxbEl = (JAXBElement)this.unmarsh.unmarshal((InputStream)new ByteArrayInputStream(xmlStr.toString().getBytes()));
            txtattrs = (TextAttributesType)jaxbEl.getValue();
            this.updateAttributes(txtattrs);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            e.printStackTrace();
            log.info(MessagesBundle.getMessage("Unable_tounmarshal_attributes"));
        }
    }

    public void updateAttributes(TextAttributesType txtattrs) {
        if (txtattrs == null) {
            return;
        }
        this.style.getFontPanel().setStyleFontName(txtattrs.getTextStyle().getFontFamily());
        this.style.getFontPanel().setStyleFontSize(txtattrs.getTextStyle().getFontSize());
        if (txtattrs.getTextStyle().getFontWeight().equalsIgnoreCase("bold") || txtattrs.getTextStyle().getFontWeight().equalsIgnoreCase("400")) {
            this.style.getFontPanel().setBoldSelected(true);
        } else {
            this.style.getFontPanel().setBoldSelected(false);
        }
        if (txtattrs.getTextStyle().getFontStyle().name().equalsIgnoreCase("italics")) {
            this.style.getFontPanel().setItalicSelected(true);
        } else {
            this.style.getFontPanel().setItalicSelected(false);
        }
        String fillColor = txtattrs.getTextStyle().getFill();
        Color fcolor = StyleUtils.getColor((String)fillColor);
        if (fcolor == null && (fcolor = StyleUtils.getColorFromRGB((String)fillColor)) == null) {
            fcolor = Color.black;
        }
        this.style.getColorPanel().setColor(fcolor);
        this.style.getColorPanel().setColorOpacity((int)(txtattrs.getTextStyle().getFillOpacity() * 255.0f));
        String strokeColor = txtattrs.getTextStyle().getStroke();
        Color scolor = StyleUtils.getColor((String)strokeColor);
        if (scolor == null) {
            scolor = StyleUtils.getColorFromRGB((String)strokeColor);
        }
        this.style.getStrokePanel().getColorPanel().setColor(scolor);
        this.style.getStrokePanel().getColorPanel().setColorOpacity((int)(txtattrs.getTextStyle().getStrokeOpacity() * 255.0f));
        this.style.getStrokePanel().setStrokeWidth(txtattrs.getTextStyle().getStrokeWidth());
        this.style.getOtherAttrPanel().setTextDecoration(txtattrs.getTextStyle().getTextDecoration().name().toUpperCase().replaceAll("_", ""));
        try {
            float ltspc = Float.parseFloat(txtattrs.getTextStyle().getLetterSpacing());
            this.style.getOtherAttrPanel().setLetterSpacing(ltspc);
        }
        catch (Exception e) {
            this.style.getOtherAttrPanel().setLetterSpacing(0.0f);
        }
        try {
            float wdspc = Float.parseFloat(txtattrs.getTextStyle().getWordSpacing());
            this.style.getOtherAttrPanel().setWordSpacing(wdspc);
        }
        catch (Exception e) {
            this.style.getOtherAttrPanel().setWordSpacing(0.0f);
        }
        if (txtattrs.getTextlayout().getHorizontalAlignment() != null) {
            this.layout.setHorizontalAllignment(txtattrs.getTextlayout().getHorizontalAlignment().toUpperCase());
        }
        if (txtattrs.getTextlayout().getVerticalAlignment() != null) {
            this.layout.setVerticalAllignment(txtattrs.getTextlayout().getVerticalAlignment().toUpperCase());
        }
        if (txtattrs.getTextlayout().getMultilineJustification() != null) {
            this.layout.setMultilineJustification(txtattrs.getTextlayout().getMultilineJustification().toUpperCase());
        }
        this.layout.setMultilineSpacing(txtattrs.getTextlayout().getMultilineSpacing());
    }

    public TextAttributesType getCurrentAttributes() {
        Color fc;
        TextAttributesType txtattrs = new TextAttributesType();
        txtattrs.setTextStyle(new TextStyle());
        txtattrs.setTextlayout(new Textlayout());
        txtattrs.getTextStyle().setFontFamily(this.style.getFontPanel().getStyleFontName());
        txtattrs.getTextStyle().setFontSize(this.style.getFontPanel().getStyleFontSize());
        if (this.style.getFontPanel().isBoldSelected()) {
            txtattrs.getTextStyle().setFontWeight("bold");
        }
        if (this.style.getFontPanel().isItalicSelected()) {
            txtattrs.getTextStyle().setFontStyle(FontStyle.ITALICS);
        }
        if ((fc = this.style.getColorPanel().getColor()) == null) {
            txtattrs.getTextStyle().setFill("black");
        } else {
            txtattrs.getTextStyle().setFill(StyleUtils.getHexidecimalString((Color)fc));
        }
        txtattrs.getTextStyle().setFillOpacity(Float.valueOf((float)this.style.getColorPanel().getColorOpacity() / 255.0f));
        Color sc = this.style.getStrokePanel().getColorPanel().getColor();
        if (sc == null) {
            txtattrs.getTextStyle().setStroke("none");
        } else {
            txtattrs.getTextStyle().setStroke(StyleUtils.getHexidecimalString((Color)sc));
            txtattrs.getTextStyle().setStrokeOpacity(Float.valueOf((float)this.style.getStrokePanel().getColorPanel().getColorOpacity() / 255.0f));
            txtattrs.getTextStyle().setStrokeWidth(Float.valueOf(this.style.getStrokePanel().getStrokeWidth()));
        }
        txtattrs.getTextStyle().setTextDecoration(this.getDecoration(this.style.getOtherAttrPanel().getTextDecoration()));
        txtattrs.getTextStyle().setLetterSpacing(String.valueOf(this.style.getOtherAttrPanel().getLetterSpacing()));
        txtattrs.getTextStyle().setWordSpacing(String.valueOf(this.style.getOtherAttrPanel().getWordSpacing()));
        txtattrs.getTextlayout().setHorizontalAlignment(this.layout.getHorizontalAllignment().toUpperCase());
        txtattrs.getTextlayout().setVerticalAlignment(this.layout.getVerticalAllignment().toUpperCase());
        txtattrs.getTextlayout().setMultilineJustification(this.layout.getMultilineJustification().toUpperCase());
        txtattrs.getTextlayout().setMultilineSpacing(Float.valueOf(this.layout.getMultilineSpacing()));
        return txtattrs;
    }

    public String getCurrentXML() {
        TextAttributesType txtattrs = this.getCurrentAttributes();
        String xml = "";
        try {
            if (this.jc == null) {
                this.jc = JAXBContext.newInstance((String)"oracle.sdovis.text.jaxb");
                this.marsh = this.jc.createMarshaller();
                this.marsh.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            } else if (this.marsh == null) {
                this.marsh = this.jc.createMarshaller();
                this.marsh.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            }
            StringOutputStream attrstream = new StringOutputStream(null);
            this.marsh.marshal((Object)new JAXBElement(new QName(null, "textAttributes"), TextAttributesType.class, (Object)txtattrs), (OutputStream)attrstream);
            xml = attrstream.getString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.info(MessagesBundle.getMessage("Unable_tomarshal_attributes"));
        }
        return xml;
    }

    private void tabPane_mouseClicked(MouseEvent e) {
        int index = this.tabPane.getSelectedIndex();
        if (index == 2) {
            this.xmlPanel.setText(this.getCurrentXML());
        }
    }

    private TextDecoration getDecoration(String decor) {
        if (decor == null) {
            return null;
        }
        if (decor.equalsIgnoreCase("Underline")) {
            return TextDecoration.UNDERLINE;
        }
        if (decor.equalsIgnoreCase("LineThrough")) {
            return TextDecoration.LINE_THROUGH;
        }
        if (decor.equalsIgnoreCase("OverLine")) {
            return TextDecoration.OVERLINE;
        }
        return TextDecoration.NONE;
    }
}

