/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.ui;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;

public class IconMarker {
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_HOVER = 1;
    public static final int MODE_SELECTED = 2;
    Image defaultIcon;
    Image hoverIcon;
    Image selectedIcon;
    ImageIcon icon = null;
    int iconWidth;
    int iconHeight;
    Point anchor;
    private static AffineTransform idTransform = new AffineTransform();

    public IconMarker(Image dftIcon) {
        this.defaultIcon = dftIcon;
        this.icon = new ImageIcon(this.defaultIcon);
        this.iconWidth = this.defaultIcon.getWidth(null);
        this.iconHeight = this.defaultIcon.getHeight(null);
        this.anchor = new Point(this.iconWidth / 2, this.iconHeight / 2);
    }

    public IconMarker(Image dftIcon, Point anchor) {
        this.defaultIcon = dftIcon;
        this.icon = new ImageIcon(this.defaultIcon);
        this.iconWidth = this.defaultIcon.getWidth(null);
        this.iconHeight = this.defaultIcon.getHeight(null);
        this.anchor = new Point((int)anchor.getX(), (int)anchor.getY());
    }

    public IconMarker(Image defaultIcon, Image hoverIcon, Image selectedIcon, Point anchor) {
        this.defaultIcon = defaultIcon;
        this.icon = new ImageIcon(defaultIcon);
        this.hoverIcon = hoverIcon;
        this.selectedIcon = selectedIcon;
        this.iconWidth = defaultIcon.getWidth(null);
        this.iconHeight = defaultIcon.getHeight(null);
        this.anchor = new Point((int)anchor.getX(), (int)anchor.getY());
    }

    public Point getAnchor() {
        return this.anchor;
    }

    public void setAnchor(Point anchor) {
        this.anchor = anchor;
    }

    public Image getDefaultIcon() {
        return this.defaultIcon;
    }

    public void setDefaultIcon(Image defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    public Image getHoverIcon() {
        return this.hoverIcon;
    }

    public void setHoverIcon(Image hoverIcon) {
        this.hoverIcon = hoverIcon;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public void setIconHeight(int iconHeight) {
        this.iconHeight = iconHeight;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public void setIconWidth(int iconWidth) {
        this.iconWidth = iconWidth;
    }

    public Image getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelectedIcon(Image selectedIcon) {
        this.selectedIcon = selectedIcon;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void draw(int x, int y, Graphics2D g, int mode) {
        Image img = this.defaultIcon;
        switch (mode) {
            case 1: {
                if (this.hoverIcon == null) break;
                img = this.hoverIcon;
                break;
            }
            case 2: {
                if (this.selectedIcon == null) break;
                img = this.selectedIcon;
            }
        }
        int startX = x - this.anchor.x;
        int startY = y - this.anchor.y;
        AffineTransform xfmOld = g.getTransform();
        g.setTransform(idTransform);
        g.drawImage(img, startX, startY, null);
        g.setTransform(xfmOld);
    }

    public Rectangle2D getMBRForLocation(int x, int y) {
        return new Rectangle2D.Double(x - this.anchor.x, y - this.anchor.y, this.iconWidth, this.iconHeight);
    }
}

