/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.core;

import java.awt.Component;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.layer.MVImageLayer;
import oracle.maps.util.PropertySupportObject;
import oracle.mapviewer.share.MVThemeMetadata;
import oracle.mapviewer.share.MVTileLayerMetadata;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.session.layer.LayerProvider;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.session.MDSEditSession;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MVImageLayerProvider
implements LayerProvider {
    public static final int TYPE_PREDEFINED_THEME = 0;
    public static final int TYPE_BASE_MAP = 1;
    public static final int TYPE_TILE_CACHE = 2;
    protected MainAppPanel mainApp = null;
    protected int type = 0;
    protected AbstractDataSource dataSource = null;
    protected Vector<Object> cache = null;
    protected TreeCellRenderer cellRenderer = new MyTreeCellRenderer();

    public MVImageLayerProvider(int type, MainAppPanel mainApp, AbstractDataSource dataSource) {
        this.type = type;
        this.mainApp = mainApp;
        this.dataSource = dataSource;
    }

    @Override
    public Layer createLayer(Element xmlElement) {
        Layer layer = null;
        String className = xmlElement.getAttribute("class");
        if (className != null && !className.trim().isEmpty()) {
            try {
                Constructor<?> c = Class.forName(className).getConstructor(MapCanvas.class);
                layer = (Layer)c.newInstance(new Object[]{null});
                layer.fromXMLElement(xmlElement);
            }
            catch (InvocationTargetException ex) {
                ex.getTargetException().printStackTrace();
                System.err.println("on " + className);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("on " + className);
            }
        }
        return layer;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public String getProviderName() {
        switch (this.type) {
            case 0: {
                return "Predefined Themes";
            }
            case 1: {
                return "Base Maps";
            }
            case 2: {
                return "Tile Cache";
            }
        }
        return null;
    }

    public Object[] getEditorObjects() {
        this.fetchMetadata();
        if (this.cache == null) {
            return null;
        }
        return this.cache.toArray();
    }

    @Override
    public Layer getEditorObject(TreePath path) {
        return null;
    }

    @Override
    public Layer removeEditorObject(TreePath layerDesc) {
        return null;
    }

    public Layer getEditorObject(Object layerDesc) {
        return this.createLayer(layerDesc);
    }

    public void clearEditorObjectCache() {
        this.cache = null;
    }

    @Override
    public TreeCellRenderer getTreeCellRenderer() {
        return this.cellRenderer;
    }

    private Layer createLayer(Object desc) {
        if (this.dataSource == null) {
            return null;
        }
        String className = MVImageLayer.class.getCanonicalName();
        PropertySupportObject props = new PropertySupportObject(this);
        props.setProperty("oracle.lbs.mapviewer.serverURL", this.dataSource.getConnectionProperties().getProperty("serverURL") + "/omserver");
        props.setProperty("oracle.lbs.mapviewer.dataSource", this.dataSource.getConnectionProperties().getProperty("dataSource"));
        if (this.type == 0 && desc instanceof MVThemeMetadata) {
            MVThemeMetadata themeMeta = (MVThemeMetadata)desc;
            props.setProperty("oracle.maps.core.Layer.name", themeMeta.getName());
            props.setProperty("themeName", themeMeta.getName());
            props.setProperty("type", themeMeta.getType());
            props.setProperty("baseTable", themeMeta.getBaseTable());
            props.setProperty("oracle.maps.core.Layer.srid", Integer.toString(themeMeta.getSRID()));
            props.setProperty("spatialColumn", themeMeta.getSpatialColumn());
            props.setProperty("xmax", Double.toString(themeMeta.getXMax()));
            props.setProperty("xmin", Double.toString(themeMeta.getXMin()));
            props.setProperty("xtol", Double.toString(themeMeta.getXTolerance()));
            props.setProperty("ymax", Double.toString(themeMeta.getYMax()));
            props.setProperty("ymin", Double.toString(themeMeta.getYMin()));
            props.setProperty("ytol", Double.toString(themeMeta.getYTolerance()));
        } else if (this.type == 1 && desc instanceof MVBaseMapMetadata) {
            MVBaseMapMetadata mapMeta = (MVBaseMapMetadata)desc;
            props.setProperty("oracle.maps.core.Layer.name", mapMeta.getName());
            props.setProperty("baseMap", mapMeta.getName());
            props.setProperty("oracle.maps.core.Layer.srid", Integer.toString(mapMeta.getSRID()));
        } else if (this.type == 2 && desc instanceof MVTileLayerMetadata) {
            MVTileLayerMetadata tileMeta = (MVTileLayerMetadata)desc;
            props.setProperty("oracle.maps.core.Layer.name", tileMeta.getName());
            props.setProperty("tileName", tileMeta.getName());
            props.setProperty("type", Integer.toString(tileMeta.getType()));
            props.setProperty("oracle.maps.core.Layer.srid", Integer.toString(tileMeta.getSRID()));
            props.setProperty("xmax", Double.toString(tileMeta.getMaxX()));
            props.setProperty("xmin", Double.toString(tileMeta.getMinX()));
            props.setProperty("ymax", Double.toString(tileMeta.getMaxY()));
            props.setProperty("ymin", Double.toString(tileMeta.getMinY()));
            props.setProperty("zoomlevels", Integer.toString(tileMeta.getNumberOfZoomLevels()));
        }
        if (className != null) {
            XMLDocument doc = new XMLDocument();
            doc.setXmlVersion("1.0");
            Element root = doc.createElement("layer");
            root.setAttribute("class", className);
            if (props.size() > 0) {
                try {
                    Element propsElem = props.toXMLElement();
                    if (propsElem != null) {
                        root.appendChild(doc.adoptNode((Node)propsElem));
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (SAXException ex) {
                    ex.printStackTrace();
                }
            }
            MVImageLayer il = (MVImageLayer)this.createLayer(root);
            if (this.type == 1 && desc instanceof MVBaseMapMetadata) {
                il.setBaseMapThemes(((MVBaseMapMetadata)desc).getThemes());
            }
            return il;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchMetadata() {
        if (this.cache == null) {
            if (this.dataSource == null) {
                return;
            }
            AbstractDataAccessObject dataAccess = this.dataSource.getDataAccessObject();
            try {
                Vector<MVThemeMetadata> mvThemes;
                dataAccess.openConnection();
                if (this.type == 0) {
                    mvThemes = dataAccess.getMapViewerThemesMetadata();
                    this.cache = new Vector<MVThemeMetadata>(mvThemes);
                } else if (this.type == 1) {
                    mvThemes = dataAccess.getMapViewerThemesMetadata();
                    Hashtable<String, MVThemeMetadata> themesTable = new Hashtable<String, MVThemeMetadata>(mvThemes.size());
                    for (MVThemeMetadata theme : mvThemes) {
                        themesTable.put(theme.getName(), theme);
                    }
                    Vector<String> mvBaseMaps = dataAccess.getMapViewerBaseMaps();
                    this.cache = new Vector();
                    for (String baseMap : mvBaseMaps) {
                        String[] mapThemeNames = dataAccess.getMapViewerBasemapThemeNames(baseMap);
                        Vector<MVThemeMetadata> mapThemes = new Vector<MVThemeMetadata>(mapThemeNames.length);
                        for (String themeName : mapThemeNames) {
                            MVThemeMetadata theme = (MVThemeMetadata)themesTable.get(themeName);
                            if (theme == null) continue;
                            mapThemes.add(theme);
                        }
                        MVBaseMapMetadata meta = new MVBaseMapMetadata(baseMap, mapThemes);
                        this.cache.add(meta);
                    }
                } else if (this.type == 2) {
                    Vector<MVTileLayerMetadata> mvTileLayers = dataAccess.getMapViewerTileLayersMetadata();
                    this.cache = new Vector<MVTileLayerMetadata>(mvTileLayers);
                }
            }
            catch (MDSException ex) {
                return;
            }
            catch (Exception ex) {
                return;
            }
            finally {
                if (dataAccess != null) {
                    try {
                        dataAccess.closeConnection();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getProviderRootNode() {
        return null;
    }

    @Override
    public TreeExpansionListener getTreeExpansionListener() {
        return null;
    }

    @Override
    public TreeWillExpandListener getTreeWillExpandListener() {
        return null;
    }

    @Override
    public TreeSelectionListener getTreeSelectionListener() {
        return null;
    }

    @Override
    public MouseListener getMouseListener() {
        return null;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return null;
    }

    @Override
    public MouseWheelListener getMouseWheelListener() {
        return null;
    }

    private class MVBaseMapMetadata {
        private String name = null;
        private Vector<MVThemeMetadata> themes = null;

        public MVBaseMapMetadata(String name, Vector<MVThemeMetadata> themes) {
            this.name = name;
            this.themes = themes;
        }

        public String getName() {
            return this.name;
        }

        public Vector<MVThemeMetadata> getThemes() {
            return this.themes;
        }

        public int getSRID() {
            if (this.themes != null && this.themes.size() > 0) {
                return this.themes.get(0).getSRID();
            }
            return 0;
        }
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            JLabel label = null;
            if (obj == MVImageLayerProvider.this) {
                label = (JLabel)super.getTreeCellRendererComponent(tree, obj, selected, expanded, false, row, hasFocus);
                label.setText(MVImageLayerProvider.this.getProviderName());
            } else {
                Object meta;
                label = (JLabel)super.getTreeCellRendererComponent(tree, obj, selected, expanded, leaf, row, hasFocus);
                String icon = null;
                String name = null;
                int srid = -1;
                if (obj instanceof MVThemeMetadata) {
                    meta = (MVThemeMetadata)obj;
                    name = meta.getName();
                    srid = meta.getSRID();
                    icon = "theme.gif";
                } else if (obj instanceof MVTileLayerMetadata) {
                    meta = (MVTileLayerMetadata)obj;
                    name = meta.getName();
                    srid = meta.getSRID();
                    icon = "image_theme.png";
                } else if (obj instanceof MVBaseMapMetadata) {
                    meta = (MVBaseMapMetadata)obj;
                    name = ((MVBaseMapMetadata)meta).getName();
                    srid = ((MVBaseMapMetadata)meta).getSRID();
                    icon = "basemap.png";
                }
                int sessionSRID = 0;
                EditSession ed = MVImageLayerProvider.this.mainApp.getEditSessionPanel().getEditSession();
                if (ed instanceof MDSEditSession) {
                    sessionSRID = ((MDSEditSession)ed).getSRID();
                }
                if (sessionSRID != 0 && sessionSRID != srid && srid > 0 && srid != 262148) {
                    icon = "error.png";
                }
                label.setIcon(Icons.getIcon(icon));
                label.setText(name + " [" + srid + "]");
            }
            return label;
        }
    }
}

