/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime.ess;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class ContentHints
implements ASN1Object {
    private ASN1ObjectID contentType;
    private String contentDescription;
    private ASN1Sequence contents;

    public ContentHints(InputStream is) throws IOException {
        this.input(is);
        this.contents = null;
    }

    public ContentHints(ASN1ObjectID contentType) {
        this.contentType = contentType;
        this.contentDescription = null;
        this.contents = null;
    }

    public ContentHints(ASN1ObjectID contentType, String contentDescription) {
        this.contentType = contentType;
        this.contentDescription = contentDescription;
        this.contents = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ContentHints)) {
            return false;
        }
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)((ContentHints)o)));
    }

    public int hashCode() {
        return new String(Utils.toBytes((Streamable)this)).hashCode();
    }

    public ASN1ObjectID getContentType() {
        return this.contentType;
    }

    public void setContentType(ASN1ObjectID contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("Null Content Type Specified");
        }
        this.contentType = contentType;
        this.contents = null;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public void setContentDescription(String contentDescription) {
        this.contentDescription = contentDescription;
        this.contents = null;
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        this.contentDescription = seq.getCurrentTag() == 12 ? ASN1String.inputValue((InputStream)seq) : null;
        this.contentType = new ASN1ObjectID((InputStream)seq);
        seq.terminate();
        this.contents = null;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            if (this.contentDescription != null && this.contentDescription.length() > 0) {
                seq.addElement((ASN1Object)new ASN1String(this.contentDescription, 12));
            }
            seq.addElement((ASN1Object)this.contentType);
            this.contents = seq;
        }
        return this.contents;
    }
}

