/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.secrets;

import java.util.Arrays;
import java.util.concurrent.Callable;
import oracle.dbtools.core.secrets.BinarySecret;
import oracle.dbtools.core.secrets.TextSecretImpl;

public interface TextSecret
extends AutoCloseable {
    public static TextSecret copyOf(TextSecret existing) {
        if (existing == null) {
            return TextSecret.none();
        }
        return TextSecret.of(existing.asSecret());
    }

    public static void erase(char[] chars) {
        if (chars != null) {
            int length = chars.length;
            if (length > 0) {
                chars[0] = '\u0000';
            }
            for (int pos = 1; pos < length; pos += pos) {
                System.arraycopy(chars, 0, chars, pos, Math.min(length - pos, pos));
            }
        }
    }

    public static TextSecret none() {
        return TextSecretImpl.none();
    }

    public static TextSecret of(BinarySecret secret) {
        return TextSecretImpl.of(secret);
    }

    public BinarySecret asSecret();

    @Override
    public void close();

    public boolean isPresent();

    default public <T> T map(Mapper<T> mapper) {
        BinarySecret secret = this.asSecret();
        return (T)secret.map((byte[] bytes) -> {
            char[] text = secret.map(TextSecretImpl::asCharacters);
            try {
                Object t = mapper.apply(text);
                return t;
            }
            finally {
                TextSecret.erase(text);
            }
        });
    }

    default public <T> T mapOrElse(Mapper<T> mapper, Callable<T> action) {
        BinarySecret secret = this.asSecret();
        return (T)secret.mapOrElse((byte[] bytes) -> {
            char[] text = secret.map(TextSecretImpl::asCharacters);
            try {
                Object t = mapper.apply(text);
                return t;
            }
            finally {
                TextSecret.erase(text);
            }
        }, action);
    }

    default public void set(Setter<String> setter) {
        this.map(text -> {
            String string = new String(text);
            setter.accept(string);
            return null;
        });
    }

    default public void setChars(Setter<char[]> setter, boolean duplicate) {
        this.map(text -> {
            char[] copy = duplicate ? Arrays.copyOf(text, text.length) : text;
            setter.accept(copy);
            return null;
        });
    }

    @FunctionalInterface
    public static interface Setter<T> {
        public void accept(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Mapper<T> {
        public T apply(char[] var1) throws Exception;
    }
}

