/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.helpers;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import oracle.dbtools.core.connections.ConnectionsResources;
import oracle.dbtools.core.connections.helpers.ProductConnectDetails;
import oracle.jdbc.datasource.OracleDataSource;

public interface ConnectionHelper {
    public static final String UNKNOWN_TYPE = "UNKNOWN";

    public static DisplayEntry displayEntry(String key, String value, boolean useNewLine) {
        return new DisplayEntry(key, value, useNewLine);
    }

    public Collection<DisplayEntry> getDisplayProperties();

    public void completeConnectionDetails(ProductConnectDetails var1);

    public String getConnectionSpec();

    public String getURL();

    default public void configureDataSource(OracleDataSource datasource) throws SQLException {
    }

    default public boolean requiresProxySession() {
        return false;
    }

    default public Connection createProxySession(Connection conn) throws SQLException {
        throw new SQLException(ConnectionsResources.getString("ERROR_UNSUPPORTED_PROXY_SESSION"));
    }

    public static final class DisplayEntry {
        private static final String SINGLE_LINE = "{0}: {1}";
        private static final String TWO_LINE = "{0}:\n  {1}";
        private final String key;
        private final String value;
        private final boolean useNewLine;

        private DisplayEntry(String key, String value, boolean useNewLine) {
            this.key = key;
            this.value = value;
            this.useNewLine = useNewLine;
        }

        public String getDisplayOutput() {
            return MessageFormat.format(this.useNewLine ? TWO_LINE : SINGLE_LINE, this.key, this.value);
        }
    }
}

