/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import oracle.dbtools.crest.util.gui.swing.JNumericField;

public class JIntegerField
extends JNumericField {
    private boolean allowAsterisks = false;

    public JIntegerField() {
        this.setDocument(new IntegerDocument());
    }

    public JIntegerField(int value, int columns) {
        this.setDocument(new IntegerDocument());
        this.setColumns(columns);
        this.setValue((long)value);
    }

    public void setLargeIntegerDocument(int maxDigits) {
        this.setDocument(new LargeIntegerDocument(maxDigits));
    }

    public int getIntValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public long getLongValue() {
        try {
            return Long.parseLong(this.getText());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public void setValue(Integer value) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(Integer.toString(value));
        }
    }

    public void setValue(long value) {
        this.setText(Long.toString(value));
    }

    public boolean isAllowAsterisks() {
        return this.allowAsterisks;
    }

    public void setAllowAsterisks(boolean allowAsterisks) {
        this.allowAsterisks = allowAsterisks;
    }

    class IntegerDocument
    extends JNumericField.NumericDocument {
        IntegerDocument() {
            super(JIntegerField.this);
        }

        @Override
        public boolean validateValue(String value) throws NumberFormatException {
            if ("*".equals(value) && JIntegerField.this.allowAsterisks) {
                return true;
            }
            Integer.parseInt(value);
            return true;
        }
    }

    class LargeIntegerDocument
    extends JNumericField.NumericDocument {
        int maxDigits;

        public LargeIntegerDocument(int maxDigits) {
            super(JIntegerField.this);
            this.maxDigits = 38;
            this.maxDigits = maxDigits;
        }

        @Override
        public boolean validateValue(String value) throws NumberFormatException {
            Double.parseDouble(value);
            return value.indexOf(".") == -1 && !value.endsWith("F") && !value.endsWith("f") && value.length() <= this.maxDigits;
        }
    }
}

