/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.storage.distincttype;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.udb.DistinctTypeSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.DistinctTypeUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.storage.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DistinctTypesDialogUDB
extends CustomDialog {
    protected JPanel general;
    protected StorageDesignUDB storageDesign;
    private DefaultListModel allDomainsModel;
    private DefaultListModel selectedDomainsModel;
    private JList allDomainsList;
    private JList selectedDomainsList;
    private JButton bnAdd;
    private JButton bnRemove;
    protected JDialog dialog;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();

    public DistinctTypesDialogUDB(ApplicationView view, StorageDesignUDB storageDesign) {
        super(view);
        this.storageDesign = storageDesign;
        this.storageDesign.setDtDialogVisible(true);
        this.general = new JPanel();
        this.general.setLayout(new BoxLayout(this.general, 2));
        this.general.setPreferredSize(new Dimension(430, 270));
        this.initGeneralView();
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)this.general, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(Messages.getString("DistinctTypesDialogUDB.OK"));
        bnOK.addActionListener(new OKAction());
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setMnemonic(79);
        bottomPanel.add(bnOK);
        JButton bnApply = new JButton(Messages.getString("DistinctTypesDialogUDB.Apply"));
        bnApply.addActionListener(new ApplyAction());
        bnApply.setCursor(Cursor.getPredefinedCursor(12));
        bnApply.setMnemonic(65);
        bottomPanel.add(bnApply);
        JButton bnCancel = new JButton(Messages.getString("DistinctTypesDialogUDB.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        bottomPanel.add(bnCancel);
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jpanel.add((Component)bottomPanel, "South");
        this.storageDesign.setDtDialogVisible(true);
        this.add((Component)jpanel, "Center");
    }

    protected void initGeneralView() {
        this.initAllDomainsList();
        this.initButtons();
        this.initDistinctTypesList();
    }

    private void initAllDomainsList() {
        this.allDomainsModel = new DefaultListModel();
        this.allDomainsList = new JList(this.allDomainsModel);
        ListSelectionModel listSelectionModel = this.allDomainsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allDomainsList);
        sp.setBorder(BorderFactory.createTitledBorder(Messages.getString("DistinctTypesDialogUDB.Domains")));
        sp.setPreferredSize(new Dimension(200, 180));
        this.general.add(sp);
    }

    private void initDistinctTypesList() {
        this.selectedDomainsModel = new DefaultListModel();
        this.selectedDomainsList = new JList(this.selectedDomainsModel);
        ListSelectionModel listSelectionModel = this.selectedDomainsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedDomainsList);
        sp.setBorder(BorderFactory.createTitledBorder(Messages.getString("DistinctTypesDialogUDB.DistinctTypes")));
        sp.setPreferredSize(new Dimension(200, 180));
        this.general.add(sp);
    }

    private void initButtons() {
        this.bnAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.bnAdd.setToolTipText(Messages.getString("DistinctTypesDialogUDB.Add"));
        this.bnAdd.addActionListener(new AddDomainsActionListener());
        this.bnAdd.setEnabled(false);
        this.bnRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.bnRemove.setToolTipText(Messages.getString("DistinctTypesDialogUDB.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveDomainsActionListener());
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.bnAdd);
        verticalBox.add(this.bnRemove);
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.setPreferredSize(new Dimension(30, 180));
        this.general.add(verticalBox);
    }

    protected void setLabelConstraints(SpringLayout layout, JLabel label, int x, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(label);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(SpringLayout layout, Component c, int x, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    public void initProperties() {
        Iterator domains = this.storageDesign.getDesign().getDomainSet().iterator();
        DistinctTypeSetUDB types = this.storageDesign.getDistinctTypeSet();
        while (domains.hasNext()) {
            Domain dom = (Domain)domains.next();
            if (types.getDistinctType(dom) != null) {
                this.selectedDomainsModel.addElement(dom);
                continue;
            }
            if ("Unknown".equalsIgnoreCase(dom.getName())) continue;
            this.allDomainsModel.addElement(dom);
        }
    }

    protected void setProperties() {
        Object[] selectedDomains = this.selectedDomainsModel.toArray();
        this.storageDesign.getDistinctTypeSet().removeAll();
        DistinctTypeUDB type = null;
        for (int i = 0; i < selectedDomains.length; ++i) {
            Domain dom = (Domain)selectedDomains[i];
            type = this.storageDesign.getDistinctTypeSet().createDistinctType();
            type.setName(dom.getName());
            type.setDomain(dom.getName());
            type.setDirty(true);
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("DistinctTypesDialogUDB.DistinctTypes"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
        this.storageDesign.setDtDialogVisible(false);
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DistinctTypesDialogUDB.this.setProperties();
            DistinctTypesDialogUDB.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DistinctTypesDialogUDB.this.setProperties();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DistinctTypesDialogUDB.this.close();
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (DistinctTypesDialogUDB.this.allDomainsList.getSelectedIndex() == -1) {
                    DistinctTypesDialogUDB.this.bnAdd.setEnabled(false);
                } else {
                    DistinctTypesDialogUDB.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (DistinctTypesDialogUDB.this.selectedDomainsList.getSelectedIndex() == -1) {
                    DistinctTypesDialogUDB.this.bnRemove.setEnabled(false);
                } else {
                    DistinctTypesDialogUDB.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AddDomainsActionListener
    implements ActionListener {
        private AddDomainsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DistinctTypesDialogUDB.this.allDomainsModel.isEmpty()) {
                Object[] selectedObjects = DistinctTypesDialogUDB.this.allDomainsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (DistinctTypesDialogUDB.this.selectedDomainsModel.contains(ob)) continue;
                    DistinctTypesDialogUDB.this.selectedDomainsModel.addElement(ob);
                    DistinctTypesDialogUDB.this.allDomainsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveDomainsActionListener
    implements ActionListener {
        private RemoveDomainsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DistinctTypesDialogUDB.this.selectedDomainsModel.isEmpty()) {
                Object[] selectedObjects = DistinctTypesDialogUDB.this.selectedDomainsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (DistinctTypesDialogUDB.this.allDomainsModel.contains(ob)) continue;
                    DistinctTypesDialogUDB.this.allDomainsModel.addElement(ob);
                    DistinctTypesDialogUDB.this.selectedDomainsModel.removeElement(ob);
                }
            }
        }
    }
}

