/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.multidimensional;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GlassComponent;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDiagramCell;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;
import oracle.dbtools.crest.swingui.multidimensional.Messages;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;
import oracle.dbtools.crest.swingui.search.SearchPanel;
import oracle.dbtools.crest.util.GUID;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;

public class ControllerMultidimensional
extends AbstractController {
    private final String[] OBJECT_MDD_PATH = new String[]{AbstractController.OBJECT_CAPTION, AbstractController.MDD_CAPTION};
    private DockStation dockStation = null;
    private DesignPartView dpv = null;
    private Select select;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;
    private FitScreen fitScreen;
    private ActualSize actualSize;
    private Search search;
    private MDObjectCollector collector = null;
    private NewCube newCube;
    private NewDimension newDimension;
    private NewLevel newLevel;
    private NewLink newLink;
    private NewRaggedHLink newRaggedHLink;
    private NewNote newNote;
    private NewImage newImage;
    private Delete delete;

    public ControllerMultidimensional(ApplicationView applicationView) {
        super(applicationView);
    }

    public JMenu getObjectMultidimensionalMenu() {
        return this.getApplicationView().getControllerSet().getMenuStructure().get(this.OBJECT_MDD_PATH);
    }

    @Override
    public void initializeActions() {
        if (this.isEditable()) {
            this.select = new Select();
            this.newCube = new NewCube();
            this.newDimension = new NewDimension();
            this.newLevel = new NewLevel();
            this.newLink = new NewLink();
            this.newRaggedHLink = new NewRaggedHLink();
            this.newNote = new NewNote();
            this.newImage = new NewImage();
            this.delete = new Delete();
            this.add(this.select);
            this.add(this.newCube);
            this.add(this.newDimension);
            this.add(this.newLevel);
            this.add(this.newLink);
            this.add(this.newRaggedHLink);
            this.add(this.newNote);
            this.add(this.newImage);
            this.add(this.delete);
        }
        this.zoomIn = new ZoomIn();
        this.add(this.zoomIn);
        this.zoomOut = new ZoomOut();
        this.add(this.zoomOut);
        this.fitScreen = new FitScreen();
        this.add(this.fitScreen);
        this.actualSize = new ActualSize();
        this.add(this.actualSize);
        this.search = new Search();
        this.add(this.search);
    }

    @Override
    public void select_SelectAction() {
        if (this.collector != null) {
            this.collector.stopWaiting();
        }
        this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
        this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
    }

    public Select getSelectAction() {
        return this.select;
    }

    public NewCube getNewCubeAction() {
        return this.newCube;
    }

    public NewDimension getNewDimensionAction() {
        return this.newDimension;
    }

    public NewLevel getNewLevelAction() {
        return this.newLevel;
    }

    public NewLink getNewLinkAction() {
        return this.newLink;
    }

    public NewRaggedHLink getNewRaggedHLinkAction() {
        return this.newRaggedHLink;
    }

    public NewNote getNewNoteAction() {
        return this.newNote;
    }

    public NewImage getNewImageAction() {
        return this.newImage;
    }

    public Delete getDeleteAction() {
        return this.delete;
    }

    public ZoomIn getZoomInAction() {
        return this.zoomIn;
    }

    public ZoomOut getZoomOutAction() {
        return this.zoomOut;
    }

    public FitScreen getFitScreenAction() {
        return this.fitScreen;
    }

    public ActualSize getDefaultSizeAction() {
        return this.actualSize;
    }

    @Override
    public MDBAction getFindAction() {
        return this.search;
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerMultidimensional.Multidimensional");
    }

    @Override
    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    @Override
    public void setDesignPartView(DesignPartView dpv) {
        this.dpv = dpv;
    }

    @Override
    public void updateActions() {
        boolean enabled = true;
        if (this.getDesign().isLoadFromDB() && this.getDesignPartView().getDesignPart().getRepositoryOID() != null) {
            enabled = this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }
        this.getDesignPartView().getWorkSpace().updateReadOnlyStatus();
        this.setEnabled(this.newCube, enabled);
        this.setEnabled(this.newDimension, enabled);
        this.setEnabled(this.newLevel, enabled);
        this.setEnabled(this.newLink, enabled);
        this.setEnabled(this.newRaggedHLink, enabled);
        this.setEnabled(this.newNote, enabled);
        this.setEnabled(this.newImage, enabled);
        this.setEnabled(this.delete, enabled);
    }

    @Override
    public boolean canPaste() {
        for (Object obj : this.getApplicationView().getCopiedObjects()) {
            if (obj == null || !(obj instanceof Cube) && !(obj instanceof Level) && !(obj instanceof Dimension) && !(obj instanceof Note) && !(obj instanceof ImageObject)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paste(Point pt) {
        if (this.canPaste()) {
            try {
                ApplicationView.canLogging = false;
                int xx = 0;
                int yy = 0;
                HashMap<DesignObject, TopView> map = new HashMap<DesignObject, TopView>();
                for (TopView tv : this.getApplicationView().getCopiedTopViews()) {
                    DesignObject dob = tv.getModel();
                    if (dob == null) continue;
                    map.put(dob, tv);
                }
                Iterator it = this.getApplicationView().getCopiedObjects().iterator();
                HashMap<String, Cube> copiedMap = new HashMap<String, Cube>();
                while (it.hasNext()) {
                    TopView ctv;
                    TopView topView;
                    Object obj = it.next();
                    if (!(obj instanceof DesignObject)) continue;
                    DesignObject copied = (DesignObject)obj;
                    TopView tv = (TopView)map.get(copied);
                    DesignObject newObj = null;
                    if (obj instanceof Cube) {
                        ApplicationView.log(Messages.getString("ControllerMultidimensional.CreateCube"));
                        newObj = ((MultidimensionalDesign)this.getDesignPartView().getDesignPart()).createCube();
                        copiedMap.put(copied.getObjectID(), (Cube)newObj);
                        ((Cube)copied).copy(newObj, copiedMap);
                        TopView topView2 = this.getDesignPartView().getViewFor(newObj);
                        if (topView2 != null && topView2.getCellView() != null) {
                            tv.copy(topView2);
                        }
                    } else if (obj instanceof Level) {
                        ApplicationView.log(Messages.getString("ControllerMultidimensional.CreateLevel"));
                        newObj = ((MultidimensionalDesign)this.getDesignPartView().getDesignPart()).createLevel();
                        copiedMap.put(copied.getObjectID(), (Cube)newObj);
                        ((Level)copied).copy(newObj);
                        TopView topView3 = this.getDesignPartView().getViewFor(newObj);
                        if (topView3 != null && topView3.getCellView() != null) {
                            tv.copy(topView3);
                        }
                    } else if (obj instanceof Dimension) {
                        ApplicationView.log(Messages.getString("ControllerMultidimensional.CreateDimension"));
                        newObj = ((MultidimensionalDesign)this.getDesignPartView().getDesignPart()).createDimension();
                        copiedMap.put(copied.getObjectID(), (Cube)newObj);
                        ((Dimension)copied).copy(newObj, copiedMap);
                        TopView topView4 = this.getDesignPartView().getViewFor(newObj);
                        if (topView4 != null && topView4.getCellView() != null) {
                            tv.copy(topView4);
                        }
                    } else if (obj instanceof Note) {
                        ApplicationView.log(Messages.getString("ControllerMultidimensional.CreateNote"));
                        newObj = ((MultidimensionalDesign)this.getDesignPartView().getDesignPart()).createNote();
                        copied.copy(newObj);
                    } else if (obj instanceof ImageObject) {
                        ApplicationView.log(Messages.getString("ControllerMultidimensional.CreateImage"));
                        newObj = ((MultidimensionalDesign)this.getDesignPartView().getDesignPart()).createImage();
                        copied.copy(newObj);
                    }
                    if (newObj == null || (topView = this.getDesignPartView().getViewFor(newObj)) == null || topView.getCellView() == null || (ctv = copied.getTopView()) == null || ctv.getCellView() == null) continue;
                    Rectangle r = new Rectangle(ctv.getCellView().getBounds().getBounds());
                    Point2D pp = null;
                    if (pt != null) {
                        pp = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(pt.x, pt.y));
                    }
                    if (pp != null) {
                        r.x = (int)pp.getX() + xx;
                        r.y = (int)pp.getY() + yy;
                    } else {
                        r.x += 30 + xx;
                        r.y += 30 + yy;
                    }
                    topView.getCellView().setNewBounds(r);
                    xx += 20;
                    yy += 20;
                    if (!(obj instanceof Note)) continue;
                    ctv.copy(topView);
                }
                if (copiedMap != null) {
                    for (Object obj : this.getApplicationView().getCopiedObjects()) {
                        RollupLink rl;
                        Link newLink;
                        AbstractMDTV newTargetTV;
                        AbstractMDTV newSourceTV;
                        DesignObject parent;
                        DesignObject child;
                        if (obj instanceof Level) {
                            RaggedHLink newRaggedHLink;
                            Level level = (Level)obj;
                            Level newLevel = (Level)copiedMap.get(level.getObjectID());
                            for (RaggedHLink raggedHLink : level.getRaggedHLinks()) {
                                newRaggedHLink = this.getDesign().getMultidimensionalDesign().createRaggedHLink();
                                raggedHLink.copy(newRaggedHLink);
                                newRaggedHLink.getChildToParentAttributes().addAll(raggedHLink.getChildToParentAttributes());
                                child = newLevel;
                                parent = raggedHLink.getParentLevel();
                                newSourceTV = (AbstractMDTV)child.getFirstViewForDPV(this.dpv);
                                newTargetTV = (AbstractMDTV)parent.getFirstViewForDPV(this.dpv);
                                newRaggedHLink.setSourceTV(newSourceTV);
                                newRaggedHLink.setTargetTV(newTargetTV);
                                ((TVRaggedHLink)newRaggedHLink.getViewFor(this.dpv)).addConnection();
                            }
                            for (RaggedHLink raggedHLink : level.getInputRaggedHLinks()) {
                                newRaggedHLink = this.getDesign().getMultidimensionalDesign().createRaggedHLink();
                                raggedHLink.copy(newRaggedHLink);
                                newRaggedHLink.getChildToParentAttributes().addAll(raggedHLink.getChildToParentAttributes());
                                child = raggedHLink.getChildLevel();
                                parent = newLevel;
                                newSourceTV = (AbstractMDTV)child.getFirstViewForDPV(this.dpv);
                                newTargetTV = (AbstractMDTV)parent.getFirstViewForDPV(this.dpv);
                                newRaggedHLink.setSourceTV(newSourceTV);
                                newRaggedHLink.setTargetTV(newTargetTV);
                                ((TVRaggedHLink)newRaggedHLink.getViewFor(this.dpv)).addConnection();
                            }
                            for (Link link : level.getOutgoingLinks()) {
                                newLink = this.getDesign().getMultidimensionalDesign().createLink();
                                link.copy(newLink);
                                child = newLevel;
                                parent = link.getTargetObject();
                                newSourceTV = (AbstractMDTV)child.getFirstViewForDPV(this.dpv);
                                newTargetTV = (AbstractMDTV)parent.getFirstViewForDPV(this.dpv);
                                newLink.setSourceTV(newSourceTV);
                                newLink.setTargetTV(newTargetTV);
                                rl = newLink.getRollupLink();
                                if (rl != null) {
                                    newLink.getRollupLink().setFactEntity(link.getRollupLink().getFactEntity());
                                    newLink.getRollupLink().setSparseDimension(link.getRollupLink().isSparseDimension());
                                    newLink.getRollupLink().setDefaultAggregationOperator(link.getRollupLink().getDefaultAggregationOperator());
                                }
                                ((TVLink)newLink.getViewFor(this.dpv)).addConnection();
                            }
                            for (Link link : level.getIncomingLinks()) {
                                newLink = this.getDesign().getMultidimensionalDesign().createLink();
                                link.copy(newLink);
                                child = link.getSourceObject();
                                parent = newLevel;
                                newSourceTV = (AbstractMDTV)child.getFirstViewForDPV(this.dpv);
                                newTargetTV = (AbstractMDTV)parent.getFirstViewForDPV(this.dpv);
                                newLink.setSourceTV(newSourceTV);
                                newLink.setTargetTV(newTargetTV);
                                rl = newLink.getRollupLink();
                                if (rl != null) {
                                    newLink.getRollupLink().setFactEntity(link.getRollupLink().getFactEntity());
                                    newLink.getRollupLink().setSparseDimension(link.getRollupLink().isSparseDimension());
                                    newLink.getRollupLink().setDefaultAggregationOperator(link.getRollupLink().getDefaultAggregationOperator());
                                }
                                ((TVLink)newLink.getViewFor(this.dpv)).addConnection();
                            }
                            continue;
                        }
                        if (obj instanceof Cube) {
                            Cube cube = (Cube)obj;
                            Cube newCube = (Cube)copiedMap.get(cube.getObjectID());
                            for (RollupLink rollupLink : cube.getDimensioinsUsage()) {
                                newLink = this.getDesign().getMultidimensionalDesign().createLink();
                                rollupLink.copy(newLink);
                                child = newCube;
                                parent = rollupLink.getLink().getTargetObject();
                                newSourceTV = (AbstractMDTV)child.getFirstViewForDPV(this.dpv);
                                newTargetTV = (AbstractMDTV)parent.getFirstViewForDPV(this.dpv);
                                newLink.setSourceTV(newSourceTV);
                                newLink.setTargetTV(newTargetTV);
                                rl = newLink.getRollupLink();
                                if (rl != null) {
                                    newLink.getRollupLink().setRolePlaying(rollupLink.isRolePlaying());
                                    newLink.getRollupLink().setFactEntity(rollupLink.getFactEntity());
                                    newLink.getRollupLink().setSparseDimension(rollupLink.isSparseDimension());
                                    newLink.getRollupLink().setDefaultAggregationOperator(rollupLink.getDefaultAggregationOperator());
                                    newLink.getRollupLink().getChildToParentAttributes().addAll(rollupLink.getChildToParentAttributes());
                                }
                                ((TVLink)newLink.getViewFor(this.dpv)).addConnection();
                            }
                            continue;
                        }
                        if (!(obj instanceof Dimension)) continue;
                        Dimension dimension = (Dimension)obj;
                        Dimension newDimension = (Dimension)copiedMap.get(dimension.getObjectID());
                        for (Link link : dimension.getIncomingLinks()) {
                            newLink = this.getDesign().getMultidimensionalDesign().createLink();
                            link.copy(newLink);
                            child = link.getSourceObject();
                            parent = newDimension;
                            newSourceTV = (AbstractMDTV)child.getFirstViewForDPV(this.dpv);
                            newTargetTV = (AbstractMDTV)parent.getFirstViewForDPV(this.dpv);
                            newLink.setSourceTV(newSourceTV);
                            newLink.setTargetTV(newTargetTV);
                            rl = newLink.getRollupLink();
                            if (rl != null) {
                                newLink.getRollupLink().setFactEntity(link.getRollupLink().getFactEntity());
                                newLink.getRollupLink().setSparseDimension(link.getRollupLink().isSparseDimension());
                                newLink.getRollupLink().setDefaultAggregationOperator(link.getRollupLink().getDefaultAggregationOperator());
                                newLink.getRollupLink().getChildToParentAttributes().addAll(link.getRollupLink().getChildToParentAttributes());
                            }
                            ((TVLink)newLink.getViewFor(this.dpv)).addConnection();
                        }
                        for (Link link : dimension.getOutgoingLinks()) {
                            newLink = this.getDesign().getMultidimensionalDesign().createLink();
                            link.copy(newLink);
                            child = newDimension;
                            parent = link.getTargetObject();
                            newSourceTV = (AbstractMDTV)child.getFirstViewForDPV(this.dpv);
                            newTargetTV = (AbstractMDTV)parent.getFirstViewForDPV(this.dpv);
                            newLink.setSourceTV(newSourceTV);
                            newLink.setTargetTV(newTargetTV);
                            rl = newLink.getRollupLink();
                            if (rl != null) {
                                newLink.getRollupLink().setFactEntity(link.getRollupLink().getFactEntity());
                                newLink.getRollupLink().setSparseDimension(link.getRollupLink().isSparseDimension());
                                newLink.getRollupLink().setDefaultAggregationOperator(link.getRollupLink().getDefaultAggregationOperator());
                                newLink.getRollupLink().getChildToParentAttributes().addAll(link.getRollupLink().getChildToParentAttributes());
                            }
                            ((TVLink)newLink.getViewFor(this.dpv)).addConnection();
                        }
                    }
                }
                this.getDesignPartView().getDesignPart().sortCollections();
                this.getDesignPartView().sortCollections();
                this.getDesign().setDirty(true);
            }
            finally {
                ApplicationView.canLogging = true;
                this.getDesignPartView().getDesignPart().sortCollections();
            }
        }
    }

    public DockStation getDockStation() {
        if (this.dockStation == null) {
            this.dockStation = DockStation.getDockStation();
        }
        return this.dockStation;
    }

    public class MDObjectCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;
        private boolean raggedHLink = false;
        boolean rolePlaying;

        public MDObjectCollector() {
            this.startCollecting();
        }

        public void startCollecting() {
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().clearSelection();
            this.collect();
        }

        public MDObjectCollector(boolean raggedHLink) {
            this.raggedHLink = raggedHLink;
            this.startCollecting();
        }

        private void collect() {
            this.glassComp = ControllerMultidimensional.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] points) {
            this.rolePlaying = false;
            AbstractMDTV sourceTV = this.getTVEntityFor(points[0]);
            AbstractMDTV targetTV = this.getTVEntityFor(points[1]);
            ArrayList<String> errors = new ArrayList<String>();
            if (sourceTV == null) {
                errors.add(Messages.getString("ControllerMultidimensional.NoSourceObjectSelected"));
            }
            if (targetTV == null) {
                errors.add(Messages.getString("ControllerMultidimensional.NoDestinationObjectSelected"));
            }
            if (sourceTV != null && sourceTV == targetTV) {
                errors.add(Messages.getString("ControllerMultidimensional.SourceAndTargetObjectsAreEquals"));
            }
            if (this.raggedHLink) {
                if (errors.size() == 0) {
                    AbstractMDObject so = (AbstractMDObject)sourceTV.getModel();
                    AbstractMDObject to = (AbstractMDObject)targetTV.getModel();
                    if (to instanceof Level && so instanceof Level) {
                        if (((Level)so).getFirstRaggedHLinkTo((Level)to) != null) {
                            errors.add(Messages.getString("ControllerMultidimensional.ThereIsRaggedHierarchyLink"));
                        }
                        if (so.getFirstLinkToTarget(to) != null) {
                            errors.add(Messages.getString("ControllerMultidimensional.ThereIsRollupLlink"));
                        }
                    } else {
                        errors.add(Messages.getString("ControllerMultidimensional.RaggedHierarchyLinkDrawnBetweenLevels"));
                    }
                    if (errors.size() == 0) {
                        this.createRaggedHLink(sourceTV, targetTV);
                    } else {
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), errors.toArray(), Messages.getString("ControllerMultidimensional.NewLink"), 0);
                    }
                } else {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), errors.toArray(), Messages.getString("ControllerMultidimensional.NewLink"), 0);
                }
            } else if (errors.size() == 0) {
                AbstractMDObject so = (AbstractMDObject)sourceTV.getModel();
                AbstractMDObject to = (AbstractMDObject)targetTV.getModel();
                if (so instanceof Cube && to instanceof Dimension) {
                    if (so.getFirstLinkToTarget(to) != null) {
                        int res = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerMultidimensional.ThereIsDimensionUsage"));
                        if (res > 0) {
                            ControllerMultidimensional.this.select.actionPerformed(null);
                            return;
                        }
                        so.getFirstLinkToTarget(to).getRollupLink().setRolePlaying(true);
                        this.rolePlaying = true;
                    }
                } else if (so.getFirstLinkToTarget(to) != null) {
                    errors.add(Messages.getString("ControllerMultidimensional.OneLinkBetweenObjects"));
                }
                if (to instanceof Cube) {
                    errors.add(Messages.getString("ControllerMultidimensional.CubeCouldntBeTargetObject"));
                }
                if (to instanceof Dimension && so instanceof Level) {
                    errors.add(Messages.getString("ControllerMultidimensional.InpossibleLinkLD"));
                }
                if (to instanceof Dimension && so instanceof Dimension) {
                    errors.add(Messages.getString("ControllerMultidimensional.InpossibleLinkDD"));
                }
                if (so instanceof Cube && to instanceof Level) {
                    errors.add(Messages.getString("ControllerMultidimensional.InpossibleLinkCL"));
                }
                if (to instanceof Level && so instanceof Level && ((Level)so).getFirstRaggedHLinkTo((Level)to) != null) {
                    errors.add(Messages.getString("ControllerMultidimensional.15"));
                }
                if (so instanceof Level && ((Level)so).isValueBasedHierarchy()) {
                    String name = ((Level)so).getName();
                    errors.add(MessageFormat.format(Messages.getString("ControllerMultidimensional.Level"), name));
                }
                if (to instanceof Level && !(so instanceof Dimension) && ((Level)to).isValueBasedHierarchy()) {
                    String name = ((Level)to).getName();
                    errors.add(MessageFormat.format(Messages.getString("ControllerMultidimensional.Level"), name));
                }
                if (errors.size() == 0) {
                    Link link = this.createLink(sourceTV, targetTV);
                    if (link.getRollupLink() != null) {
                        link.getRollupLink().setRolePlaying(this.rolePlaying);
                    }
                } else {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), errors.toArray(), Messages.getString("ControllerMultidimensional.NewRaggedHierarchyLink"), 0);
                }
            } else {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), errors.toArray(), Messages.getString("ControllerMultidimensional.NewLink"), 0);
            }
            ControllerMultidimensional.this.select_SelectAction();
        }

        private AbstractMDTV getTVEntityFor(Point point) {
            Object cell = ControllerMultidimensional.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (cell != null && cell instanceof MDDiagramCell) {
                return (AbstractMDTV)((MDDiagramCell)cell).getTopView();
            }
            return null;
        }

        private Link createLink(AbstractMDTV sourceTV, AbstractMDTV targetTV) {
            ApplicationView.log(Messages.getString("ControllerMultidimensional.CreateLink"));
            Link link = ControllerMultidimensional.this.getDesign().getMultidimensionalDesign().createLink();
            link.setSourceTV(sourceTV);
            link.setTargetTV(targetTV);
            DesignPartView dpv = ControllerMultidimensional.this.getDesignPartView();
            ((TVLink)link.getViewFor(dpv)).addConnection();
            DesignPartView dpvMD = dpv instanceof DPVCompactMultidimentional ? ControllerMultidimensional.this.getDesign().getMultidimensionalDesign().getMainView() : ControllerMultidimensional.this.getDesign().getMultidimensionalDesign().getCompactDiagram();
            DesignObject source = sourceTV.getModel();
            DesignObject target = targetTV.getModel();
            AbstractMDTV newSourceTV = (AbstractMDTV)source.getFirstViewForDPV(dpvMD);
            AbstractMDTV newTargetTV = (AbstractMDTV)target.getFirstViewForDPV(dpvMD);
            link.setSourceTV(newSourceTV);
            link.setTargetTV(newTargetTV);
            if (dpv instanceof DPVCompactMultidimentional) {
                ((TVLink)link.getViewFor(dpvMD)).addConnection();
            }
            return link;
        }

        private void createRaggedHLink(AbstractMDTV sourceTV, AbstractMDTV targetTV) {
            ApplicationView.log(Messages.getString("ControllerMultidimensional.CreateRaggedHLink"));
            RaggedHLink link = ControllerMultidimensional.this.getDesign().getMultidimensionalDesign().createRaggedHLink();
            link.setSourceTV(sourceTV);
            link.setTargetTV(targetTV);
            DesignPartView dpv = ControllerMultidimensional.this.getDesignPartView();
            ((TVRaggedHLink)link.getViewFor(dpv)).addConnection();
            DesignPartView dpvMD = dpv instanceof DPVCompactMultidimentional ? ControllerMultidimensional.this.getDesign().getMultidimensionalDesign().getMainView() : ControllerMultidimensional.this.getDesign().getMultidimensionalDesign().getCompactDiagram();
            DesignObject source = sourceTV.getModel();
            DesignObject target = targetTV.getModel();
            AbstractMDTV newSourceTV = (AbstractMDTV)source.getFirstViewForDPV(dpvMD);
            AbstractMDTV newTargetTV = (AbstractMDTV)target.getFirstViewForDPV(dpvMD);
            link.setSourceTV(newSourceTV);
            link.setTargetTV(newTargetTV);
            if (dpv instanceof DPVCompactMultidimentional) {
                ((TVRaggedHLink)link.getViewFor(dpvMD)).addConnection();
            }
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerMultidimensional.this.getDesignPartView().getWorkSpace();
        }
    }

    class Select
    extends MDBAction {
        private Select() {
            super(MenuUtils.getMnemonicStr(AbstractController.SELECT_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("SELECT_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SELECT_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
            ControllerMultidimensional.this.updateToolbar(this);
        }
    }

    class NewCube
    extends MDBAction {
        private NewCube() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_CUBE_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("CUBE_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_CUBE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(11);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerMultidimensional.this.updateToolbar(this);
        }
    }

    class NewDimension
    extends MDBAction {
        private NewDimension() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_DIMENSION_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("DIMENSION_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_DIMENSION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(13);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerMultidimensional.this.updateToolbar(this);
        }
    }

    class NewLevel
    extends MDBAction {
        private NewLevel() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_LEVEL_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("LEVEL_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_LEVEL_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(12);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerMultidimensional.this.updateToolbar(this);
        }
    }

    class NewLink
    extends MDBAction {
        private NewLink() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_LINK_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("LINK_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_LINK_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(14);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerMultidimensional.this.updateToolbar(this);
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.collector = new MDObjectCollector();
        }
    }

    class NewRaggedHLink
    extends MDBAction {
        private NewRaggedHLink() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_RAGGED_H_LINK_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("RAGGED_LINK_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_RAGGED_H_LINK_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(16);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerMultidimensional.this.updateToolbar(this);
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.collector = new MDObjectCollector(true);
        }
    }

    class NewNote
    extends MDBAction {
        private NewNote() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_NOTE_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("NOTE_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_NOTE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(5);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerMultidimensional.this.updateToolbar(this);
        }
    }

    class NewImage
    extends MDBAction {
        private NewImage() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_IMAGE_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("IMAGE_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_IMAGE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(25);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerMultidimensional.this.updateToolbar(this);
        }
    }

    class Delete
    extends MDBAction {
        private Delete() {
            super(MenuUtils.getMnemonicStr(AbstractController.DELETE_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("DELETE_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DELETE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(6);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(Diagram.DELETE_CURSOR);
            ControllerMultidimensional.this.updateToolbar(this);
        }
    }

    class ZoomIn
    extends MDBAction {
        private ZoomIn() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_IN_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("ZOOM_IN_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_IN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addToolbarSeparator() {
            return ControllerMultidimensional.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerMultidimensional.this.getApplicationView().getCurrentDPV();
            dpv.zoomIn();
        }
    }

    class ZoomOut
    extends MDBAction {
        private ZoomOut() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_OUT_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("ZOOM_OUT_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_OUT_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerMultidimensional.this.getApplicationView().getCurrentDPV();
            dpv.zoomOut();
        }
    }

    class FitScreen
    extends MDBAction {
        private FitScreen() {
            super(MenuUtils.getMnemonicStr(AbstractController.FIT_SCREEN_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("FIT_SCREEN_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FIT_SCREEN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerMultidimensional.this.getApplicationView().getCurrentDPV();
            dpv.fitScreen();
        }
    }

    class ActualSize
    extends MDBAction {
        private ActualSize() {
            super(MenuUtils.getMnemonicStr(AbstractController.ACTUAL_SIZE_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ACTUAL_SIZE_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerMultidimensional.this.getApplicationView().getCurrentDPV();
            dpv.actualSize();
        }
    }

    class Search
    extends MDBAction {
        private Search() {
            super(MenuUtils.getMnemonicStr(AbstractController.SEARCH_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("SEARCH_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SEARCH_CAPTION));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPart dp = ControllerMultidimensional.this.getDesignPartView().getDesignPart();
            SearchDockable lastNonPinnedView = dp.getLastNonPinnedSearchDockable();
            if (lastNonPinnedView == null) {
                ViewId vId = new ViewId(new GUID().toString(), Integer.toString(dp.getSearchDockableIdSequence()));
                SearchDockable sdNew = new SearchDockable(vId);
                dp.addSearchDockable(sdNew);
                ((SearchPanel)sdNew.getGUI()).resetItems(dp);
                sdNew.show();
            } else {
                ControllerMultidimensional.this.getDockStation().activateDockable((Dockable)lastNonPinnedView);
            }
        }
    }
}

