/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v11g;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.LobStorageOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.LobStoragePropertyDialogOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;

public class LobStoragePropertyDialogOraclev11g
extends LobStoragePropertyDialogOracle {
    private static final String HIGH = Messages.getString("LobStoragePropertyDialogOraclev11g.HIGH");
    private static final String MEDIUM = Messages.getString("LobStoragePropertyDialogOraclev11g.MEDIUM");
    private static final String LOW = Messages.getString("LobStoragePropertyDialogOraclev11g.LOW");
    private static final String[] COMPRESSION_TYPE_CHOICES = new String[]{"", HIGH, MEDIUM, LOW};
    private static final String DEDUPLICATE = Messages.getString("LobStoragePropertyDialogOraclev11g.DEDUPLICATE");
    private static final String KEEP_DUPLICATES = Messages.getString("LobStoragePropertyDialogOraclev11g.KEEP_DUPLICATES");
    private static final String[] DUPLICATION_CHOICES = new String[]{"", DEDUPLICATE, KEEP_DUPLICATES};
    private JComboBox cbLobStorageType;
    private JComboBox cbCompression;
    private JComboBox cbCompressionType;
    private JComboBox cbDuplication;

    public LobStoragePropertyDialogOraclev11g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
    }

    @Override
    protected int getDialogHeight() {
        return 510;
    }

    @Override
    protected int initLobStorageType(int yCoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOraclev11g.LobStorageType"));
        this.general.add(label);
        this.cbLobStorageType = new JComboBox<String>(LobStorageOraclev11g.getLobStorageValues11g());
        this.setBG(this.cbLobStorageType);
        this.cbLobStorageType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLobStorageType);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbLobStorageType, yCoord);
        return 30;
    }

    @Override
    protected int initCompression(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.Compression"));
        this.general.add(label);
        this.cbCompression = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbCompression);
        this.cbCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCompression);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbCompression, yCoord);
        this.cbCompression.addActionListener(new CompressionListener());
        return 30;
    }

    @Override
    protected int initCompressionType(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.CompressionType"));
        this.general.add(label);
        this.cbCompressionType = new JComboBox<String>(COMPRESSION_TYPE_CHOICES);
        this.setBG(this.cbCompressionType);
        this.cbCompressionType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCompressionType);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbCompressionType, yCoord);
        return 30;
    }

    @Override
    protected int initDuplication(int yCoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOraclev11g.Duplication"));
        this.general.add(label);
        this.cbDuplication = new JComboBox<String>(DUPLICATION_CHOICES);
        this.setBG(this.cbDuplication);
        this.cbDuplication.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDuplication);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbDuplication, yCoord);
        return 30;
    }

    @Override
    protected int initLogging(int ycoord) {
        int returnValue = super.initLogging(ycoord);
        this.cbLogging.addItem("FILESYSTEM_LIKE_LOGGING");
        return returnValue;
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.cbLobStorageType.setSelectedItem(this.lobStorage.getLobStorageType());
        this.cbCompression.setSelectedItem(LobStoragePropertyDialogOraclev11g.translateYesNoForDisplay(this.lobStorage.getCompression()));
        this.cbCompressionType.setSelectedItem(this.translate(this.lobStorage.getCompressionType(), LobStorageOraclev11g.getCompressionTypeChoices(), COMPRESSION_TYPE_CHOICES));
        this.cbDuplication.setSelectedItem(this.translate(this.lobStorage.getDuplication(), LobStorageOraclev11g.getDuplicationChoices(), DUPLICATION_CHOICES));
    }

    @Override
    protected void setProperties() {
        if (this.lobStorage != null) {
            super.setProperties();
            this.lobStorage.setLobStorageType((String)this.cbLobStorageType.getSelectedItem());
            this.lobStorage.setCompression(LobStoragePropertyDialogOraclev11g.translateYesNoForStorage((String)this.cbCompression.getSelectedItem()));
            this.lobStorage.setCompressionType(this.translate((String)this.cbCompressionType.getSelectedItem(), COMPRESSION_TYPE_CHOICES, LobStorageOraclev11g.getCompressionTypeChoices()));
            this.lobStorage.setDuplication(this.translate((String)this.cbDuplication.getSelectedItem(), DUPLICATION_CHOICES, LobStorageOraclev11g.getDuplicationChoices()));
        }
    }

    private class CompressionListener
    implements ActionListener {
        private CompressionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LobStoragePropertyDialogOraclev11g.this.cbCompressionType.setEnabled(LobStoragePropertyDialogOraclev11g.this.cbCompression.getSelectedItem().equals(AbstractPropertyDialog.YES));
        }
    }
}

