/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SQLAttribute;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;

public class SQLDimensionPropertiesDialog
extends JDialog {
    private SQLAccessToAW.SQLDimension sqlDim;
    private SQLAccessToAW.SQLDimension origDim;
    private JTabbedPane tabbedPane = new JTabbedPane();
    JPanel contentPane;
    JPanel attributesTab = new JPanel();
    JPanel attributesPanel = new JPanel();
    JPanel levelPanel = new JPanel();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    TitledBorder titledBorder2;
    JScrollPane levelList;
    JCheckBox chbLevelName = new JCheckBox();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JCheckBox chbShortDescription = new JCheckBox();
    JCheckBox chbLongDescription = new JCheckBox();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JCheckBox chbDimensionColumn = new JCheckBox();
    String BTN_OK = Messages.getString("SQLDimensionPropertiesDialog.OK");
    String BTN_APPLY = Messages.getString("SQLDimensionPropertiesDialog.Apply");
    String BTN_CANCEL = Messages.getString("SQLDimensionPropertiesDialog.Cancel");
    private JButton bnCancel;
    String KEY_ESCAPE = "ESCAPE";
    private List selDescAttrs;
    private List allDescAttrs;
    private List selHiers;
    private List allHiers;
    private JTable attributeTable;
    private JTable hiersTable;
    private SQLAccessToAW.SQLHierarchy currentSQLHier;
    private JList dimLevelsList;
    private DefaultListModel selectedLevelsModel;
    private List predefinedAttrs = new ArrayList();
    JScrollPane attrSCRPane;
    JList attrJList;
    JPanel jPanel1 = new JPanel();
    JPanel dimHiersPanel = new JPanel();
    JPanel hiersPane = new JPanel();
    JPanel hierDetailPane = new JPanel();
    Border border11;
    TitledBorder titledBorder11;
    Border border22;
    TitledBorder titledBorder22;
    JScrollPane levelList2 = new JScrollPane();
    JPanel hlistPane = new JPanel();
    JPanel jPanel3 = new JPanel();
    JLabel lbAttribute = new JLabel();
    JCheckBox chbRollup = new JCheckBox();
    JComboBox cbAttribute = new JComboBox();
    TitledBorder titledBorder33;
    TitledBorder titledBorder44;
    GridBagLayout gridBagLayout11 = new GridBagLayout();
    GridBagLayout gridBagLayout22 = new GridBagLayout();
    GridBagLayout gridBagLayout33 = new GridBagLayout();
    GridBagLayout gridBagLayout44 = new GridBagLayout();
    BorderLayout borderLayout11 = new BorderLayout();
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SQLDimensionPropertiesDialog.this.bnCancel.doClick();
        }
    };

    public SQLDimensionPropertiesDialog(ApplicationView view, SQLAccessToAW.SQLDimension sqlDimension) {
        super(view.getFrame());
        this.origDim = sqlDimension;
        SQLAccessToAW sQLAccessToAW = sqlDimension.getSqlawObject();
        Objects.requireNonNull(sQLAccessToAW);
        this.sqlDim = sQLAccessToAW.new SQLAccessToAW.SQLDimension(sqlDimension.getDimension(), sqlDimension.getSqlawObject());
        this.origDim.makeCopyTo(this.sqlDim);
        this.setModal(true);
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.tabbedPane.setPreferredSize(new Dimension(355, 470));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(this.BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setMnemonic(79);
        this.getRootPane().setDefaultButton(bnOK);
        this.bnCancel = new JButton(this.BTN_CANCEL);
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setPreferredSize(this.bnCancel.getPreferredSize());
        bottomPanel.add(bnOK);
        bottomPanel.add(this.bnCancel);
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(this.KEY_ESCAPE), this.KEY_ESCAPE);
        c.getActionMap().put(this.KEY_ESCAPE, this.escape);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.initProperties();
        this.pack();
        this.centerOnScreen(this);
        this.setResizable(false);
    }

    public void centerOnScreen(JDialog window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = window.getSize();
        Point newLocation = new Point((screenSize.width - mySize.width) / 2, (screenSize.height - mySize.height) / 3);
        window.setLocation(newLocation);
    }

    private void initProperties() {
        this.makePredefinedAttrList(this.sqlDim);
        this.selDescAttrs = this.sqlDim.getSelectedDescriptiveAttributes();
        this.allDescAttrs = this.sqlDim.getAllDescriptiveAttributes();
        this.selHiers = this.sqlDim.getSelectedSQLHierarhies();
        this.allHiers = this.sqlDim.getAllSQLHierarchies();
        if (this.allHiers.size() > 0) {
            this.currentSQLHier = (SQLAccessToAW.SQLHierarchy)this.allHiers.get(0);
        }
        this.initAttributes2();
        this.initHierarchies();
        this.chbDimensionColumn.setSelected(this.sqlDim.isSelectedDimensionID());
        this.chbLevelName.setSelected(this.sqlDim.isSelectedLevelNameAttr());
        this.chbShortDescription.setSelected(this.sqlDim.isSelectedShortDescAttr());
        this.chbLongDescription.setSelected(this.sqlDim.isSelectedLongDescAttr());
        if (this.allHiers.size() > 0) {
            this.hiersTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        ArrayList<SQLAttribute> list = new ArrayList<SQLAttribute>();
        list.add(null);
        list.add(this.sqlDim.getShortDescAttr());
        list.add(this.sqlDim.getLongDescAttr());
        list.addAll(this.allDescAttrs);
        this.cbAttribute.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.cbAttribute.setSelectedItem(this.currentSQLHier.getLabelAttribute());
        this.chbRollup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLDimensionPropertiesDialog.this.cbAttribute.setEnabled(SQLDimensionPropertiesDialog.this.chbRollup.isSelected());
                SQLDimensionPropertiesDialog.this.dimLevelsList.setEnabled(SQLDimensionPropertiesDialog.this.chbRollup.isSelected());
                SQLDimensionPropertiesDialog.this.currentSQLHier.setRollupForm(SQLDimensionPropertiesDialog.this.chbRollup.isSelected());
            }
        });
        this.cbAttribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLAttribute sqla = (SQLAttribute)SQLDimensionPropertiesDialog.this.cbAttribute.getSelectedItem();
                SQLDimensionPropertiesDialog.this.currentSQLHier.setLabelAttribute(sqla);
            }
        });
        this.cbAttribute.setEnabled(this.chbRollup.isSelected());
        this.dimLevelsList.setEnabled(this.chbRollup.isSelected());
    }

    private void initAttributes2() {
        this.attrJList = new JList(new DefaultListModel());
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JList list = (JList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                Rectangle rect = list.getCellBounds(index, index);
                Object obj = list.getModel().getElementAt(index);
                if (obj != null && obj instanceof AttrSelection && rect.contains(e.getPoint())) {
                    AttrSelection attrsel = (AttrSelection)obj;
                    boolean selected = attrsel.selected;
                    attrsel.selected = !selected;
                    list.repaint(rect);
                }
            }
        };
        this.attrJList.setCellRenderer(new AttributesCBCellRenderer());
        this.attrJList.addMouseListener(mouseListener);
        this.attrJList.setListData(this.predefinedAttrs.toArray());
        int atsize = 85;
        if (this.sqlDim.getDimension().isTimeDimension()) {
            atsize = 122;
        }
        this.attributeTable = new JTable(new AttributesTableModel());
        this.border1 = new EtchedBorder(0);
        this.titledBorder1 = new TitledBorder(new EtchedBorder(0), Messages.getString("SQLDimensionPropertiesDialog.PredefinedAttributes"));
        this.border2 = new EtchedBorder(0);
        this.titledBorder2 = new TitledBorder(new EtchedBorder(0), Messages.getString("SQLDimensionPropertiesDialog.DescriptiveAttributes"));
        this.attributesTab.setLayout(this.gridBagLayout1);
        this.attributesPanel.setBorder(this.titledBorder1);
        this.attributesPanel.setLayout(this.gridBagLayout2);
        this.levelPanel.setBorder(this.titledBorder2);
        this.levelPanel.setLayout(this.gridBagLayout3);
        this.levelList = new JScrollPane();
        this.attrSCRPane = new JScrollPane();
        this.attributesTab.setPreferredSize(new Dimension(305, 426));
        this.chbLevelName.setText(Messages.getString("SQLDimensionPropertiesDialog.LevelName"));
        this.chbShortDescription.setText(Messages.getString("SQLDimensionPropertiesDialog.ShortDescription"));
        this.chbLongDescription.setText(Messages.getString("SQLDimensionPropertiesDialog.LongDescription"));
        this.chbDimensionColumn.setText(Messages.getString("SQLDimensionPropertiesDialog.DimensionColumn"));
        this.attributesTab.add((Component)this.attributesPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(16, 12, 0, 14), 57, 4));
        this.attributesTab.add((Component)this.levelPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 11, 14), 4, 4));
        this.levelPanel.add((Component)this.levelList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 4, 8, 5), 256, 246));
        this.levelList.getViewport().add((Component)this.attributeTable, null);
        this.attributesPanel.add((Component)this.attrSCRPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 4, 8, 5), 120, atsize));
        this.attrSCRPane.getViewport().add((Component)this.attrJList, null);
        this.tabbedPane.add(Messages.getString("SQLDimensionPropertiesDialog.Attributes"), this.attributesTab);
    }

    private void initHierarchies() {
        this.hiersTable = new JTable(new HiersTableModel());
        this.hiersTable.getSelectionModel().addListSelectionListener(new HierSelectionListener());
        this.border11 = new EtchedBorder(0);
        this.titledBorder11 = new TitledBorder(this.border11, Messages.getString("SQLDimensionPropertiesDialog.DimensionHierarchies"));
        this.border22 = new EtchedBorder(0);
        this.titledBorder22 = new TitledBorder(new EtchedBorder(0), Messages.getString("SQLDimensionPropertiesDialog.ShowHierarchyLevels"));
        this.titledBorder33 = new TitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("SQLDimensionPropertiesDialog.Levels"));
        this.titledBorder44 = new TitledBorder("");
        this.dimHiersPanel.setLayout(this.gridBagLayout11);
        this.dimHiersPanel.setPreferredSize(new Dimension(305, 426));
        this.hiersPane.setBorder(this.titledBorder11);
        this.hiersPane.setLayout(this.gridBagLayout22);
        this.hierDetailPane.setBorder(this.titledBorder22);
        this.hierDetailPane.setLayout(this.gridBagLayout33);
        this.hlistPane.setLayout(this.borderLayout11);
        this.lbAttribute.setText(Messages.getString("SQLDimensionPropertiesDialog.LabelAttribute"));
        this.jPanel3.setLayout(this.gridBagLayout44);
        this.chbRollup.setText(Messages.getString("SQLDimensionPropertiesDialog.RollupForm"));
        this.jPanel3.setBorder(this.titledBorder44);
        this.levelList2.setBorder(this.titledBorder33);
        this.hierDetailPane.add((Component)this.levelList2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(13, 10, 2, 7), 222, 106));
        this.hierDetailPane.add((Component)this.jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 7), 5, 8));
        this.jPanel3.add((Component)this.chbRollup, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 9, 4));
        this.jPanel3.add((Component)this.lbAttribute, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 13, 0), 24, 0));
        this.jPanel3.add((Component)this.cbAttribute, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 13, 5), 100, 0));
        this.dimHiersPanel.add((Component)this.hiersPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(16, 12, 0, 9), 6, 5));
        this.dimHiersPanel.add((Component)this.hierDetailPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(11, 12, 14, 9), 7, 4));
        this.hiersPane.add((Component)this.hlistPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 4, 5, 6), 241, 90));
        JScrollPane sp = new JScrollPane(this.hiersTable);
        this.hlistPane.add(sp);
        this.initDimLevelsList();
        this.tabbedPane.add(Messages.getString("SQLDimensionPropertiesDialog.Hierarchies"), this.dimHiersPanel);
    }

    private void initDimLevelsList() {
        this.selectedLevelsModel = new DefaultListModel();
        this.dimLevelsList = new JList(this.selectedLevelsModel);
        this.levelList2.getViewport().add((Component)this.dimLevelsList, null);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SQLDimensionPropertiesDialog.this.dimLevelsList.isEnabled()) {
                    return;
                }
                JList list = (JList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                Rectangle rect = list.getCellBounds(index, index);
                Object obj = list.getModel().getElementAt(index);
                if (obj != null && SQLDimensionPropertiesDialog.this.currentSQLHier != null && obj instanceof Level && rect.contains(e.getPoint())) {
                    Level level = (Level)obj;
                    boolean selected = SQLDimensionPropertiesDialog.this.currentSQLHier.isLevelSelected(level);
                    SQLDimensionPropertiesDialog.this.currentSQLHier.setLevelSelection(level, !selected);
                    list.repaint(rect);
                }
            }
        };
        this.dimLevelsList.setCellRenderer(new CBCellRenderer());
        this.dimLevelsList.addMouseListener(mouseListener);
    }

    public String getCaption() {
        return MessageFormat.format(Messages.getString("SQLDimensionPropertiesDialog.AttributesHierarchiesForDimension"), this.sqlDim.getDimension().getName());
    }

    private void setProperties() {
        for (AttrSelection sel : this.predefinedAttrs) {
            if (SQLAccessToAW.ATTR_TYPE_SHORT_DESC.equals(sel.type)) {
                this.sqlDim.setSelectedShortDescAttr(sel.selected);
            } else if (SQLAccessToAW.ATTR_TYPE_LONG_DESC.equals(sel.type)) {
                this.sqlDim.setSelectedLongDescAttr(sel.selected);
            } else if (SQLAccessToAW.ATTR_TYPE_LEVEL_NAME.equals(sel.type)) {
                this.sqlDim.setSelectedLevelNameAttr(sel.selected);
            } else if (SQLAccessToAW.ATTR_TYPE_DIMENSION_ID.equals(sel.type)) {
                this.sqlDim.setSelectedDimensionID(sel.selected);
            }
            if (!this.sqlDim.getDimension().isTimeDimension()) continue;
            if (SQLAccessToAW.ATTR_TYPE_END_DATE.equals(sel.type)) {
                this.sqlDim.setSelectedEndDate(sel.selected);
                continue;
            }
            if (!SQLAccessToAW.ATTR_TYPE_TIME_SPAN.equals(sel.type)) continue;
            this.sqlDim.setSelectedTimeSpan(sel.selected);
        }
        this.sqlDim.makeCopyTo(this.origDim);
    }

    private void enableHierDetails(boolean enable) {
        this.cbAttribute.setEnabled(enable && this.chbRollup.isSelected());
        this.dimLevelsList.setEnabled(enable && this.chbRollup.isSelected());
        this.chbRollup.setEnabled(enable);
    }

    private void makePredefinedAttrList(SQLAccessToAW.SQLDimension sqld) {
        this.predefinedAttrs.clear();
        AttrSelection attrsel = new AttrSelection();
        attrsel.selected = sqld.isSelectedShortDescAttr();
        attrsel.type = sqld.getShortDescAttr().getType();
        this.predefinedAttrs.add(attrsel);
        attrsel = new AttrSelection();
        attrsel.selected = sqld.isSelectedLongDescAttr();
        attrsel.type = sqld.getLongDescAttr().getType();
        this.predefinedAttrs.add(attrsel);
        if (sqld.getDimension().isTimeDimension()) {
            attrsel = new AttrSelection();
            attrsel.selected = sqld.isSelectedEndDate();
            attrsel.type = sqld.getEndDateAttr().getType();
            this.predefinedAttrs.add(attrsel);
            attrsel = new AttrSelection();
            attrsel.selected = sqld.isSelectedTimeSpan();
            attrsel.type = sqld.getTimeSpanAttr().getType();
            this.predefinedAttrs.add(attrsel);
        }
        attrsel = new AttrSelection();
        attrsel.selected = sqld.isSelectedLevelNameAttr();
        attrsel.type = sqld.getLevelNameAttr().getType();
        this.predefinedAttrs.add(attrsel);
        attrsel = new AttrSelection();
        attrsel.selected = sqld.isSelectedDimensionID();
        attrsel.type = sqld.getDimensionIDAttr().getType();
        this.predefinedAttrs.add(attrsel);
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SQLDimensionPropertiesDialog.this.setProperties();
            SQLDimensionPropertiesDialog.this.dispose();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SQLDimensionPropertiesDialog.this.dispose();
        }
    }

    class AttributesCBCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        AttributesCBCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            AttrSelection sel = (AttrSelection)value;
            this.setSelected(sel.selected);
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setOpaque(true);
            return this;
        }
    }

    private class AttributesTableModel
    extends AbstractTableModel {
        private AttributesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SQLDimensionPropertiesDialog.this.allDescAttrs.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SQLDimensionPropertiesDialog.Level");
            }
            if (column == 1) {
                return Messages.getString("SQLDimensionPropertiesDialog.Attribute");
            }
            if (column == 2) {
                return Messages.getString("SQLDimensionPropertiesDialog.UseIt");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 2 && aValue instanceof Boolean) {
                SQLAttribute sqla = (SQLAttribute)SQLDimensionPropertiesDialog.this.allDescAttrs.get(row);
                boolean selected = (Boolean)aValue;
                if (selected) {
                    if (!SQLDimensionPropertiesDialog.this.selDescAttrs.contains(sqla)) {
                        SQLDimensionPropertiesDialog.this.selDescAttrs.add(sqla);
                    }
                } else {
                    SQLDimensionPropertiesDialog.this.selDescAttrs.remove(sqla);
                }
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            SQLAttribute sqla = (SQLAttribute)SQLDimensionPropertiesDialog.this.allDescAttrs.get(row);
            if (col == 0) {
                return sqla.getLevel().getName();
            }
            if (col == 1) {
                return sqla.getSlowChangingAttribute().getName();
            }
            if (col == 2) {
                return new Boolean(SQLDimensionPropertiesDialog.this.selDescAttrs.contains(sqla));
            }
            return null;
        }
    }

    private class HiersTableModel
    extends AbstractTableModel {
        private HiersTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SQLDimensionPropertiesDialog.this.allHiers.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SQLDimensionPropertiesDialog.Hierarchy");
            }
            if (column == 1) {
                return Messages.getString("SQLDimensionPropertiesDialog.UseIt");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 1 && aValue instanceof Boolean) {
                SQLAccessToAW.SQLHierarchy sqlh = (SQLAccessToAW.SQLHierarchy)SQLDimensionPropertiesDialog.this.allHiers.get(row);
                boolean selected = (Boolean)aValue;
                if (selected) {
                    if (!SQLDimensionPropertiesDialog.this.selHiers.contains(sqlh)) {
                        SQLDimensionPropertiesDialog.this.selHiers.add(sqlh);
                    }
                } else {
                    SQLDimensionPropertiesDialog.this.selHiers.remove(sqlh);
                }
                SQLDimensionPropertiesDialog.this.enableHierDetails(selected);
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            SQLAccessToAW.SQLHierarchy sqlh = (SQLAccessToAW.SQLHierarchy)SQLDimensionPropertiesDialog.this.allHiers.get(row);
            if (col == 0) {
                return sqlh.getHierarchy().getName();
            }
            if (col == 1) {
                return new Boolean(SQLDimensionPropertiesDialog.this.selHiers.contains(sqlh));
            }
            return null;
        }
    }

    public class HierSelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int row = ((ListSelectionModel)e.getSource()).getAnchorSelectionIndex();
            if (row != -1 && SQLDimensionPropertiesDialog.this.currentSQLHier != null) {
                SQLAccessToAW.SQLHierarchy sqlh;
                SQLDimensionPropertiesDialog.this.currentSQLHier = sqlh = (SQLAccessToAW.SQLHierarchy)SQLDimensionPropertiesDialog.this.allHiers.get(row);
                Boolean bl = (Boolean)SQLDimensionPropertiesDialog.this.hiersTable.getModel().getValueAt(row, 1);
                boolean selected = bl;
                SQLDimensionPropertiesDialog.this.dimLevelsList.setListData(sqlh.getHierarchy().getLevels().toArray());
                SQLDimensionPropertiesDialog.this.cbAttribute.setSelectedItem(SQLDimensionPropertiesDialog.this.currentSQLHier.getLabelAttribute());
                SQLDimensionPropertiesDialog.this.chbRollup.setSelected(SQLDimensionPropertiesDialog.this.currentSQLHier.isRollupForm());
                SQLDimensionPropertiesDialog.this.enableHierDetails(selected);
            }
        }
    }

    class CBCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        CBCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            Level level = (Level)value;
            this.setSelected(SQLDimensionPropertiesDialog.this.currentSQLHier.isLevelSelected(level));
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setOpaque(true);
            return this;
        }
    }

    class AttrSelection {
        boolean selected;
        String type;

        AttrSelection() {
        }

        public String toString() {
            return this.type;
        }
    }
}

