/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.SelectAttributesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.ide.Ide;

public class RaggedHLinkPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private RaggedHLink link;
    private JButton bnChildLevel;
    private JButton bnParentLevel;
    private JTable aTable;
    private List aList;
    private JPanel pnAttributes;
    private JButton btnAttributeProperties;
    private JButton btnRemoveAttribute;

    public RaggedHLinkPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbChildLevel = new JLabel(LB_CHILD_LEVEL);
        lbChildLevel.setPreferredSize(this.getDefaultSize());
        this.bnChildLevel = new JButton();
        this.bnChildLevel.setPreferredSize(this.getDefaultSize());
        this.bnChildLevel.setHorizontalAlignment(0);
        this.bnChildLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RaggedHLinkPropertiesDialogEx.this.link.getChildLevel() != null) {
                    RaggedHLinkPropertiesDialogEx.this.link.getChildLevel().showPropertyDialog();
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbChildLevel, this.bnChildLevel));
        JLabel lbParentLevel = new JLabel(LB_PARENT_LEVEL);
        lbParentLevel.setPreferredSize(this.getDefaultSize());
        this.bnParentLevel = new JButton();
        this.bnParentLevel.setPreferredSize(this.getDefaultSize());
        this.bnParentLevel.setHorizontalAlignment(0);
        this.bnParentLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RaggedHLinkPropertiesDialogEx.this.link.getParentLevel() != null) {
                    RaggedHLinkPropertiesDialogEx.this.link.getParentLevel().showPropertyDialog();
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbParentLevel, this.bnParentLevel));
    }

    @Override
    public String getCaption() {
        return Messages.getString("RaggedHLinkPropertiesDialogEx.RaggedLinkProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "RAGGED_LINK_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof RaggedHLink) {
            this.link = (RaggedHLink)object;
            this.initDefaults(false);
            this.taDescription.setText(this.link.getDescription());
            String sourceName = this.link.getChildLevel() != null ? this.link.getChildLevel().getName() : Messages.getString("RaggedHLinkPropertiesDialogEx.NONE");
            this.bnChildLevel.setText(sourceName);
            String parentName = this.link.getParentLevel() != null ? this.link.getParentLevel().getName() : Messages.getString("RaggedHLinkPropertiesDialogEx.NONE");
            this.bnParentLevel.setText(parentName);
            this.aList.addAll(this.link.getChildToParentAttributes());
            this.initResponsibleParties();
            this.initDocuments();
            this.initDynamicProperties();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.aList = new ArrayList();
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getAttributesPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDescriptionPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        this.link.setName(this.tfName.getText());
        this.link.setComment(this.taComments.getText());
        this.link.setNotes(this.taNotes.getText());
        this.link.setDescription(this.taDescription.getText());
        this.link.getChildToParentAttributes().clear();
        for (ContainedObject object : this.aList) {
            this.link.addChildToParentAttribute(object);
        }
        TopView tv = this.link.getChildLevel().getTopView();
        if (tv != null && tv.getCellView() != null && tv.getCellView().getDiagram() != null) {
            tv.getCellView().getDiagram().repaint();
        }
        this.setResponsibleParties();
        this.setDocuments();
        RaggedHLinkPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.link.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.link.setProperty(dp.getName(), dp.getValue());
        }
    }

    protected JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = this.createPage(Messages.getString("RaggedHLinkPropertiesDialogEx.ChildToParentAttributes"));
            this.aTable = new JTable(new AttributeModel());
            this.aTable.setSelectionMode(0);
            this.aTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = RaggedHLinkPropertiesDialogEx.this.aTable.getSelectedRow()) > -1 && RaggedHLinkPropertiesDialogEx.this.aList.size() > 0 && row < RaggedHLinkPropertiesDialogEx.this.aList.size()) {
                        ContainedObject attribute = (ContainedObject)RaggedHLinkPropertiesDialogEx.this.aList.get(row);
                        attribute.showPropertyDialog();
                    }
                }
            });
            this.aTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int selectedRow = RaggedHLinkPropertiesDialogEx.this.aTable.getSelectedRow();
                        if (selectedRow == -1) {
                            RaggedHLinkPropertiesDialogEx.this.btnAttributeProperties.setEnabled(false);
                            RaggedHLinkPropertiesDialogEx.this.btnRemoveAttribute.setEnabled(false);
                        } else {
                            RaggedHLinkPropertiesDialogEx.this.btnAttributeProperties.setEnabled(true);
                            RaggedHLinkPropertiesDialogEx.this.btnRemoveAttribute.setEnabled(true);
                        }
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.aTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnAttributeProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnAttributeProperties.setToolTipText(BTN_PROPERTIES);
            this.btnAttributeProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = RaggedHLinkPropertiesDialogEx.this.aTable.getSelectedRow();
                    if (row > -1 && RaggedHLinkPropertiesDialogEx.this.aList.size() > 0 && row < RaggedHLinkPropertiesDialogEx.this.aList.size()) {
                        ContainedObject attribute = (ContainedObject)RaggedHLinkPropertiesDialogEx.this.aList.get(row);
                        attribute.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnAttributeProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ContainerObject ent = RaggedHLinkPropertiesDialogEx.this.link.getChildLevel().getLevelEntity();
                        if (ent == null) {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("RaggedHLinkPropertiesDialogEx.LevelEntityNotSetForChildLevel") + RaggedHLinkPropertiesDialogEx.this.link.getChildLevel().getName(), RaggedHLinkPropertiesDialogEx.this.link.getName(), 0);
                            return;
                        }
                        if (RaggedHLinkPropertiesDialogEx.this.link.getParentLevel().getLevelEntity() == null) {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("RaggedHLinkPropertiesDialogEx.LevelEntityNotSetForParentLevel") + RaggedHLinkPropertiesDialogEx.this.link.getParentLevel().getName(), RaggedHLinkPropertiesDialogEx.this.link.getName(), 0);
                            return;
                        }
                        if (RaggedHLinkPropertiesDialogEx.this.link.getChildLevel().getLevelEntity() == RaggedHLinkPropertiesDialogEx.this.link.getParentLevel().getLevelEntity()) {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("RaggedHLinkPropertiesDialogEx.ChildParentLevelsDefinedSameEntity"), RaggedHLinkPropertiesDialogEx.this.link.getName(), 0);
                            return;
                        }
                        SelectAttributesDialog dialog = new SelectAttributesDialog(RaggedHLinkPropertiesDialogEx.this.getAppView(), RaggedHLinkPropertiesDialogEx.this.aList, ent);
                        dialog.show();
                        RaggedHLinkPropertiesDialogEx.this.aTable.clearSelection();
                        int lastRow = RaggedHLinkPropertiesDialogEx.this.aTable.convertRowIndexToView(RaggedHLinkPropertiesDialogEx.this.aTable.getModel().getRowCount() - 1);
                        RaggedHLinkPropertiesDialogEx.this.aTable.setRowSelectionInterval(lastRow, lastRow);
                        RaggedHLinkPropertiesDialogEx.this.aTable.updateUI();
                    }
                });
                this.btnRemoveAttribute = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveAttribute.setToolTipText(BTN_REMOVE);
                this.btnRemoveAttribute.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = RaggedHLinkPropertiesDialogEx.this.aTable.getSelectedRow();
                        if (objectNumber != -1 && RaggedHLinkPropertiesDialogEx.this.aList.size() > 0 && objectNumber < RaggedHLinkPropertiesDialogEx.this.aList.size()) {
                            RaggedHLinkPropertiesDialogEx.this.aList.remove(objectNumber);
                            RaggedHLinkPropertiesDialogEx.this.aTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(this.btnRemoveAttribute);
            }
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnAttributes.add(pPanel);
        }
        return this.pnAttributes;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class AttributeModel
    extends AbstractTableModel {
        private AttributeModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return RaggedHLinkPropertiesDialogEx.this.aList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("RaggedHLinkPropertiesDialogEx.Attributes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ContainedObject attribute = (ContainedObject)RaggedHLinkPropertiesDialogEx.this.aList.get(row);
            if (col == 0) {
                return attribute.getLongName();
            }
            return new Integer(row * col);
        }
    }
}

