/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.model.design.undo.FormatLineEdit;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.ColorChooserDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JLWComboBox;

public class FormatLineDialog
extends JDialog {
    public static final String KEY_ESCAPE = "ESCAPE";
    private Object[] topViews;
    private JCheckBox chbUseDefault = new JCheckBox(MessageFormat.format(Messages.getString("FormatLineDialog.UseDefault"), "<html><body><b>", "</b></body></html>"));
    private JButton bnBackground;
    private Color backgroundColor = null;
    private JLWComboBox cbLineType;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FormatLineDialog.this.dispose();
        }
    };

    public FormatLineDialog(Object[] topViews) {
        super(((TopView)topViews[0]).getApplicationView().getFrame());
        this.topViews = topViews;
        this.setTitle(Messages.getString("FormatLineDialog.FormatLine"));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FormatLineDialog.this.dispose();
            }
        });
        JPanel pnButtons = new JPanel();
        JButton bnOK = new JButton(new OKAction(Messages.getString("FormatLineDialog.OK")));
        bnOK.setMnemonic(79);
        JButton bnApply = new JButton(new ApplyAction(Messages.getString("FormatLineDialog.Apply")));
        bnApply.setMnemonic(65);
        JButton bnCancel = new JButton(new CancelAction(Messages.getString("FormatLineDialog.Cancel")));
        bnCancel.setMnemonic(67);
        pnButtons.add(bnOK);
        pnButtons.add(bnApply);
        pnButtons.add(bnCancel);
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.getContentPane().add((Component)this.initColorPanel(), "North");
        this.getContentPane().add((Component)pnButtons, "South");
        this.pack();
        this.setResizable(false);
        this.setModal(true);
        CommonUtil.centerOnScreen(this);
    }

    private JPanel initColorPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel pnTop = new JPanel(new GridLayout(0, 1, 10, 10));
        pnTop.setBorder(BorderFactory.createEtchedBorder());
        JPanel pnCHB = new JPanel(new FlowLayout(3));
        this.chbUseDefault.setPreferredSize(new Dimension(160, 35));
        pnCHB.add(this.chbUseDefault);
        pnTop.add(pnCHB);
        this.chbUseDefault.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FormatLineDialog.this.bnBackground.setEnabled(false);
                    FormatLineDialog.this.cbLineType.setEnabled(false);
                } else {
                    FormatLineDialog.this.bnBackground.setEnabled(true);
                    FormatLineDialog.this.cbLineType.setEnabled(true);
                }
            }
        });
        this.cbLineType = new JLWComboBox();
        this.cbLineType.setPreferredSize(new Dimension(140, 20));
        JLabel lbWidth = new JLabel(Messages.getString("FormatLineDialog.Width"));
        JPanel pnLineType = new JPanel(new FlowLayout(1));
        pnLineType.add(lbWidth);
        pnLineType.add(this.cbLineType);
        pnTop.add(pnLineType);
        this.bnBackground = new JButton();
        this.bnBackground.setPreferredSize(new Dimension(140, 20));
        this.bnBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ColorChooserDialog colorDialog = new ColorChooserDialog((Dialog)FormatLineDialog.this, Messages.getString("FormatLineDialog.SelectColor"), FormatLineDialog.this.bnBackground.getBackground());
                Color newColor = colorDialog.showDialog();
                if (newColor != null) {
                    FormatLineDialog.this.backgroundColor = newColor;
                    FormatLineDialog.this.bnBackground.setBackground(FormatLineDialog.this.backgroundColor);
                }
            }
        });
        JLabel lbBackground = new JLabel(Messages.getString("FormatLineDialog.Color"));
        lbBackground.setPreferredSize(lbWidth.getPreferredSize());
        JPanel pnBackground = new JPanel(new FlowLayout(1));
        pnBackground.add(lbBackground);
        pnBackground.add(this.bnBackground);
        pnTop.add(pnBackground);
        pnTop.add(new JPanel());
        pnTop.add(new JPanel());
        this.chbUseDefault.setSelected(((TopView)this.topViews[0]).useDefaultColor());
        if (!this.chbUseDefault.isSelected()) {
            this.cbLineType.setSelectedIndex(((TopView)this.topViews[0]).getLineWidth() - 1);
            this.backgroundColor = ((TopView)this.topViews[0]).getBackgroundColor();
            if (this.backgroundColor != null) {
                this.bnBackground.setBackground(this.backgroundColor);
            }
        } else {
            this.cbLineType.setSelectedIndex(((TopView)this.topViews[0]).getDefaultLineWidth() - 1);
            this.backgroundColor = ((TopView)this.topViews[0]).getDefaultLineColor();
            if (this.backgroundColor != null) {
                this.bnBackground.setBackground(this.backgroundColor);
            }
        }
        jpanel.add(pnTop);
        return jpanel;
    }

    private void setTopViews() {
        FormatLineEdit fedit = new FormatLineEdit(this.topViews, this.chbUseDefault.isSelected(), this.backgroundColor, this.cbLineType.getSelectedIndex() + 1);
        fedit.applyUpdates();
        fedit.end();
        ((TopView)this.topViews[0]).getModel().getDesignPart().postUndoableEdit(fedit);
        for (int i = 0; i < this.topViews.length; ++i) {
            TopView topView = (TopView)this.topViews[i];
            topView.getModel().setDirty(true);
            topView.getDesignPartView().setDirty(true);
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FormatLineDialog.this.setTopViews();
            FormatLineDialog.this.dispose();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        public ApplyAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FormatLineDialog.this.setTopViews();
            ((TopView)FormatLineDialog.this.topViews[0]).getCellView().getDiagram().repaint();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FormatLineDialog.this.dispose();
        }
    }
}

