/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.process.DFDRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class TransformationRenderer
extends DFDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(255, 255, 213);

    public TransformationRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
    }

    @Override
    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor dfc = this.processObject.getDesign().getDesignLevelSettings().getDefaultFCObject("Transformation");
            if (dfc != null) {
                return dfc.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor dfc = this.processObject.getDesign().getDesignLevelSettings().getDefaultFCObject("Transformation");
            if (dfc != null) {
                return dfc.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public void paint(Graphics g) {
        String processNbr;
        Transformation process;
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        TopView efo = this.getTopView();
        if (this.processObject instanceof Transformation) {
            process = (Transformation)this.processObject;
            processNbr = process.getProcessNumber();
        } else {
            processNbr = String.valueOf(this.processObject.getDesignObjectSet().getIndexOf(this.processObject) + 1);
        }
        g2.setPaint(this.getBackgroundColor());
        g.fillRoundRect(0, 0, width - 1, height - 1, 20, 20);
        g.setColor(this.getBorderColor());
        g.drawRoundRect(0, 0, width - 1, height - 1, 20, 20);
        if (this.processObject instanceof Transformation && (process = (Transformation)this.processObject).getType() == 1) {
            int[] xPoints = new int[]{width - 14, width - 8, width - 14, width - 19, width - 14};
            int[] yPoints = new int[]{5, 5, 14, 5, 5};
            g.drawPolyline(xPoints, yPoints, 5);
        }
        Font titleFont = efo.getFontObject(EditableFonts.FO_TITLE).getFont();
        g.setFont(titleFont);
        FontMetrics fm = g.getFontMetrics();
        int colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
        BasicStroke lineStroke = new BasicStroke(this.borderWidth);
        BasicStroke textStroke = new BasicStroke(1.0f);
        int yCursor = Math.max(colTextHeight, titleFont.getSize());
        int xCursor = (width - fm.stringWidth(processNbr)) / 2;
        if (xCursor < 20) {
            xCursor = 20;
        }
        g2.setStroke(textStroke);
        g.setColor(efo.getFontObject(EditableFonts.FO_PROCESS_NUMBER).getColor());
        g.drawString(processNbr, xCursor, yCursor);
        g2.setStroke(lineStroke);
        g.setColor(this.getBorderColor());
        g.drawLine(0, yCursor += 3 + this.borderWidth, width - 2, yCursor);
        fm = g.getFontMetrics();
        colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
        g.setColor(efo.getFontObject(EditableFonts.FO_TITLE).getColor());
        g2.setStroke(textStroke);
        yCursor = height / 2 + titleFont.getSize() / 3;
        xCursor = (width - fm.stringWidth(this.title)) / 2;
        g.drawString(this.title, xCursor, yCursor);
    }
}

