/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.SequenceSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionSqlServerv2k5;

public class DDLSelectionSqlServerv2k12
extends DDLSelectionSqlServerv2k5 {
    private static final String SEQUENCES = Messages.getString("DDLSelectionSqlServerv2k12.Sequences");
    private List sequenceList;

    public DDLSelectionSqlServerv2k12(StorageDesign design) {
        super(design);
    }

    public DDLSelectionSqlServerv2k12(StorageDesign design, DesignPartView selectedSubView) {
        super(design, selectedSubView);
    }

    @Override
    protected void addAllWithNullSchema(ModelIdObjectSelection parent, DataBaseSqlServer db) {
        this.addContainerObjects(SEQUENCES, parent, this.getSequencesWithNullSchema(db), this.getSequenceList());
        super.addAllWithNullSchema(parent, db);
    }

    @Override
    protected void addSchemaDetails(SchemaSqlServer schema, ModelIdObjectSelection parent) {
        super.addSchemaDetails(schema, parent);
        this.addContainerObjects(SEQUENCES, parent, this.getSequencesForSchema(schema), this.getSequenceList());
        this.sort();
    }

    private List getSequencesWithNullSchema(DataBaseSqlServer db) {
        ArrayList<SequenceSqlServerv2k12> list = new ArrayList<SequenceSqlServerv2k12>();
        if (this.getStorageDesign() instanceof StorageDesignSqlServerv2k12) {
            for (SequenceSqlServerv2k12 seq : ((StorageDesignSqlServerv2k12)this.getStorageDesign()).getSequenceSet()) {
                if (seq.getSchema() != null || !db.equals(seq.getDatabase())) continue;
                list.add(seq);
            }
        }
        return list;
    }

    private List getSequencesForSchema(SchemaSqlServer schema) {
        ArrayList<SequenceSqlServerv2k12> list = new ArrayList<SequenceSqlServerv2k12>();
        if (this.getStorageDesign() instanceof StorageDesignSqlServerv2k12) {
            for (SequenceSqlServerv2k12 seq : ((StorageDesignSqlServerv2k12)this.getStorageDesign()).getSequenceSet()) {
                if ((schema == null || seq.getSchema() == null || !seq.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) && (schema != null || seq.getSchema() != null)) continue;
                list.add(seq);
            }
        }
        return list;
    }

    public List getSequenceList() {
        if (this.sequenceList == null) {
            this.sequenceList = new ArrayList();
        }
        return this.sequenceList;
    }
}

