/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.xtdmapping;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DesignPartListener;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.MappingCollector;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;

public class ExtendedMapBase
implements DesignPartListener,
RepositoryObject,
StorableObject {
    public static final String NAME = "ExtendedMap";
    protected Map collectorMap = new TreeMap();
    protected Map mappings = new TreeMap();
    private Design design;
    protected Map deletedMappings = new TreeMap();
    private String repositoryOID = null;
    private String repositoryOVID = null;
    private RepositoryObject pac_Element;
    public boolean dirty = false;
    protected RelationalDesign relationalModel;
    private boolean loadedCompletely = false;

    public ExtendedMapBase(Design design) {
        this.design = design;
    }

    @Override
    public Design getDesign() {
        return this.design;
    }

    public void clearMappings() {
        this.collectorMap.clear();
        this.mappings.clear();
        this.deletedMappings.clear();
    }

    public void clearMappingsMaps() {
        this.mappings.clear();
        this.deletedMappings.clear();
    }

    public XtdMapping getMapping(String ownerID, String targetID) {
        return (XtdMapping)this.mappings.get(ownerID + targetID);
    }

    public XtdMapping getMapping(DesignObject owner, DesignObject target) {
        String targetID;
        String ownerID = owner.getObjectID();
        XtdMapping mapping = (XtdMapping)this.mappings.get(ownerID + (targetID = target.getObjectID()));
        if (mapping == null) {
            mapping = (XtdMapping)this.mappings.get(owner.getShortObjectID() + target.getShortObjectID());
        }
        return mapping;
    }

    private void addMapping(String ownerID, String targetID, XtdMapping mapping) {
        DesignPartView dpv;
        DesignObject target;
        DesignPartView dpv2;
        this.mappings.put(mapping.getID(), mapping);
        DesignObject owner = this.getDesign().getDesignObject(ownerID);
        if (owner == null && (dpv2 = this.getDesign().getLogicalDesign().getSubViewByID(ownerID)) != null) {
            owner = dpv2.getPlaceHolder();
        }
        if ((target = this.getDesign().getDesignObject(targetID)) == null && this.relationalModel != null && (dpv = this.relationalModel.getSubViewByID(targetID)) != null) {
            target = dpv.getPlaceHolder();
        }
        if (owner != null && target != null) {
            this.getOrCreateCollector(owner).addMapping(mapping);
            this.getOrCreateCollector(target).addMapping(mapping);
        } else {
            this.getOrCreateCollector(ownerID).addMapping(mapping);
            this.getOrCreateCollector(targetID).addMapping(mapping);
        }
    }

    public void restoreDeletedMapping(XtdMapping mapping, DesignObject object) {
        RelationalDesign rd;
        DesignObject dobj = mapping.getRelationalObject();
        if (dobj != null && dobj.getDesignPart() instanceof RelationalDesign && (rd = (RelationalDesign)dobj.getDesignPart()).getRMExtendedMap() != this) {
            rd.getRMExtendedMap().restoreDeletedMapping(mapping, object);
            return;
        }
        mapping.clearDeletedID();
        mapping.restoreObject(object);
        this.addMapping(mapping.getOwnerID(), mapping.getTargetID(), mapping);
        this.deletedMappings.remove(mapping.getID());
    }

    protected void addMapping(String ownerID, String targetID, String deletedID, XtdMapping mapping) {
        this.deletedMappings.put(mapping.getID(), mapping);
        this.setRMDeletedMapAsDirty();
        this.getOrCreateCollector(mapping.getOtherID(deletedID)).addMapping(mapping);
    }

    protected void addMapping(DesignObject owner, DesignObject target, XtdMapping mapping) {
        this.mappings.put(mapping.getID(), mapping);
        this.getOrCreateCollector(owner).addMapping(mapping);
        this.getOrCreateCollector(target).addMapping(mapping);
    }

    public MappingCollector getOrCreateCollector(DesignObject owner) {
        if (owner.getDesignPart() instanceof RelationalDesign) {
            return ((RelationalDesign)owner.getDesignPart()).getRMExtendedMap().getOrCreateCollector(owner);
        }
        String ownerID = owner.getObjectID();
        MappingCollector mc = (MappingCollector)this.collectorMap.get(ownerID);
        if (mc == null) {
            mc = new MappingCollector(this.getDesign(), ownerID);
            this.collectorMap.put(ownerID, mc);
        }
        return mc;
    }

    protected MappingCollector getOrCreateCollector(String ownerID) {
        MappingCollector mc = (MappingCollector)this.collectorMap.get(ownerID);
        if (mc == null) {
            mc = new MappingCollector(this.getDesign(), ownerID);
            this.collectorMap.put(ownerID, mc);
        }
        return mc;
    }

    protected MappingCollector getCollector(String ownerID) {
        return (MappingCollector)this.collectorMap.get(ownerID);
    }

    public XtdMapping createMapping(String ownerID, String targetID) {
        XtdMapping mapping = this.getMapping(ownerID, targetID);
        if (mapping == null) {
            mapping = new XtdMapping(ownerID, targetID, this.design);
            this.addMapping(ownerID, targetID, mapping);
        }
        return mapping;
    }

    public XtdMapping createMapping(String ownerID, String targetID, String deletedID) {
        XtdMapping mapping = this.getMapping(ownerID, targetID);
        if (mapping == null) {
            mapping = new XtdMapping(ownerID, targetID, this.design);
            mapping.setDeletedID(deletedID);
            this.addMapping(ownerID, targetID, deletedID, mapping);
        }
        return mapping;
    }

    public XtdMapping createMapping(DesignObject owner, DesignObject target) {
        XtdMapping mapping = this.getMapping(owner, target);
        if (mapping == null && (mapping = this.getMapping(target, owner)) == null) {
            if (owner.getDesignPart() instanceof LogicalDesign) {
                mapping = new XtdMapping(owner, target);
                this.addMapping(owner, target, mapping);
            } else {
                mapping = new XtdMapping(target, owner);
                this.addMapping(target, owner, mapping);
            }
            this.dirty = true;
        }
        return mapping;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeAllMappingsFor(String objectID) {
        if (objectID != null) {
            MappingCollector mc = (MappingCollector)this.collectorMap.get(objectID);
            if (mc == null && this.getDesign().getExtendedMap() != this) {
                mc = this.getDesign().getExtendedMap().getCollector(objectID);
            }
            if (mc != null) {
                Object[] maps = mc.getAllMappings().toArray();
                for (int i = 0; i < maps.length; ++i) {
                    XtdMapping xm = (XtdMapping)maps[i];
                    if (!xm.isDeleted()) {
                        xm.setDeletedID(objectID);
                        this.mappings.remove(xm.getID());
                        this.deletedMappings.put(xm.getID(), xm);
                        xm.resetNameFor(objectID);
                        this.setRMDeletedMapAsDirty();
                        DesignObject dobj = xm.getRelationalObject();
                        if (dobj != null && dobj.getDesignPart() == null) {
                            // empty if block
                        }
                    } else {
                        Object obj = this.deletedMappings.remove(xm.getID());
                        if (obj != null) {
                            this.setRMDeletedMapAsDirty();
                        }
                    }
                    this.setDirty(true);
                }
                mc.clearAllMappings();
                if (this.relationalModel != null) {
                    this.collectorMap.remove(objectID);
                }
            }
        }
    }

    private void removeAllMappingsFor_NoDeletedTracking(String objectID) {
        MappingCollector mc;
        if (objectID != null && (mc = (MappingCollector)this.collectorMap.get(objectID)) != null) {
            Object[] maps = mc.getAllMappings().toArray();
            for (int i = 0; i < maps.length; ++i) {
                XtdMapping xm = (XtdMapping)maps[i];
                if (!xm.isDeleted()) {
                    this.mappings.remove(xm.getOwnerID() + xm.getTargetID());
                    continue;
                }
                this.deletedMappings.remove(xm.getID());
                this.setRMDeletedMapAsDirty();
            }
            mc.clearAllMappings();
            this.collectorMap.remove(objectID);
        }
    }

    public void removeMapping(XtdMapping mapping) {
        DesignObject robj = mapping.getRelationalObject();
        DesignObject lobj = mapping.getLogicalObject();
        this.justRemoveMapping(mapping);
        if (robj != null && !(this instanceof RMExtendedMap)) {
            ((RelationalDesign)robj.getDesignPart()).getRMExtendedMap().justRemoveMapping(mapping);
        }
        if (lobj != null && !(this instanceof ExtendedMap)) {
            lobj.getDesign().getExtendedMap().justRemoveMapping(mapping);
        }
    }

    public void justRemoveMapping(XtdMapping mapping) {
        if (mapping.isDeleted()) {
            String other = mapping.getOtherID(mapping.getDeletedID());
            if (other != null) {
                Object obj;
                MappingCollector mc = (MappingCollector)this.collectorMap.get(other);
                if (mc != null) {
                    mc.removeMapping(mapping);
                }
                if ((obj = this.deletedMappings.remove(mapping.getID())) != null) {
                    this.setRMDeletedMapAsDirty();
                }
            }
        } else {
            MappingCollector mct;
            String ownerID = mapping.getOwnerID();
            String targetID = mapping.getTargetID();
            MappingCollector mc = (MappingCollector)this.collectorMap.get(ownerID);
            if (mc != null) {
                mc.removeMapping(mapping);
                if (mc.isEmpty()) {
                    this.collectorMap.remove(ownerID);
                }
            }
            if ((mct = (MappingCollector)this.collectorMap.get(targetID)) != null) {
                mct.removeMapping(mapping);
                if (mct.isEmpty()) {
                    this.collectorMap.remove(targetID);
                }
            }
            this.mappings.remove(mapping.getID());
            this.mappings.remove(targetID + ownerID);
            this.mappings.remove(ownerID + targetID);
        }
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject object) {
    }

    @Override
    public void objectRemoved(DesignPart designPart, DesignObject object) {
        if (this.isModelLoaded()) {
            MappingCollector mc;
            if (!designPart.getDesign().isCleaning() && this.isLM_RM_Object(object)) {
                if (designPart.isDeleting()) {
                    this.removeAllMappingsFor_NoDeletedTracking(object.getObjectID());
                } else {
                    this.removeAllMappingsFor(object.getObjectID());
                }
            } else if (designPart.getDesign().isCleaning() && this.isLM_RM_Object(object) && (mc = (MappingCollector)this.collectorMap.get(object.getObjectID())) != null) {
                mc.nullifyObjects();
            }
        }
    }

    private boolean isLM_RM_Object(DesignObject object) {
        if (object.getDesignPart() instanceof LogicalDesign) {
            return true;
        }
        return object.getDesignPart() instanceof RelationalDesign;
    }

    public List getMappingsForDesignPart(DesignObject owner, String desPartID) {
        MappingCollector mc = this.getOrCreateCollector(owner);
        return mc.getMappingsForDesignPart(desPartID);
    }

    public List getDeletedMappingsForDesignPart(DesignObject owner, String desPartID) {
        MappingCollector mc = this.getOrCreateCollector(owner);
        return mc.getDeletedMappingsForDesignPart(desPartID);
    }

    public List getAllDeletedMappings(DesignObject owner) {
        MappingCollector mc = this.getOrCreateCollector(owner);
        return mc.getAllDeletedMappings();
    }

    public Map getMappings() {
        return this.mappings;
    }

    public void load() {
        XMLPersistenceManager pm = this.design.getAppView().getPersistenceManager();
        this.design.getAppView().setCurrentDesign(this.design);
        AbstractXMLReader reader = pm.getExtendedMapReader();
        reader.recreateDesign(NAME, null, false);
    }

    public List getDeletedMappings() {
        if (this.deletedMappings.size() > 0) {
            ArrayList list = new ArrayList();
            list.addAll(this.deletedMappings.values());
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public XtdMapping getDeletedMappingByID(String id) {
        return (XtdMapping)this.deletedMappings.get(id);
    }

    @Override
    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    @Override
    public void setRepositoryOID(String repositoryOID) {
        this.repositoryOID = repositoryOID;
    }

    @Override
    public String getRepositoryOVID() {
        return this.repositoryOVID;
    }

    @Override
    public void setRepositoryOVID(String repositoryOVID) {
        this.repositoryOVID = repositoryOVID;
    }

    public List getAllMappings() {
        if (this.mappings.size() > 0 || this.deletedMappings.size() > 0) {
            ArrayList list = new ArrayList();
            list.addAll(this.mappings.values());
            list.addAll(this.deletedMappings.values());
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean canBedeleted() {
        return false;
    }

    @Override
    public String getCheckedOutBy() {
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isCheckedOut() {
        return false;
    }

    @Override
    public boolean isCheckedOutByMe() {
        return false;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setCheckedOut(boolean checkedOut) {
    }

    @Override
    public void setCheckedOutBy(String checkedOutBy) {
    }

    @Override
    public void setCheckedOutByMe(boolean checkedOutByMe) {
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        return this.pac_Element;
    }

    @Override
    public boolean isPAC_Element() {
        return true;
    }

    @Override
    public void setPAC_Element(RepositoryObject object) {
        this.pac_Element = object;
    }

    @Override
    public String getStorageName() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "mapping" + File.separatorChar + "ExtendedMap.xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStoragePath() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "mapping").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public XtdMapping createMapping() {
        XtdMapping mapping = new XtdMapping(null, null, this.getDesign());
        return mapping;
    }

    public void addMapping(XtdMapping mapping) {
        if (mapping.isDeleted()) {
            this.addMapping(mapping.getOwnerID(), mapping.getTargetID(), mapping.getDeletedID(), mapping);
        } else {
            this.addMapping(mapping.getOwnerID(), mapping.getTargetID(), mapping);
        }
    }

    public XtdMapping getMappingByID(String id) {
        XtdMapping mapping = (XtdMapping)this.mappings.get(id);
        if (mapping == null) {
            return (XtdMapping)this.deletedMappings.get(id);
        }
        return mapping;
    }

    public void removeAllMappingsForDesignPart(String dpId) {
        ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
        if (dpId != null && !"".equals(dpId)) {
            for (String key : this.mappings.keySet()) {
                XtdMapping mapping = (XtdMapping)this.mappings.get(key);
                if (mapping == null || !dpId.equalsIgnoreCase(mapping.getTargetDesignPartID()) && !dpId.equalsIgnoreCase(mapping.getOwnerDesignPartID())) continue;
                list.add(mapping);
            }
            for (XtdMapping mapping : list) {
                if (mapping == null) continue;
                this.removeMapping(mapping);
            }
            list.clear();
            for (XtdMapping mapping : this.deletedMappings.values()) {
                if (mapping == null || !dpId.equalsIgnoreCase(mapping.getTargetDesignPartID()) && !dpId.equalsIgnoreCase(mapping.getOwnerDesignPartID())) continue;
                list.add(mapping);
            }
            for (XtdMapping mapping : list) {
                if (mapping == null) continue;
                this.removeMapping(mapping);
            }
        }
    }

    public void checkAndCleanMappings() {
        ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
        for (XtdMapping mapping : this.mappings.values()) {
            if (mapping == null || mapping.getOwnerDesignPart() != null && mapping.getTargetDesignPart() != null) continue;
            list.add(mapping);
        }
        for (XtdMapping mapping : list) {
            if (mapping == null) continue;
            this.removeMapping(mapping);
        }
        list.clear();
        for (XtdMapping mapping : this.deletedMappings.values()) {
            if (mapping == null || mapping.getOwnerDesignPart() != null && mapping.getTargetDesignPart() != null) continue;
            list.add(mapping);
        }
        for (XtdMapping mapping : list) {
            if (mapping == null) continue;
            this.removeMapping(mapping);
        }
    }

    public boolean isModelLoaded() {
        return this.relationalModel == null || this.relationalModel.isLoaded();
    }

    public void removeCollectorFor(String id) {
        this.collectorMap.remove(id);
    }

    public void setRMDeletedMapAsDirty() {
        if (this.relationalModel != null) {
            this.relationalModel.getRMDeletedMap().setDirty(true);
        }
    }

    @Override
    public boolean isLoadedCompletely() {
        return this.loadedCompletely;
    }

    @Override
    public void setLoadedCompletely(boolean loadedCompletely) {
        this.loadedCompletely = loadedCompletely;
    }
}

