/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata.compare;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.GeneralPropertiesComparator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.compare.MetaPropertyHolder;
import oracle.dbtools.crest.model.xtdmapping.RelMapping;

public class MetaPropertiesComparator
implements GeneralPropertiesComparator,
MDXMLConstants {
    public static boolean considerChangeTime = false;
    protected List propertiesList = new ArrayList();
    protected boolean isDroped = false;
    protected boolean caseSensitive = false;
    protected boolean useSchema = true;
    protected boolean useDataTypeKind = false;
    private CompareObjectSelection selectionObject;
    private Map leftMap;
    private Map rightMap;
    private ClassDescription cd;
    private Design design;
    boolean plainMap = false;
    private static final String CREATED_BY = "createdBy";
    private static final String CREATED_TIME = "createdTime";
    private static final String CHANGED_BY = "changedBy";
    private static final String CHANGED_TIME = "changedTime";
    private StorageDesign storageDesign;
    private boolean readOnly = false;

    public MetaPropertiesComparator() {
        this(null, null, null, null, null);
    }

    public MetaPropertiesComparator(Map leftMap, Map rightMap, ClassDescription cd, Design design, StorageDesign storageDesign) {
        this.leftMap = leftMap;
        this.rightMap = rightMap;
        this.cd = cd;
        this.design = design;
        this.storageDesign = storageDesign;
        this.initPropertiesList();
    }

    public MetaPropertiesComparator(Map leftMap, Map rightMap, boolean plainMap, Design design, StorageDesign storageDesign) {
        this.leftMap = leftMap;
        this.rightMap = rightMap;
        this.cd = null;
        this.plainMap = true;
        this.design = design;
        this.storageDesign = storageDesign;
        this.initPropertiesList();
    }

    protected void initPropertiesList() {
        if (this.cd != null) {
            ArrayList<ClassDescription.PropertyDescription> list = new ArrayList<ClassDescription.PropertyDescription>();
            for (ClassDescription.PropertyDescription pd : this.cd.getPropertiesList()) {
                if (!pd.isReferred() && !pd.isSimpleClass() && !pd.isStringClass() && !pd.isRectangle) continue;
                if (this.isLoggingProperty(pd)) {
                    list.add(pd);
                    continue;
                }
                this.processProperty(pd, this.cd);
            }
            this.processPoints(this.cd);
            for (ClassDescription.PropertyDescription pd : list) {
                this.processProperty(pd, this.cd);
            }
        }
        if (this.plainMap) {
            this.processPropertiesMap(this.leftMap, this.rightMap);
        }
    }

    public ClassDescription getClassDescription() {
        return this.cd;
    }

    private void processProperty(ClassDescription.PropertyDescription pd, ClassDescription cd) {
        if (pd.isRectangle) {
            this.processRectangle(pd);
            return;
        }
        if (pd.isPropertyMap || pd.isMap) {
            Map lmap = null;
            if (this.leftMap != null) {
                lmap = (Map)this.leftMap.get(pd.xmlName);
            }
            Map rmap = null;
            if (this.rightMap != null) {
                rmap = (Map)this.rightMap.get(pd.xmlName);
            }
            if (lmap != null || rmap != null) {
                this.processPropertiesMap(lmap, rmap);
            }
            return;
        }
        if (pd.isSimpleClass() || pd.isStringClass() || pd.isReferred()) {
            String left = null;
            if (this.leftMap != null) {
                left = (String)this.leftMap.get(pd.xmlName);
            }
            String right = null;
            if (this.rightMap != null) {
                right = (String)this.rightMap.get(pd.xmlName);
            }
            if (left != null || right != null) {
                String value;
                ModelIDObject obj;
                MetaPropertyHolder ph = new MetaPropertyHolder(pd, this.leftMap, this.rightMap);
                if (left != null) {
                    if (!left.equals(right)) {
                        ph.setModified(true);
                        ph.setSelected(true);
                    }
                    if (pd.isReferred() && !pd.isSimpleClass() && !pd.isStringClass() || RelMapping.class.isAssignableFrom(cd.objectClass)) {
                        obj = this.getObject(left);
                        if (obj != null) {
                            ph.setLeftValuePresentation(obj.getName() + " / " + left);
                        }
                    } else if (pd.hasCodedEnum()) {
                        value = (String)pd.getCoddedEnumMap().get(left);
                        if (value != null) {
                            ph.setLeftValuePresentation(value);
                        }
                    } else if (pd.isListOfRefs) {
                        ph.setLeftValuePresentation(this.getListOfRefsPresentation(left));
                    }
                    ph.setLeftValue(left);
                    if (right == null) {
                        ph.setRightValuePresentation(pd.defaultValue);
                    }
                }
                if (right != null) {
                    if (!right.equals(left)) {
                        ph.setModified(true);
                        ph.setSelected(true);
                    }
                    if (pd.isReferred() && !pd.isSimpleClass() && !pd.isStringClass() || RelMapping.class.isAssignableFrom(cd.objectClass)) {
                        obj = this.getObject(right);
                        if (obj != null) {
                            ph.setRightValuePresentation(obj.getName() + " / " + right);
                        }
                    } else if (pd.hasCodedEnum()) {
                        value = (String)pd.getCoddedEnumMap().get(right);
                        if (value != null) {
                            ph.setRightValuePresentation(value);
                        }
                    } else if (pd.isListOfRefs) {
                        ph.setRightValuePresentation(this.getListOfRefsPresentation(right));
                    }
                    ph.setRightValue(right);
                    if (left == null) {
                        ph.setLeftValuePresentation(pd.defaultValue);
                    }
                }
                this.propertiesList.add(ph);
            }
        } else if (!pd.isReferred()) {
            // empty if block
        }
    }

    private String getListOfRefsPresentation(String listOfRefs) {
        Object result = null;
        String[] ids = listOfRefs.split(" ");
        for (int i = 0; i < ids.length; ++i) {
            ModelObject obj = null;
            if (this.design != null) {
                obj = this.design.getDesignObject(ids[i]);
            }
            if (result == null) {
                if (obj != null) {
                    result = obj.getName() + " / " + ids[i];
                    continue;
                }
                result = ids[i];
                continue;
            }
            result = obj != null ? (String)result + "\n" + obj.getName() + " / " + ids[i] : (String)result + "\n" + ids[i];
        }
        return result;
    }

    private void processPropertiesMap(Map leftMap, Map rightMap) {
        if (leftMap != null || rightMap != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (leftMap != null) {
                list.addAll(leftMap.keySet());
            }
            if (rightMap != null) {
                if (leftMap == null) {
                    list.addAll(rightMap.keySet());
                } else {
                    for (String string : rightMap.keySet()) {
                        if (list.contains(string)) continue;
                        list.add(string);
                    }
                }
            }
            Collections.sort(list, ModelObjectSet.TOSTRING_COMPARATOR);
            for (String string : list) {
                ModelIDObject obj;
                String left = null;
                if (leftMap != null) {
                    left = (String)leftMap.get(string);
                }
                String right = null;
                if (rightMap != null) {
                    right = (String)rightMap.get(string);
                }
                if (left == null && right == null) continue;
                MetaPropertyHolder ph = new MetaPropertyHolder(string);
                if (left != null) {
                    if (!left.equals(right)) {
                        ph.setModified(true);
                        ph.setSelected(true);
                    }
                    if ((obj = this.getObject(left)) != null) {
                        ph.setLeftValuePresentation(obj.getName() + " / " + left);
                    }
                    ph.setLeftValue(left);
                }
                if (right != null) {
                    if (!right.equals(left)) {
                        ph.setModified(true);
                        ph.setSelected(true);
                    }
                    if ((obj = this.getObject(right)) != null) {
                        ph.setRightValuePresentation(obj.getName() + " / " + right);
                    }
                    ph.setRightValue(right);
                }
                this.propertiesList.add(ph);
            }
        }
    }

    @Override
    public List getPropertiesList() {
        return this.propertiesList;
    }

    @Override
    public void copySelectedProperties() {
        for (MetaPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.isModified() || !ph.isSelected() || ph.isFiltered()) continue;
            ClassDescription.PropertyDescription pd = ph.getPropertyDescription();
            if (pd != null) {
                if (this.rightMap == null) continue;
                if (pd.isRectangle) {
                    if (ph.getLeftMap() == null || ph.getRightMap() == null) continue;
                    ph.getRightMap().clear();
                    ph.getRightMap().putAll(ph.getLeftMap());
                    continue;
                }
                if (pd.isMergeCompare && ph.isMerged()) {
                    this.rightMap.put(pd.xmlName, ph.getRightValue());
                    continue;
                }
                this.rightMap.put(pd.xmlName, ph.getLeftValue());
                continue;
            }
            if (this.rightMap == null) continue;
            if ("points".equalsIgnoreCase(ph.getName())) {
                this.rightMap.put(ph.getName(), this.leftMap.get("points"));
                continue;
            }
            this.rightMap.put(ph.getName(), ph.getLeftValue());
        }
    }

    @Override
    public String getLeftName() {
        if (this.leftMap != null) {
            String name = (String)this.leftMap.get("xmlName");
            if (name == null) {
                name = (String)this.leftMap.get("oldXmlName");
            }
            if (name != null) {
                return name;
            }
        }
        return "";
    }

    @Override
    public String getRightName() {
        if (this.rightMap != null) {
            String name = (String)this.rightMap.get("xmlName");
            if (name == null) {
                name = (String)this.rightMap.get("oldXmlName");
            }
            if (name != null) {
                return name;
            }
        }
        return "";
    }

    protected void copyPropertiesFromLeftToRight() {
    }

    @Override
    public boolean isModified() {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.isModified() || ph.isFiltered() || CHANGED_TIME.equals(ph.getName()) && !considerChangeTime) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getID() {
        if (this.leftMap != null && this.rightMap != null) {
            String lid = (String)this.leftMap.get("id");
            String rid = (String)this.rightMap.get("id");
            if (lid != null && rid != null) {
                return lid + rid;
            }
        }
        return "null";
    }

    protected boolean hasToBeRename() {
        return false;
    }

    protected boolean hasToBeDrop() {
        return false;
    }

    protected boolean isDirty() {
        for (EngPropertyHolder ph : this.propertiesList) {
            if (!ph.isModified() || !ph.isSelected()) continue;
            return true;
        }
        return false;
    }

    public CompareObjectSelection getLeftSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareObjectSelection selectionObject) {
        this.selectionObject = selectionObject;
    }

    public String getChoosedPropertyValue(String propertyName) {
        for (EngPropertyHolder ph : this.propertiesList) {
            if (!ph.getName().equals(propertyName)) continue;
            if (ph.isSelected()) {
                return ph.getLeftValue();
            }
            return ph.getRightValue();
        }
        return "";
    }

    public EngPropertyHolder getPropertyHolderByName(String name) {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.getName().equals(name)) continue;
            return ph;
        }
        return null;
    }

    public boolean isDDLModified() {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.isSelected() || !ph.isDDLHolder()) continue;
            return true;
        }
        return false;
    }

    private ModelIDObject getObject(String id) {
        ModelIDObject obj;
        if (this.design != null && (obj = this.design.getDesignObject(id)) != null) {
            return obj;
        }
        if (this.storageDesign != null) {
            obj = this.storageDesign.getStorageObject(id);
            return obj;
        }
        return null;
    }

    private void processRectangle(ClassDescription.PropertyDescription pd) {
        Map lmap = null;
        if (this.leftMap != null) {
            lmap = (Map)this.leftMap.get(pd.xmlName);
        }
        Map rmap = null;
        if (this.rightMap != null) {
            rmap = (Map)this.rightMap.get(pd.xmlName);
        }
        Object left = null;
        if (lmap != null) {
            Integer x = (Integer)lmap.get("x");
            Integer y = (Integer)lmap.get("y");
            Integer w = (Integer)lmap.get("width");
            Integer h = (Integer)lmap.get("height");
            if (x != null) {
                left = String.valueOf(x) + "," + String.valueOf(y) + "," + String.valueOf(w) + "," + String.valueOf(h);
            }
        }
        Object right = null;
        if (rmap != null) {
            Integer x = (Integer)rmap.get("x");
            Integer y = (Integer)rmap.get("y");
            Integer w = (Integer)rmap.get("width");
            Integer h = (Integer)rmap.get("height");
            if (x != null) {
                right = String.valueOf(x) + "," + String.valueOf(y) + "," + String.valueOf(w) + "," + String.valueOf(h);
            }
        }
        if (left != null || right != null) {
            MetaPropertyHolder ph = new MetaPropertyHolder(pd, lmap, rmap);
            if (left != null) {
                if (!((String)left).equals(right)) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
                ph.setLeftValue((String)left);
            }
            if (right != null) {
                if (!((String)right).equals(left)) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
                ph.setRightValue((String)right);
            }
            this.propertiesList.add(ph);
        }
    }

    private void processPoints(ClassDescription cd) {
        List lpoints = (List)this.leftMap.get("points");
        if (lpoints != null) {
            List rpoints = null;
            if (this.rightMap != null) {
                rpoints = (List)this.rightMap.get("points");
            }
            Object left = null;
            Object right = null;
            for (Point2D p : lpoints) {
                if (left == null) {
                    left = String.valueOf((int)p.getX()) + "/" + String.valueOf((int)p.getY());
                    continue;
                }
                left = (String)left + "  \n" + String.valueOf((int)p.getX()) + "/" + String.valueOf((int)p.getY());
            }
            if (rpoints != null) {
                for (Point2D p : rpoints) {
                    if (right == null) {
                        right = String.valueOf((int)p.getX()) + "/" + String.valueOf((int)p.getY());
                        continue;
                    }
                    right = (String)right + "  \n" + String.valueOf((int)p.getX()) + "/" + String.valueOf((int)p.getY());
                }
            }
            MetaPropertyHolder ph = new MetaPropertyHolder("points");
            ph.setPresentationName("points ( x/y  ...)");
            if (left != null) {
                if (!((String)left).equals(right)) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
                ph.setLeftValue((String)left);
                ph.setLeftValuePresentation((String)left);
            }
            if (right != null) {
                if (!((String)right).equals(left)) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
                ph.setRightValue((String)right);
                ph.setRightValuePresentation((String)right);
            }
            this.propertiesList.add(ph);
        }
    }

    private boolean isLoggingProperty(ClassDescription.PropertyDescription pd) {
        return CREATED_BY.equals(pd.name) || CREATED_TIME.equals(pd.name) || CHANGED_BY.equals(pd.name) || CHANGED_TIME.equals(pd.name);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }
}

