/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRRuleExpressionEmpty
extends AbstractDRStorageDesign {
    private final String RULE_ID = "3FF8354D-C2D3-083C-6B2F-760EE4C7C7F7";

    public DRRuleExpressionEmpty(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRRuleExpressionEmpty.CheckForEmptyRuleExpression"));
        this.setDescription(Messages.getString("DRRuleExpressionEmpty.TheRuleExpressionShouldNotBeEmpty"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        RuleSqlServer rule = (RuleSqlServer)object;
        if ("".equalsIgnoreCase(rule.getExpression())) {
            return CheckResult.createFailed(object, this, Messages.getString("DRRuleExpressionEmpty.TheRuleExpressionIsEmpty"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRRuleExpressionEmpty.TheRuleExpressionIsNotEmpty"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "3FF8354D-C2D3-083C-6B2F-760EE4C7C7F7";
    }
}

